/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.vampirestudios.raa.RandomlyAddingAnything;
import io.github.vampirestudios.raa.api.enums.OreType;
import io.github.vampirestudios.raa.config.RAADataConfig;
import io.github.vampirestudios.raa.generation.materials.Material;
import io.github.vampirestudios.raa.generation.materials.data.CustomArmorMaterial;
import io.github.vampirestudios.raa.registries.Materials;
import io.github.vampirestudios.raa.utils.GsonUtils;
import io.github.vampirestudios.raa.utils.Rands;
import java.io.FileWriter;
import java.util.Arrays;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class MaterialsConfig
extends RAADataConfig {
    public MaterialsConfig(String fileName) {
        super(fileName);
    }

    @Override
    public void generate() {
        Materials.generate();
    }

    @Override
    protected JsonObject upgrade(JsonObject json, int version) {
        JsonArray materialsArray = class_3518.method_15261((JsonObject)json, (String)"materials");
        switch (version) {
            case 0: {
                MaterialsConfig.iterateArrayObjects(materialsArray, material -> {
                    JsonElement armorMaterialJson;
                    CustomArmorMaterial armorMaterial;
                    material.addProperty("color", (Number)class_3518.method_15260((JsonObject)material, (String)"rgb"));
                    if (class_3518.method_15270((JsonObject)material, (String)"armor")) {
                        armorMaterial = CustomArmorMaterial.generate(new class_2960(class_3518.method_15265((JsonObject)material, (String)"id")), OreType.valueOf(class_3518.method_15265((JsonObject)material, (String)"oreType")));
                        armorMaterialJson = GsonUtils.getGson().toJsonTree((Object)armorMaterial);
                        material.add("armorMaterial", armorMaterialJson);
                    }
                    if (class_3518.method_15270((JsonObject)material, (String)"tools")) {
                        armorMaterial = CustomArmorMaterial.generate(new class_2960(class_3518.method_15265((JsonObject)material, (String)"id")), OreType.valueOf(class_3518.method_15265((JsonObject)material, (String)"oreType")));
                        armorMaterialJson = GsonUtils.getGson().toJsonTree((Object)armorMaterial);
                        material.add("armorMaterial", armorMaterialJson);
                    }
                    JsonObject oreInformationOld = material.getAsJsonObject("oreInformationJSON");
                    JsonObject oreInformationNew = new JsonObject();
                    material.add("oreInformation", (JsonElement)oreInformationNew);
                    oreInformationNew.add("oreType", oreInformationOld.get("oreTypes"));
                    oreInformationNew.add("generateIn", oreInformationOld.get("generatesIn"));
                    oreInformationNew.add("overlayTexture", oreInformationOld.get("overlayTexture"));
                    oreInformationNew.addProperty("maxXPAmount", (Number)Rands.randIntRange(0, 4));
                    oreInformationNew.addProperty("oreClusterSize", (Number)Rands.randIntRange(2, 6));
                });
                break;
            }
            case 1: {
                MaterialsConfig.iterateArrayObjects(materialsArray, material -> {
                    JsonObject oreInformation;
                    if (!material.has("id") || !class_3518.method_15286((JsonElement)material.get("id"))) {
                        material.addProperty("id", "raa:" + RandomlyAddingAnything.CONFIG.namingLanguage.getMaterialNameGenerator().asId(class_3518.method_15265((JsonObject)material, (String)"name")));
                    }
                    if (!material.has("miningLevel")) {
                        material.addProperty("miningLevel", (Number)Rands.randInt(4));
                    }
                    if (material.has("nuggetTexture") && !class_3518.method_15286((JsonElement)material.get("nuggetTexture"))) {
                        material.addProperty("nuggetTexture", GsonUtils.idFromOldStyle(class_3518.method_15296((JsonObject)material, (String)"nuggetTexture")).toString());
                    }
                    if (!material.has("food")) {
                        material.addProperty("food", Boolean.valueOf(Rands.chance(4)));
                    }
                    if (!class_3518.method_15286((JsonElement)(oreInformation = material.getAsJsonObject("oreInformation")).get("overlayTexture"))) {
                        oreInformation.addProperty("overlayTexture", GsonUtils.idFromOldStyle(class_3518.method_15296((JsonObject)oreInformation, (String)"overlayTexture")).toString());
                    }
                    oreInformation.add("generatesIn", oreInformation.get("generateIn"));
                    oreInformation.addProperty("minXPAmount", (Number)0);
                    if (!class_3518.method_15286((JsonElement)material.get("resourceItemTexture"))) {
                        material.addProperty("resourceItemTexture", GsonUtils.idFromOldStyle(class_3518.method_15296((JsonObject)material, (String)"resourceItemTexture")).toString());
                    }
                    if (!class_3518.method_15286((JsonElement)material.get("storageBlockTexture"))) {
                        material.addProperty("storageBlockTexture", GsonUtils.idFromOldStyle(class_3518.method_15296((JsonObject)material, (String)"storageBlockTexture")).toString());
                    }
                });
                break;
            }
        }
        return json;
    }

    @Override
    protected void load(JsonObject jsonObject) {
        Material[] materials = (Material[])GsonUtils.getGson().fromJson((JsonElement)class_3518.method_15261((JsonObject)jsonObject, (String)"materials"), Material[].class);
        Arrays.stream(materials).forEach(material -> {
            if (material.getArmorMaterial() != null) {
                material.getArmorMaterial().setMaterialId(material.getId());
                material.getArmorMaterial().setOreType(material.getOreInformation().getOreType());
            }
            if (material.getToolMaterial() != null) {
                material.getToolMaterial().setMaterialId(material.getId());
                material.getToolMaterial().setOreType(material.getOreInformation().getOreType());
            }
            class_2378.method_10230(Materials.MATERIALS, (class_2960)material.getId(), (Object)material);
        });
    }

    @Override
    protected void save(FileWriter fileWriter) {
        JsonObject main = new JsonObject();
        main.add("materials", GsonUtils.getGson().toJsonTree(Materials.MATERIALS.method_10220().toArray(Material[]::new)));
        main.addProperty("configVersion", (Number)2);
        GsonUtils.getGson().toJson((JsonElement)main, (Appendable)fileWriter);
    }
}

