/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.vampirestudios.raa.RandomlyAddingAnything;
import io.github.vampirestudios.raa.utils.GsonUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3518;

public abstract class RAADataConfig {
    public static final int CURRENT_VERSION = 2;
    public static final File CONFIG_PATH = new File(FabricLoader.getInstance().getConfigDirectory(), "raa");
    private final File configFile;

    protected RAADataConfig(String fileName) {
        this.configFile = new File(CONFIG_PATH, fileName + ".json");
    }

    protected static void iterateArrayObjects(JsonArray jsonArray, Consumer<JsonObject> runnable) {
        for (JsonElement jsonElement : jsonArray) {
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                try {
                    runnable.accept(jsonObject);
                }
                catch (Throwable e) {
                    RandomlyAddingAnything.LOGGER.warn("Couldn't process array entry: " + jsonObject);
                    e.printStackTrace();
                }
                continue;
            }
            RandomlyAddingAnything.LOGGER.warn(jsonElement.toString() + " is not an object. Skipping to next json element.");
        }
    }

    public void load() {
        try {
            int version;
            JsonObject json = (JsonObject)GsonUtils.getGson().fromJson((Reader)new FileReader(this.configFile), JsonObject.class);
            for (int i = version = class_3518.method_15282((JsonObject)json, (String)"configVersion", (int)-1); i < 2; ++i) {
                RandomlyAddingAnything.LOGGER.info("Upgrading RAA data file \"" + this.configFile.toString() + "\" to version " + (i + 1) + ".");
                json = this.upgrade(json, i);
            }
            this.load(json);
            RandomlyAddingAnything.LOGGER.info("Loaded RAA data file \"" + this.configFile.toString() + "\".");
            if (version != 2) {
                this.save();
                RandomlyAddingAnything.LOGGER.info("Saved upgraded RAA file.");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            RandomlyAddingAnything.LOGGER.info("Couldn't load RAA data file \"" + this.configFile.toString() + "\": " + e.getClass().getCanonicalName() + ". Initiating crash...");
            System.exit(1);
        }
    }

    public void save() {
        if (!this.configFile.exists()) {
            this.overrideFile();
        }
    }

    public void overrideFile() {
        try {
            new File(this.configFile.getParent()).mkdirs();
            FileWriter fileWriter = new FileWriter(this.configFile, false);
            this.save(fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't save RAA data file: " + this.configFile.toString(), e);
        }
    }

    public abstract void generate();

    protected abstract JsonObject upgrade(JsonObject var1, int var2);

    protected abstract void load(JsonObject var1);

    protected abstract void save(FileWriter var1);

    public boolean fileExist() {
        return this.configFile.exists();
    }
}

