/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.config.screen.dimensions;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.vampirestudios.raa.RandomlyAddingAnything;
import io.github.vampirestudios.raa.config.screen.dimensions.DimensionListScreen;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionColorPalette;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.utils.Utils;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.commons.lang3.text.WordUtils;

public class RAADimensionDescriptionListWidget
extends DynamicElementListWidget<Entry> {
    DimensionData data;

    public RAADimensionDescriptionListWidget(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    public int getItemWidth() {
        return this.width - 11;
    }

    protected int getScrollbarPosition() {
        return this.left + this.width - 6;
    }

    public int addItem(Entry item) {
        return super.addItem((DynamicEntryListWidget.Entry)item);
    }

    public void clearItemsPublic() {
        this.clearItems();
    }

    public void addMaterial(DimensionListScreen og, DimensionData dimensionData) {
        this.data = dimensionData;
        this.clearItems();
        this.addItem(new TitleMaterialOverrideEntry(og, dimensionData, new class_2585(WordUtils.capitalizeFully((String)dimensionData.getName())).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
        DimensionColorPalette colorPalette = dimensionData.getDimensionColorPalette();
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.identifier", new Object[]{dimensionData.getId().toString()})));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.hasSky", new Object[]{new class_2588("config.text.raa.boolean.value." + dimensionData.hasSky(), new Object[0])})));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.hasSkyLight", new Object[]{new class_2588("config.text.raa.boolean.value." + dimensionData.hasSkyLight(), new Object[0])})));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.canSleep", new Object[]{new class_2588("config.text.raa.boolean.value." + dimensionData.canSleep(), new Object[0])})));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.waterVaporize", new Object[]{new class_2588("config.text.raa.boolean.value." + dimensionData.doesWaterVaporize(), new Object[0])})));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.renderFog", new Object[]{new class_2588("config.text.raa.boolean.value." + dimensionData.hasThickFog(), new Object[0])})));
        class_124 difficultyFormatting = class_124.field_1060;
        if (dimensionData.getDifficulty() > 2) {
            difficultyFormatting = class_124.field_1054;
        }
        if (dimensionData.getDifficulty() > 6) {
            difficultyFormatting = class_124.field_1061;
        }
        if (dimensionData.getDifficulty() > 10) {
            difficultyFormatting = class_124.field_1079;
        }
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.difficulty", new Object[]{new class_2585(dimensionData.getDifficulty() + "").method_10854(difficultyFormatting)})));
        this.addItem(new TitleEntry(new class_2588("config.title.raa.advancedInformation", new Object[0]).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.chunkGenerator", new Object[]{WordUtils.capitalizeFully((String)dimensionData.getDimensionChunkGenerator().toString().replace("_", " ").toLowerCase())})));
        if (dimensionData.getFlags() != 0) {
            this.addItem(new TitleEntry(new class_2588("config.title.raa.flags", new Object[0]).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
            int flags = dimensionData.getFlags();
            if (Utils.checkBitFlag(flags, 8)) {
                this.addItem(new TextEntryWithTooltip(new class_2588("config.text.raa.flags.lush", new Object[0]).method_10854(class_124.field_1060), "config.tooltip.raa.lush", og));
            }
            if (Utils.checkBitFlag(flags, 16)) {
                this.addItem(new TextEntryWithTooltip(new class_2588("config.text.raa.flags.civilized", new Object[0]).method_10854(class_124.field_1077), "config.tooltip.raa.civilized", og));
            }
            if (Utils.checkBitFlag(flags, 4)) {
                this.addItem(new TextEntryWithTooltip(new class_2588("config.text.raa.flags.abandoned", new Object[0]).method_10854(class_124.field_1080), "config.tooltip.raa.abandoned", og));
            }
            if (Utils.checkBitFlag(flags, 2)) {
                this.addItem(new TextEntryWithTooltip(new class_2588("config.text.raa.flags.dead", new Object[0]).method_10854(class_124.field_1063), "config.tooltip.raa.dead", og));
            }
            if (Utils.checkBitFlag(flags, 64)) {
                this.addItem(new TextEntryWithTooltip(new class_2588("config.text.raa.flags.dry", new Object[0]).method_10854(class_124.field_1054), "config.tooltip.raa.dry", og));
            }
            if (Utils.checkBitFlag(flags, 128)) {
                this.addItem(new TextEntryWithTooltip(new class_2588("config.text.raa.flags.tectonic", new Object[0]).method_10854(class_124.field_1063), "config.tooltip.raa.tectonic", og));
            }
            if (Utils.checkBitFlag(flags, 32)) {
                this.addItem(new TextEntryWithTooltip(new class_2588("config.text.raa.flags.molten", new Object[0]).method_10854(class_124.field_1054), "config.tooltip.raa.molten", og));
            }
            if (Utils.checkBitFlag(flags, 1)) {
                this.addItem(new TextEntryWithTooltip(new class_2588("config.text.raa.flags.corrupted", new Object[0]).method_10854(class_124.field_1079), "config.tooltip.raa.corrupted", og));
            }
        }
        if (dimensionData.getCivilizationInfluences().size() > 0) {
            this.addItem(new TitleEntry(new class_2588("config.title.raa.civs", new Object[0]).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
            for (Map.Entry<String, Double> pair : dimensionData.getCivilizationInfluences().entrySet()) {
                if (pair.getValue() != 1.0) {
                    this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.civs.var", new Object[]{pair.getKey(), new DecimalFormat("##.00").format(pair.getValue() * 100.0)})));
                    continue;
                }
                this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.civs.var.home", new Object[]{pair.getKey(), new DecimalFormat("##.00").format(pair.getValue() * 100.0)})));
            }
        }
        this.addItem(new TitleEntry(new class_2588("config.title.raa.colors", new Object[0]).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
        if (dimensionData.hasSky()) {
            this.addItem(new ColorEntry("config.text.raa.skyColor", colorPalette.getSkyColor()));
        }
        this.addItem(new ColorEntry("config.text.raa.grassColor", colorPalette.getGrassColor()));
        this.addItem(new ColorEntry("config.text.raa.fogColor", colorPalette.getFogColor()));
        this.addItem(new ColorEntry("config.text.raa.foliageColor", colorPalette.getFoliageColor()));
        this.addItem(new ColorEntry("config.text.raa.stoneColor", colorPalette.getStoneColor()));
        this.addItem(new ColorEntry("config.text.raa.waterColor", dimensionData.getBiomeData().get(0).getWaterColor()));
    }

    public static abstract class Entry
    extends DynamicElementListWidget.ElementEntry<Entry> {
    }

    public static class EmptyEntry
    extends Entry {
        private int height;

        public EmptyEntry(int height) {
            this.height = height;
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        }

        public int getItemHeight() {
            return this.height;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }

    public static class TitleEntry
    extends Entry {
        protected String s;

        public TitleEntry(String s) {
            this.s = s;
        }

        public TitleEntry(class_2561 text) {
            this.s = text.method_10863();
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_310.method_1551().field_1772.method_1720(this.s, (float)x, (float)(y + 10), 0xFFFFFF);
        }

        public int getItemHeight() {
            return 21;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }

    public static class TextEntry
    extends Entry {
        protected String s;

        public TextEntry(class_2561 text) {
            this.s = text.method_10863();
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_310.method_1551().field_1772.method_1720(this.s, (float)x, (float)y, 0xFFFFFF);
        }

        public int getItemHeight() {
            return 11;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }

    public static class TextEntryWithTooltip
    extends Entry {
        protected String s;
        protected String tooltip;
        protected DimensionListScreen screen;

        public TextEntryWithTooltip(class_2561 text, String tooltip, DimensionListScreen screen) {
            this.s = text.method_10863();
            this.tooltip = class_1074.method_4663((String)tooltip) ? class_1074.method_4662((String)tooltip, (Object[])new Object[0]) : null;
            this.screen = screen;
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_310.method_1551().field_1772.method_1720(this.s, (float)x, (float)y, 0xFFFFFF);
            if (this.tooltip != null && mouseX >= x && mouseY >= y && mouseX <= x + class_310.method_1551().field_1772.method_1727(this.s) && mouseY <= y + this.getItemHeight()) {
                this.screen.tooltip = this.tooltip;
            }
        }

        public int getItemHeight() {
            return 11;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }

    public static class TitleMaterialOverrideEntry
    extends Entry {
        protected String s;
        private class_4185 overrideButton;

        public TitleMaterialOverrideEntry(DimensionListScreen og, DimensionData material, class_2561 text) {
            this.s = text.method_10863();
            String btnText = class_1074.method_4662((String)"config.button.raa.edit", (Object[])new Object[0]);
            this.overrideButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(btnText) + 10, 20, btnText, widget -> TitleMaterialOverrideEntry.openClothConfigForMaterial(og, material));
        }

        private static void openClothConfigForMaterial(DimensionListScreen og, DimensionData material) {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen((class_437)og).setTitle(class_1074.method_4662((String)"config.title.raa.config_specific", (Object[])new Object[]{WordUtils.capitalizeFully((String)material.getName())}));
            ConfigCategory category = builder.getOrCreateCategory("null");
            ConfigEntryBuilder eb = builder.entryBuilder();
            category.addEntry((AbstractConfigListEntry)eb.startStrField("config.field.raa.identifier", material.getId().method_12832()).setDefaultValue(material.getId().method_12832()).setSaveConsumer(material::setId).setErrorSupplier(str -> {
                if (str.toLowerCase().equals(str)) {
                    return Optional.empty();
                }
                return Optional.of(class_1074.method_4662((String)"config.error.raa.identifier.no.caps", (Object[])new Object[0]));
            }).build());
            category.addEntry((AbstractConfigListEntry)eb.startBooleanToggle("config.field.raa.hasSky", material.hasSky()).setDefaultValue(material.hasSky()).setSaveConsumer(material::setHasSky).build());
            category.addEntry((AbstractConfigListEntry)eb.startBooleanToggle("config.field.raa.hasSkyLight", material.hasSkyLight()).setDefaultValue(material.hasSkyLight()).setSaveConsumer(material::setHasSkyLight).build());
            category.addEntry((AbstractConfigListEntry)eb.startBooleanToggle("config.field.raa.canSleep", material.canSleep()).setDefaultValue(material.canSleep()).setSaveConsumer(material::setCanSleep).build());
            category.addEntry((AbstractConfigListEntry)eb.startBooleanToggle("config.field.raa.doesWaterVaporize", material.doesWaterVaporize()).setDefaultValue(material.doesWaterVaporize()).setSaveConsumer(material::setWaterVaporize).build());
            category.addEntry((AbstractConfigListEntry)eb.startBooleanToggle("config.field.raa.shouldRenderFog", material.hasThickFog()).setDefaultValue(material.hasThickFog()).setSaveConsumer(material::setRenderFog).build());
            builder.setSavingRunnable(RandomlyAddingAnything.DIMENSIONS_CONFIG::overrideFile);
            class_310.method_1551().method_1507(builder.build());
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)1.4f, (float)1.4f, (float)1.4f);
            class_310.method_1551().field_1772.method_1720(this.s, (float)x / 1.4f, (float)(y + 5) / 1.4f, 0xFFFFFF);
            RenderSystem.popMatrix();
            this.overrideButton.x = x + entryWidth - this.overrideButton.getWidth();
            this.overrideButton.y = y;
            this.overrideButton.render(mouseX, mouseY, delta);
        }

        public int getItemHeight() {
            return 21;
        }

        public List<? extends class_364> children() {
            return Collections.singletonList(this.overrideButton);
        }
    }

    public static class ColorEntry
    extends Entry {
        private String s;
        private int color;

        public ColorEntry(String s, int color) {
            this.s = s;
            this.color = color;
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            int i = class_310.method_1551().field_1772.method_1720(class_124.field_1080.toString() + class_1074.method_4662((String)this.s, (Object[])new Object[0]) + class_124.field_1068.toString() + class_1074.method_4662((String)("#" + Integer.toHexString(this.color).replace("ff", "")), (Object[])new Object[0]), (float)x, (float)y, 0xFFFFFF);
            this.fillGradient(i + 1, y + 1, i + 1 + entryHeight, y + 1 + entryHeight, this.color, this.color);
        }

        public int getItemHeight() {
            return 11;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }
}

