/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.config.screen.dimensions.material;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.vampirestudios.raa.RandomlyAddingAnything;
import io.github.vampirestudios.raa.config.screen.dimensions.material.DimensionMaterialListScreen;
import io.github.vampirestudios.raa.generation.materials.DimensionMaterial;
import io.github.vampirestudios.raa.utils.Utils;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.commons.lang3.text.WordUtils;

public class RAADimensionMaterialDescriptionListWidget
extends DynamicElementListWidget<Entry> {
    DimensionMaterial material;

    public RAADimensionMaterialDescriptionListWidget(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    public int getItemWidth() {
        return this.width - 11;
    }

    protected int getScrollbarPosition() {
        return this.left + this.width - 6;
    }

    public int addItem(Entry item) {
        return super.addItem((DynamicEntryListWidget.Entry)item);
    }

    public void clearItemsPublic() {
        this.clearItems();
    }

    public void addMaterial(DimensionMaterialListScreen og, DimensionMaterial material) {
        this.material = material;
        this.clearItems();
        this.addItem(new TitleMaterialOverrideEntry(og, material, new class_2585(WordUtils.capitalizeFully((String)material.getName())).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
        DecimalFormat df = new DecimalFormat("#.##");
        this.addItem(new ColorEntry("config.text.raa.color", material.getColor()));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.identifier", new Object[]{material.getId().toString()})));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.targetIdentifier", new Object[]{material.getOreInformation().getTargetId().toString()})));
        this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.targetBlock", new Object[]{WordUtils.capitalizeFully((String)material.getOreInformation().getTargetId().method_12832().replace("_", " "))})));
        if (material.hasTools()) {
            this.addItem(new TitleEntry(new class_2588("config.title.raa.tools", new Object[0]).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.enchantability", new Object[]{material.getToolMaterial().method_8026()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.durability", new Object[]{material.getToolMaterial().method_8025()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.mining_level", new Object[]{material.getToolMaterial().method_8024()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.tool_speed", new Object[]{df.format(material.getToolMaterial().method_8027())})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.attack_damage", new Object[]{df.format(material.getToolMaterial().method_8028())})));
        }
        if (material.hasWeapons()) {
            this.addItem(new TitleEntry(new class_2588("config.title.raa.weapons", new Object[0]).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.enchantability", new Object[]{material.getToolMaterial().method_8026()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.durability", new Object[]{material.getToolMaterial().method_8025()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.attack_damage", new Object[]{df.format(material.getToolMaterial().method_8028())})));
        }
        if (material.hasArmor()) {
            this.addItem(new TitleEntry(new class_2588("config.title.raa.armor", new Object[0]).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.enchantability", new Object[]{material.getArmorMaterial().method_7699()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.helmetDurability", new Object[]{material.getArmorMaterial().method_7696(class_1304.field_6169)})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.chestplateDurability", new Object[]{material.getArmorMaterial().method_7696(class_1304.field_6174)})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.leggingsDurability", new Object[]{material.getArmorMaterial().method_7696(class_1304.field_6172)})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.bootsDurability", new Object[]{material.getArmorMaterial().method_7696(class_1304.field_6166)})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.horseArmorBonus", new Object[]{material.getArmorMaterial().getHorseArmorBonus()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.equipmentSound", new Object[]{material.getArmorMaterial().method_7698().method_14833()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.repairItem", new Object[]{Utils.appendToPath(material.getId(), material.getArmorMaterial().getOreType().getSuffix())})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.toughness", new Object[]{Float.valueOf(material.getArmorMaterial().method_7700())})));
        }
        if (material.hasFood()) {
            this.addItem(new TitleEntry(new class_2588("config.title.raa.food", new Object[0]).method_10856(new class_124[]{class_124.field_1073, class_124.field_1067})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.hunger", new Object[]{material.getFoodData().getHunger()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.saturationModifier", new Object[]{Float.valueOf(material.getFoodData().getSaturationModifier())})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.alwaysEdible", new Object[]{material.getFoodData().isAlwaysEdible()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.meat", new Object[]{material.getFoodData().isMeat()})));
            this.addItem(new TextEntry((class_2561)new class_2588("config.text.raa.snack", new Object[]{material.getFoodData().isSnack()})));
        }
    }

    public static abstract class Entry
    extends DynamicElementListWidget.ElementEntry<Entry> {
    }

    public static class EmptyEntry
    extends Entry {
        private int height;

        public EmptyEntry(int height) {
            this.height = height;
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        }

        public int getItemHeight() {
            return this.height;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }

    public static class TitleEntry
    extends Entry {
        protected String s;

        public TitleEntry(String s) {
            this.s = s;
        }

        public TitleEntry(class_2561 text) {
            this.s = text.method_10863();
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_310.method_1551().field_1772.method_1720(this.s, (float)x, (float)(y + 10), 0xFFFFFF);
        }

        public int getItemHeight() {
            return 21;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }

    public static class TextEntry
    extends Entry {
        protected String s;

        public TextEntry(String s) {
            this.s = s;
        }

        public TextEntry(class_2561 text) {
            this.s = text.method_10863();
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_310.method_1551().field_1772.method_1720(this.s, (float)x, (float)y, 0xFFFFFF);
        }

        public int getItemHeight() {
            return 11;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }

    public static class TitleMaterialOverrideEntry
    extends Entry {
        protected String s;
        private class_4185 overrideButton;

        public TitleMaterialOverrideEntry(DimensionMaterialListScreen og, DimensionMaterial material, class_2561 text) {
            this.s = text.method_10863();
            String btnText = class_1074.method_4662((String)"config.button.raa.edit", (Object[])new Object[0]);
            this.overrideButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_1727(btnText) + 10, 20, btnText, widget -> TitleMaterialOverrideEntry.openClothConfigForMaterial(og, material));
        }

        private static void openClothConfigForMaterial(DimensionMaterialListScreen og, DimensionMaterial material) {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen((class_437)og).setTitle(class_1074.method_4662((String)"config.title.raa.config_specific", (Object[])new Object[]{WordUtils.capitalizeFully((String)material.getName())}));
            ConfigCategory category = builder.getOrCreateCategory("null");
            ConfigEntryBuilder eb = builder.entryBuilder();
            category.addEntry((AbstractConfigListEntry)eb.startStrField("config.field.raa.identifier", material.getName()).setDefaultValue(material.getName()).setSaveConsumer(material::setName).setErrorSupplier(str -> {
                if (str.toLowerCase().equals(str)) {
                    return Optional.empty();
                }
                return Optional.of(class_1074.method_4662((String)"config.error.raa.identifier.no.caps", (Object[])new Object[0]));
            }).build());
            if (material.hasTools()) {
                SubCategoryBuilder tools = eb.startSubCategory("config.title.raa.tools").setExpended(false);
                tools.add((AbstractConfigListEntry)eb.startIntField("config.field.raa.enchantability", material.getToolMaterial().method_8026()).setDefaultValue(material.getToolMaterial().method_8026()).setSaveConsumer(material.getToolMaterial()::setEnchantability).setMin(0).build());
                tools.add((AbstractConfigListEntry)eb.startIntField("config.field.raa.durability", material.getToolMaterial().method_8025()).setDefaultValue(material.getToolMaterial().method_8025()).setSaveConsumer(material.getToolMaterial()::setDurability).setMin(1).build());
                tools.add((AbstractConfigListEntry)eb.startIntField("config.field.raa.mining_level", material.getToolMaterial().method_8024()).setDefaultValue(material.getToolMaterial().method_8024()).setSaveConsumer(material.getToolMaterial()::setMiningLevel).setMin(0).build());
                tools.add((AbstractConfigListEntry)eb.startFloatField("config.field.raa.tool_speed", material.getToolMaterial().method_8027()).setDefaultValue(material.getToolMaterial().method_8027()).setSaveConsumer(material.getToolMaterial()::setMiningSpeed).setMin(0.0f).build());
                tools.add((AbstractConfigListEntry)eb.startFloatField("config.field.raa.attack_damage", material.getToolMaterial().method_8028()).setDefaultValue(material.getToolMaterial().method_8028()).setSaveConsumer(material.getToolMaterial()::setAttackDamage).build());
                category.addEntry((AbstractConfigListEntry)tools.build());
            }
            if (material.hasWeapons()) {
                SubCategoryBuilder weapons = eb.startSubCategory("config.title.raa.weapons").setExpended(false);
                weapons.add((AbstractConfigListEntry)eb.startIntField("config.field.raa.enchantability", material.getToolMaterial().method_8026()).setDefaultValue(material.getToolMaterial().method_8026()).setSaveConsumer(material.getToolMaterial()::setEnchantability).setMin(0).build());
                weapons.add((AbstractConfigListEntry)eb.startIntField("config.field.raa.durability", material.getToolMaterial().method_8025()).setDefaultValue(material.getToolMaterial().method_8025()).setSaveConsumer(material.getToolMaterial()::setDurability).setMin(1).build());
                weapons.add((AbstractConfigListEntry)eb.startFloatField("config.field.raa.attack_damage", material.getToolMaterial().method_8028()).setDefaultValue(material.getToolMaterial().method_8028()).setSaveConsumer(material.getToolMaterial()::setAttackDamage).build());
                category.addEntry((AbstractConfigListEntry)weapons.build());
            }
            builder.setSavingRunnable(RandomlyAddingAnything.DIMENSION_MATERIALS_CONFIG::overrideFile);
            class_310.method_1551().method_1507(builder.build());
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)1.4f, (float)1.4f, (float)1.4f);
            class_310.method_1551().field_1772.method_1720(this.s, (float)x / 1.4f, (float)(y + 5) / 1.4f, 0xFFFFFF);
            RenderSystem.popMatrix();
            this.overrideButton.x = x + entryWidth - this.overrideButton.getWidth();
            this.overrideButton.y = y;
            this.overrideButton.render(mouseX, mouseY, delta);
        }

        public int getItemHeight() {
            return 21;
        }

        public List<? extends class_364> children() {
            return Collections.singletonList(this.overrideButton);
        }
    }

    public static class ColorEntry
    extends Entry {
        private String s;
        private int color;

        public ColorEntry(String s, int color) {
            this.s = s;
            this.color = color;
        }

        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            int i = class_310.method_1551().field_1772.method_1720(class_1074.method_4662((String)this.s, (Object[])new Object[]{"#" + Integer.toHexString(this.color).replace("ff", "")}), (float)x, (float)y, 0xFFFFFF);
            this.fillGradient(i + 1, y + 1, i + 1 + entryHeight, y + 1 + entryHeight, this.color, this.color);
        }

        public int getItemHeight() {
            return 11;
        }

        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }
}

