/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.carvers;

import com.google.common.collect.ImmutableSet;
import io.github.vampirestudios.raa.api.dimension.DimensionChunkGenerators;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.utils.Utils;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2939;
import net.minecraft.class_3133;
import net.minecraft.class_3532;

public class CaveCarver
extends class_2939<class_3133> {
    private DimensionData data;

    public CaveCarver(DimensionData dimensionData) {
        super(class_3133::method_13674, 256);
        this.field_13302 = ImmutableSet.of((Object)class_2378.field_11146.method_10223(Utils.appendToPath(dimensionData.getId(), "_stone")), (Object)class_2246.field_10340, (Object)class_2246.field_10474, (Object)class_2246.field_10508, (Object)class_2246.field_10115, (Object)class_2246.field_10566, (Object[])new class_2248[]{class_2246.field_10253, class_2246.field_10520, class_2246.field_10219, class_2246.field_10415, class_2246.field_10611, class_2246.field_10184, class_2246.field_10015, class_2246.field_10325, class_2246.field_10143, class_2246.field_10014, class_2246.field_10444, class_2246.field_10349, class_2246.field_10590, class_2246.field_10235, class_2246.field_10570, class_2246.field_10409, class_2246.field_10123, class_2246.field_10526, class_2246.field_10328, class_2246.field_10626, class_2246.field_9979, class_2246.field_10344, class_2246.field_10402, class_2246.field_10477, class_2246.field_10225});
        this.data = dimensionData;
    }

    public boolean shouldCarve(Random random, int chunkX, int chunkZ, class_3133 config) {
        return random.nextFloat() <= config.field_13738;
    }

    public boolean carve(class_2791 chunk, Function<class_2338, class_1959> posBiomeFunction, Random random, int chunkX, int chunkZ, int mainChunkX, int mainChunkZ, int i, BitSet bitSet, class_3133 config) {
        int i5 = (this.method_12710() * 2 - 1) * 16;
        int int_7 = random.nextInt(random.nextInt(random.nextInt(this.getMaxCaveCount()) + 1) + 1);
        for (int i1 = 0; i1 < int_7; ++i1) {
            float v;
            double z = chunkZ * 16 + random.nextInt(16);
            double y = this.getCaveY(random);
            double x = mainChunkX * 16 + random.nextInt(16);
            int i2 = 1;
            if (random.nextInt(4) == 0) {
                v = 1.0f + random.nextFloat() * 6.0f;
                this.carveCave(chunk, posBiomeFunction, random.nextLong(), chunkX, mainChunkZ, i, z, y, x, v, bitSet);
                i2 += random.nextInt(4);
            }
            for (int i4 = 0; i4 < i2; ++i4) {
                float v1 = random.nextFloat() * ((float)Math.PI * 2);
                v = (random.nextFloat() - 0.5f) / 4.0f;
                float tunnelSystemWidth = this.getTunnelSystemWidth(random);
                int i3 = i5 - random.nextInt(i5 / 4);
                this.carveTunnels(chunk, posBiomeFunction, random.nextLong(), chunkX, mainChunkZ, i, z, y, x, tunnelSystemWidth, v1, v, 0, i3, this.getTunnelSystemHeightWidthRatio(), bitSet);
            }
        }
        return true;
    }

    protected int getMaxCaveCount() {
        return 15;
    }

    protected float getTunnelSystemWidth(Random random) {
        float v = random.nextFloat() * 2.0f + random.nextFloat();
        if (random.nextInt(10) == 0) {
            v *= random.nextFloat() * random.nextFloat() * 3.0f + 1.0f;
        }
        return v;
    }

    protected double getTunnelSystemHeightWidthRatio() {
        return 1.0;
    }

    protected int getCaveY(Random random) {
        return random.nextInt(random.nextInt(120) + 8);
    }

    protected void carveCave(class_2791 chunk, Function<class_2338, class_1959> posBiomeFunction, long long1, int i, int i1, int i2, double v, double v1, double v2, float f, BitSet bitSet) {
        double v3 = 1.5 + (double)(class_3532.method_15374((float)1.5707964f) * f);
        double v4 = v3 * 0.5;
        this.method_16580(chunk, posBiomeFunction, long1, i, i1, i2, v + 1.0, v1, v2, v3, v4, bitSet);
    }

    protected void carveTunnels(class_2791 chunk, Function<class_2338, class_1959> posBiomeFunction, long seed, int i, int i1, int i2, double v, double v1, double v2, float f, float f1, float f2, int i3, int i4, double v3, BitSet bitSet) {
        Random random = new Random(seed);
        int i5 = random.nextInt(i4 / 2) + i4 / 4;
        boolean isZero = random.nextInt(6) == 0;
        float v4 = 0.0f;
        float v5 = 0.0f;
        for (int i6 = i3; i6 < i4; ++i6) {
            double v6 = 1.5 + (double)(class_3532.method_15374((float)((float)Math.PI * (float)i6 / (float)i4)) * f);
            double v7 = v6 * v3;
            float cos = class_3532.method_15362((float)f2);
            v += (double)(class_3532.method_15362((float)f1) * cos);
            v1 += (double)class_3532.method_15374((float)f2);
            v2 += (double)(class_3532.method_15374((float)f1) * cos);
            f2 *= isZero ? 0.92f : 0.7f;
            f2 += v5 * 0.1f;
            f1 += v4 * 0.1f;
            v5 *= 0.9f;
            v4 *= 0.75f;
            v5 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            v4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (i6 == i5 && f > 1.0f) {
                this.carveTunnels(chunk, posBiomeFunction, random.nextLong(), i, i1, i2, v, v1, v2, random.nextFloat() * 0.5f + 0.5f, f1 - 1.5707964f, f2 / 3.0f, i6, i4, 1.0, bitSet);
                this.carveTunnels(chunk, posBiomeFunction, random.nextLong(), i, i1, i2, v, v1, v2, random.nextFloat() * 0.5f + 0.5f, f1 + 1.5707964f, f2 / 3.0f, i6, i4, 1.0, bitSet);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!this.method_12707(i1, i2, v, v2, i6, i4, f)) {
                return;
            }
            this.method_16580(chunk, posBiomeFunction, seed, i, i1, i2, v, v1, v2, v6, v7, bitSet);
        }
    }

    protected boolean method_16582(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        return scaledRelativeY <= -0.7 || scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ >= 1.0;
    }

    protected boolean method_16581(class_2791 chunk, Function<class_2338, class_1959> posBiomeFunction, BitSet bitSet, Random random, class_2338.class_2339 mutable, class_2338.class_2339 mutable2, class_2338.class_2339 mutable3, int mainChunkX, int mainChunkZ, int i, int j, int k, int l, int m, int n, AtomicBoolean atomicBoolean) {
        int i1 = l | n << 4 | m << 8;
        if (bitSet.get(i1)) {
            return false;
        }
        bitSet.set(i1);
        mutable.method_10103(j, m, k);
        class_2680 blockState = chunk.method_8320((class_2338)mutable);
        class_2680 upState = chunk.method_8320((class_2338)mutable2.method_10101((class_2382)mutable).method_10098(class_2350.field_11036));
        if (blockState.method_11614() == class_2246.field_10219 || blockState.method_11614() == class_2246.field_10402) {
            atomicBoolean.set(true);
        }
        if (!this.method_12703(blockState, upState)) {
            return false;
        }
        if (m < 11) {
            DimensionChunkGenerators generator = this.data.getDimensionChunkGenerator();
            if (generator == DimensionChunkGenerators.FLOATING || generator == DimensionChunkGenerators.PRE_CLASSIC_FLOATING || generator == DimensionChunkGenerators.LAYERED_FLOATING) {
                return true;
            }
            chunk.method_12010((class_2338)mutable, field_13296.method_15759(), false);
        } else {
            chunk.method_12010((class_2338)mutable, field_13294, false);
            if (atomicBoolean.get()) {
                mutable3.method_10101((class_2382)mutable).method_10098(class_2350.field_11033);
                if (chunk.method_8320((class_2338)mutable3).method_11614() == class_2246.field_10566) {
                    chunk.method_12010((class_2338)mutable3, posBiomeFunction.apply((class_2338)mutable).method_8722().method_15337(), false);
                }
            }
        }
        return true;
    }
}

