/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.chunkgenerator;

import java.util.List;
import java.util.Random;
import net.minecraft.class_128;
import net.minecraft.class_1311;
import net.minecraft.class_1419;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1942;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2888;
import net.minecraft.class_2893;
import net.minecraft.class_2906;
import net.minecraft.class_2910;
import net.minecraft.class_2919;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3537;
import net.minecraft.class_3754;
import net.minecraft.class_3769;
import net.minecraft.class_4274;

public class OverworldChunkGenerator
extends class_3754<class_2906> {
    private static final float[] BIOME_WEIGHT_TABLE = (float[])class_156.method_654((Object)new float[25], fs -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                fs[i + 2 + (j + 2) * 5] = f = 10.0f / class_3532.method_15355((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private final class_3537 noiseSampler;
    private final boolean amplified;
    private final class_2910 phantomSpawner = new class_2910();
    private final class_3769 pillagerSpawner = new class_3769();
    private final class_4274 catSpawner = new class_4274();
    private final class_1419 zombieSiegeManager = new class_1419();

    public OverworldChunkGenerator(class_1936 world, class_1966 biomeSource, class_2906 config) {
        super(world, biomeSource, 4, 8, 256, (class_2888)config, true);
        this.field_16577.method_12660(2620);
        this.noiseSampler = new class_3537(this.field_16577, 15, 0);
        this.amplified = world.method_8401().method_153() == class_1942.field_9267;
    }

    public void method_12107(class_3233 region) {
        int i = region.method_14336();
        int j = region.method_14339();
        class_1959 biome = region.method_23753(new class_1923(i, j).method_8323());
        class_2919 chunkRandom = new class_2919();
        chunkRandom.method_12661(region.method_8412(), i << 4, j << 4);
        class_1948.method_8661((class_1936)region, (class_1959)biome, (int)i, (int)j, (Random)chunkRandom);
    }

    protected void method_16405(double[] buffer, int x, int z) {
        this.method_16413(buffer, x, z, 684.412f, 684.412f, 8.555149841308594, 4.277574920654297, 3, -10);
    }

    protected double method_16404(double depth, double scale, int y) {
        double d = 8.5;
        double e = ((double)y - (8.5 + depth * 8.5 / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / scale;
        if (e < 0.0) {
            e *= 4.0;
        }
        return e;
    }

    protected double[] method_12090(int x, int z) {
        double[] ds = new double[2];
        float f = 0.0f;
        float g = 0.0f;
        float h = 0.0f;
        int j = this.method_16398();
        float k = this.field_12761.method_16359(x, j, z).method_8695();
        for (int l = -2; l <= 2; ++l) {
            for (int m = -2; m <= 2; ++m) {
                class_1959 biome = this.field_12761.method_16359(x + l, j, z + m);
                float n = biome.method_8695();
                float o = biome.method_8686();
                if (this.amplified && n > 0.0f) {
                    n = 1.0f + n * 2.0f;
                    o = 1.0f + o * 4.0f;
                }
                float p = BIOME_WEIGHT_TABLE[l + 2 + (m + 2) * 5] / (n + 2.0f);
                if (biome.method_8695() > k) {
                    p /= 2.0f;
                }
                f += o * p;
                g += n * p;
                h += p;
            }
        }
        f /= h;
        g /= h;
        f = f * 0.9f + 0.1f;
        g = (g * 4.0f - 1.0f) / 8.0f;
        ds[0] = (double)g + this.sampleNoise(x, z);
        ds[1] = f;
        return ds;
    }

    private double sampleNoise(int x, int y) {
        double d = this.noiseSampler.method_16453((double)(x * 200), 10.0, (double)(y * 200), 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (d < 0.0) {
            d = -d * 0.3;
        }
        if ((d = d * 3.0 - 2.0) < 0.0) {
            d /= 28.0;
        } else {
            if (d > 1.0) {
                d = 1.0;
            }
            d /= 40.0;
        }
        return d;
    }

    public List<class_1959.class_1964> method_12113(class_1311 category, class_2338 pos) {
        if (class_3031.field_13520.method_14029(this.field_12760, pos)) {
            if (category == class_1311.field_6302) {
                return class_3031.field_13520.method_13149();
            }
            if (category == class_1311.field_6294) {
                return class_3031.field_13520.method_16140();
            }
        } else if (category == class_1311.field_6302) {
            if (class_3031.field_16655.method_14023(this.field_12760, pos)) {
                return class_3031.field_16655.method_13149();
            }
            if (class_3031.field_13588.method_14023(this.field_12760, pos)) {
                return class_3031.field_13588.method_13149();
            }
        }
        return super.method_12113(category, pos);
    }

    public void method_12102(class_3233 region) {
        class_2893.class_2895[] features;
        int chunkX = region.method_14336();
        int chunkZ = region.method_14339();
        class_2919 rand = new class_2919();
        rand.method_12659(chunkX, chunkZ);
        int i = region.method_14336();
        int j = region.method_14339();
        int k = i * 16;
        int l = j * 16;
        class_2338 blockPos = new class_2338(k, 0, l);
        class_1959 biome = this.method_16554(region.method_22385(), blockPos.method_10069(8, 8, 8));
        class_2919 chunkRandom = new class_2919();
        long seed = chunkRandom.method_12661(region.method_8412(), k, l);
        for (class_2893.class_2895 feature : features = class_2893.class_2895.values()) {
            try {
                biome.method_8702(feature, (class_2794)this, (class_1936)region, seed, chunkRandom, blockPos);
            }
            catch (Exception exception) {
                class_128 crashReport = class_128.method_560((Throwable)exception, (String)"Biome decoration");
                crashReport.method_562("Generation").method_578("CenterX", (Object)i).method_578("CenterZ", (Object)j).method_578("Step", (Object)feature).method_578("Seed", (Object)seed).method_578("Biome", (Object)class_2378.field_11153.method_10221((Object)biome));
                throw new class_148(crashReport);
            }
        }
    }

    public void method_12099(class_3218 serverWorld, boolean spawnMonsters, boolean spawnAnimals) {
        this.phantomSpawner.method_12639(serverWorld, spawnMonsters, spawnAnimals);
        this.pillagerSpawner.method_16574(serverWorld, spawnMonsters, spawnAnimals);
        this.catSpawner.method_20261(serverWorld, spawnMonsters, spawnAnimals);
        this.zombieSiegeManager.method_6445(serverWorld, spawnMonsters, spawnAnimals);
    }

    public int method_12100() {
        return this.field_12760.method_8615() + 1;
    }

    public int method_16398() {
        return 63;
    }
}

