/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.dimensions;

import com.google.common.collect.ImmutableList;
import io.github.vampirestudios.raa.api.dimension.DimensionChunkGenerators;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionBiomeData;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionTreeData;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionTreeTypes;
import io.github.vampirestudios.raa.generation.feature.StoneCircleFeature;
import io.github.vampirestudios.raa.generation.feature.TombFeature;
import io.github.vampirestudios.raa.generation.feature.config.CorruptedFeatureConfig;
import io.github.vampirestudios.raa.generation.feature.tree.foliage.BoringOakFoliagePlacer;
import io.github.vampirestudios.raa.generation.feature.tree.foliage.CylinderFoliagePlacer;
import io.github.vampirestudios.raa.generation.feature.tree.foliage.LongOakFoliagePlacer;
import io.github.vampirestudios.raa.generation.feature.tree.foliage.RandomSpruceFoliagePlacer;
import io.github.vampirestudios.raa.generation.feature.tree.foliage.UpsideDownOakFoliagePlacer;
import io.github.vampirestudios.raa.registries.Decorators;
import io.github.vampirestudios.raa.registries.Features;
import io.github.vampirestudios.raa.registries.SurfaceBuilders;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.Utils;
import io.github.vampirestudios.vampirelib.utils.registry.WoodType;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3098;
import net.minecraft.class_3101;
import net.minecraft.class_3111;
import net.minecraft.class_3141;
import net.minecraft.class_3273;
import net.minecraft.class_3276;
import net.minecraft.class_3284;
import net.minecraft.class_3297;
import net.minecraft.class_3523;
import net.minecraft.class_3531;
import net.minecraft.class_3864;
import net.minecraft.class_4636;
import net.minecraft.class_4640;
import net.minecraft.class_4645;
import net.minecraft.class_4646;
import net.minecraft.class_4647;
import net.minecraft.class_4649;
import net.minecraft.class_4650;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4658;
import net.minecraft.class_4660;
import net.minecraft.class_4661;
import net.minecraft.class_4664;

public class CustomDimensionalBiome
extends class_1959 {
    private DimensionData dimensionData;

    public CustomDimensionalBiome(DimensionData dimensionData, DimensionBiomeData biomeData) {
        super(new class_1959.class_1960().method_8737(Utils.randomSurfaceBuilder(dimensionData.getSurfaceBuilder(), dimensionData), (class_3531)class_3523.field_15677).method_8735(Utils.checkBitFlag(dimensionData.getFlags(), 256) ? class_1959.class_1963.field_9383 : (Rands.chance(10) ? class_1959.class_1963.field_9382 : class_1959.class_1963.field_9384)).method_8738(class_1959.class_1961.field_9355).method_8740(biomeData.getDepth()).method_8743(biomeData.getScale()).method_8747(biomeData.getTemperature()).method_8727(biomeData.getDownfall()).method_8733(biomeData.getWaterColor()).method_8728(biomeData.getWaterColor()).method_8745(null));
        this.dimensionData = dimensionData;
        if (dimensionData.getDimensionChunkGenerator() != DimensionChunkGenerators.FLOATING && (Utils.checkBitFlag(dimensionData.getFlags(), 4) || Utils.checkBitFlag(dimensionData.getFlags(), 16))) {
            this.method_8710(class_3031.field_13547.method_23397((class_3037)new class_3101(Utils.checkBitFlag(dimensionData.getFlags(), 16) ? 0.016 : 0.004, class_3098.class_3100.field_13692)));
        }
        Features.addDefaultCarvers(this, dimensionData);
        Features.addDefaultSprings(this, dimensionData);
        class_3864.method_17002((class_1959)this);
        class_3864.method_17004((class_1959)this);
        if (Utils.randomSurfaceBuilder(dimensionData.getSurfaceBuilder(), dimensionData) == SurfaceBuilders.HYPER_FLAT) {
            class_3864.method_16994((class_1959)this);
            class_3864.method_16991((class_1959)this);
        }
        if (Rands.chance(4) && !Utils.checkBitFlag(dimensionData.getFlags(), 2) && !Utils.checkBitFlag(dimensionData.getFlags(), 64) && !Utils.checkBitFlag(dimensionData.getFlags(), 32)) {
            class_3864.method_16981((class_1959)this);
        }
        class_3864.method_17005((class_1959)this);
        class_3864.method_17006((class_1959)this);
        class_3864.method_17010((class_1959)this);
        if (!Utils.checkBitFlag(dimensionData.getFlags(), 2) && !Utils.checkBitFlag(dimensionData.getFlags(), 1)) {
            for (DimensionTreeData treeData : biomeData.getTreeData()) {
                class_4636 config;
                if (treeData.getTreeType() == DimensionTreeTypes.MEGA_JUNGLE || treeData.getTreeType() == DimensionTreeTypes.MEGA_SPRUCE || treeData.getTreeType() == DimensionTreeTypes.DARK_OAK) {
                    config = new class_4636.class_4637((class_4651)new class_4656(treeData.getWoodType().woodType.getLog().method_9564()), (class_4651)new class_4656(treeData.getWoodType().woodType.getLeaves().method_9564())).method_23410(treeData.getBaseHeight()).method_23412(treeData.getFoliageHeightRandom()).method_23409();
                    this.method_8719(class_2893.class_2895.field_13178, CustomDimensionalBiome.getMegaTree(treeData.getTreeType()).method_23397((class_3037)config).method_23388(class_3284.field_14267.method_23475((class_2998)new class_3276(0, treeData.getChance(), 1))));
                    continue;
                }
                config = new class_4640.class_4641((class_4651)new class_4656(treeData.getWoodType().woodType.getLog().method_9564()), (class_4651)new class_4656(treeData.getWoodType().woodType.getLeaves().method_9564()), CustomDimensionalBiome.getFoliagePlacer(treeData)).method_23428(Rands.randIntRange(1, 6)).method_23430(treeData.getBaseHeight()).method_23437(treeData.getFoliageHeight()).method_23438(treeData.getFoliageHeightRandom()).method_23433(0).method_23427().method_23431();
                this.method_8719(class_2893.class_2895.field_13178, CustomDimensionalBiome.getNormalTree(treeData.getTreeType()).method_23397((class_3037)config).method_23388(class_3284.field_14267.method_23475((class_2998)new class_3276(0, treeData.getChance(), 1))));
            }
        }
        if (Utils.checkBitFlag(dimensionData.getFlags(), 2) || Utils.checkBitFlag(dimensionData.getFlags(), 64)) {
            this.method_8719(class_2893.class_2895.field_13178, Features.LARGE_SKELETON_TREE.method_23397((class_3037)class_3864.field_21126).method_23388(class_3284.field_14267.method_23475((class_2998)new class_3276(0, biomeData.getLargeSkeletonTreeChance(), 1))));
            this.method_8719(class_2893.class_2895.field_13173, class_3031.field_13516.method_23397((class_3037)class_3037.field_13603).method_23388(class_3284.field_14246.method_23475((class_2998)new class_3297(64))));
        }
        if (!Utils.checkBitFlag(dimensionData.getFlags(), 2) && !Utils.checkBitFlag(dimensionData.getFlags(), 1)) {
            this.method_8719(class_2893.class_2895.field_13178, class_3031.field_21220.method_23397((class_3037)class_3864.field_21101).method_23388(class_3284.field_14240.method_23475((class_2998)new class_3273(Utils.checkBitFlag(dimensionData.getFlags(), 8) ? 50 : 20))));
            this.method_8719(class_2893.class_2895.field_13178, class_3031.field_21220.method_23397((class_3037)class_3864.field_21099).method_23388(class_3284.field_14240.method_23475((class_2998)new class_3273(Utils.checkBitFlag(dimensionData.getFlags(), 8) ? 20 : 5))));
            this.method_8719(class_2893.class_2895.field_13178, class_3031.field_21220.method_23397((class_3037)class_3864.field_21098).method_23388(class_3284.field_14240.method_23475((class_2998)new class_3273(Utils.checkBitFlag(dimensionData.getFlags(), 8) ? 20 : 5))));
            this.method_8719(class_2893.class_2895.field_13178, class_3031.field_21220.method_23397((class_3037)class_3864.field_21105).method_23388(class_3284.field_14240.method_23475((class_2998)new class_3273(Utils.checkBitFlag(dimensionData.getFlags(), 8) ? 20 : 5))));
            this.method_8719(class_2893.class_2895.field_13178, class_3031.field_21220.method_23397((class_3037)class_3864.field_21092).method_23388(class_3284.field_14263.method_23475((class_2998)new class_3297(Utils.checkBitFlag(dimensionData.getFlags(), 8) ? 50 : 20))));
        }
        if (Utils.checkBitFlag(dimensionData.getFlags(), 1)) {
            this.method_8719(class_2893.class_2895.field_13178, Features.CRATER_FEATURE.method_23397(new CorruptedFeatureConfig(true)).method_23388(class_3284.field_14267.method_23475((class_2998)new class_3276(0, Rands.randFloatRange(0.0f, 1.0f), 1))));
            this.method_8719(class_2893.class_2895.field_13178, Features.CORRUPTED_NETHRRACK.method_23397((class_3037)new class_3111()).method_23388(class_3284.field_14240.method_23475((class_2998)new class_3273(2))));
        } else if (biomeData.spawnsCratersInNonCorrupted()) {
            this.method_8719(class_2893.class_2895.field_13173, Features.CRATER_FEATURE.method_23397(new CorruptedFeatureConfig(false)).method_23388(class_3284.field_14267.method_23475((class_2998)new class_3276(0, Rands.randFloatRange(0.0f, 1.0f), 1))));
        }
        float campfireChance = biomeData.getCampfireChance();
        float outpostChance = biomeData.getOutpostChance();
        float towerChance = biomeData.getTowerChance();
        float fossilChance = 0.0f;
        float shrineChance = 0.002f;
        if (Utils.checkBitFlag(dimensionData.getFlags(), 4)) {
            outpostChance = Rands.randFloatRange(0.002f, 0.003f);
            towerChance = Rands.randFloatRange(0.002f, 0.00225f);
        }
        if (Utils.checkBitFlag(dimensionData.getFlags(), 2)) {
            campfireChance = 0.0f;
            fossilChance = Rands.randFloatRange(0.007f, 0.0075f);
        }
        if (Utils.checkBitFlag(dimensionData.getFlags(), 16)) {
            campfireChance = Rands.randFloatRange(0.005f, 0.007f);
            outpostChance = Rands.randFloatRange(0.002f, 0.008f);
            towerChance = Rands.randFloatRange(0.002f, 0.003f);
        }
        this.method_8719(class_2893.class_2895.field_13173, Features.OUTPOST.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, outpostChance, 1))));
        this.method_8719(class_2893.class_2895.field_13173, Features.CAMPFIRE.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, campfireChance, 1))));
        this.method_8719(class_2893.class_2895.field_13173, Features.TOWER.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, towerChance, 1))));
        this.method_8719(class_2893.class_2895.field_13173, Features.FOSSIL.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, fossilChance, 1))));
        this.method_8719(class_2893.class_2895.field_13173, Features.SHRINE.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, shrineChance, 1))));
        this.method_8719(class_2893.class_2895.field_13173, Features.BEE_NEST.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, 1.0f, 1))));
        this.method_8719(class_2893.class_2895.field_13172, Features.CAVE_CAMPFIRE.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, 1.0f, 1))));
        this.method_8719(class_2893.class_2895.field_13173, Features.MUSHROOM_RUIN.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, 1.0f, 1))));
        this.method_8719(class_2893.class_2895.field_13172, Features.UNDERGROUND_BEE_HIVE.method_23397((class_3037)new class_3111()).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, 1.0f, 1))));
        if (biomeData.hasMushrooms()) {
            this.method_8719(class_2893.class_2895.field_13178, class_3031.field_13593.method_23397((class_3037)new class_3141((List)ImmutableList.of((Object)class_3031.field_13531.method_23397((class_3037)class_3864.field_21143).method_23387(1.0f)), class_3031.field_13510.method_23397((class_3037)class_3864.field_21126))).method_23388(class_3284.field_14267.method_23475((class_2998)new class_3276(0, Rands.randFloatRange(0.01f, 1.0f), 1))));
            this.method_8719(class_2893.class_2895.field_13178, class_3031.field_13593.method_23397((class_3037)new class_3141((List)ImmutableList.of((Object)class_3031.field_13571.method_23397((class_3037)class_3864.field_21142).method_23387(1.0f)), class_3031.field_13510.method_23397((class_3037)class_3864.field_21126))).method_23388(class_3284.field_14267.method_23475((class_2998)new class_3276(0, Rands.randFloatRange(0.01f, 1.0f), 1))));
        }
        if (biomeData.hasMossyRocks()) {
            class_3864.method_17012((class_1959)this);
        }
        class_3864.method_16982((class_1959)this);
        class_3864.method_16984((class_1959)this);
        class_3864.method_16996((class_1959)this);
        class_3864.method_16999((class_1959)this);
        if (Utils.checkBitFlag(dimensionData.getFlags(), 2) && Utils.checkBitFlag(dimensionData.getFlags(), 16) || Utils.checkBitFlag(dimensionData.getFlags(), 2) && Utils.checkBitFlag(dimensionData.getFlags(), 4)) {
            StoneCircleFeature STONE_CIRCLE = Features.register(String.format("%s_stone_circle", dimensionData.getId().method_12832()), new StoneCircleFeature(dimensionData));
            this.method_8719(class_2893.class_2895.field_13173, STONE_CIRCLE.method_23397((class_3037)class_3037.field_13603).method_23388(class_3284.field_14259.method_23475((class_2998)new class_3297(120))));
            this.method_8719(class_2893.class_2895.field_13173, Features.SPIDER_LAIR.method_23397((class_3037)class_3037.field_13603).method_23388(class_3284.field_14259.method_23475((class_2998)new class_3297(230))));
            TombFeature tomb = Features.register(String.format("%s_tomb", dimensionData.getId().method_12832()), new TombFeature(dimensionData));
            this.method_8719(class_2893.class_2895.field_13173, tomb.method_23397((class_3037)class_3037.field_13603).method_23388(Decorators.RANDOM_EXTRA_HEIGHTMAP_DECORATOR.method_23475((class_2998)new class_3276(0, 0.015f, 1))));
        }
        if (dimensionData.getMobs().containsKey("sheep")) {
            this.method_8708(class_1311.field_6294, new class_1959.class_1964(class_1299.field_6115, dimensionData.getMobs().get("sheep")[0], dimensionData.getMobs().get("sheep")[1], dimensionData.getMobs().get("sheep")[2]));
        }
        if (dimensionData.getMobs().containsKey("pig")) {
            this.method_8708(class_1311.field_6294, new class_1959.class_1964(class_1299.field_6093, dimensionData.getMobs().get("pig")[0], dimensionData.getMobs().get("pig")[1], dimensionData.getMobs().get("pig")[2]));
        }
        if (dimensionData.getMobs().containsKey("chicken")) {
            this.method_8708(class_1311.field_6294, new class_1959.class_1964(class_1299.field_6132, dimensionData.getMobs().get("chicken")[0], dimensionData.getMobs().get("chicken")[1], dimensionData.getMobs().get("chicken")[2]));
        }
        if (dimensionData.getMobs().containsKey("cow")) {
            this.method_8708(class_1311.field_6294, new class_1959.class_1964(class_1299.field_6085, dimensionData.getMobs().get("cow")[0], dimensionData.getMobs().get("cow")[1], dimensionData.getMobs().get("cow")[2]));
        }
        if (dimensionData.getMobs().containsKey("horse")) {
            this.method_8708(class_1311.field_6294, new class_1959.class_1964(class_1299.field_6139, dimensionData.getMobs().get("horse")[0], dimensionData.getMobs().get("horse")[1], dimensionData.getMobs().get("horse")[2]));
        }
        if (dimensionData.getMobs().containsKey("donkey")) {
            this.method_8708(class_1311.field_6294, new class_1959.class_1964(class_1299.field_6067, dimensionData.getMobs().get("donkey")[0], dimensionData.getMobs().get("donkey")[1], dimensionData.getMobs().get("donkey")[2]));
        }
        if (dimensionData.getMobs().containsKey("bat")) {
            this.method_8708(class_1311.field_6303, new class_1959.class_1964(class_1299.field_6108, dimensionData.getMobs().get("bat")[0], dimensionData.getMobs().get("bat")[1], dimensionData.getMobs().get("bat")[2]));
        }
        if (dimensionData.getMobs().containsKey("spider")) {
            this.method_8708(class_1311.field_6302, new class_1959.class_1964(class_1299.field_6079, dimensionData.getMobs().get("spider")[0], dimensionData.getMobs().get("spider")[1], dimensionData.getMobs().get("spider")[2]));
        }
        if (dimensionData.getMobs().containsKey("zombie")) {
            this.method_8708(class_1311.field_6302, new class_1959.class_1964(class_1299.field_6051, dimensionData.getMobs().get("zombie")[0], dimensionData.getMobs().get("zombie")[1], dimensionData.getMobs().get("zombie")[2]));
        }
        if (dimensionData.getMobs().containsKey("zombie_villager")) {
            this.method_8708(class_1311.field_6302, new class_1959.class_1964(class_1299.field_6054, dimensionData.getMobs().get("zombie_villager")[0], dimensionData.getMobs().get("zombie_villager")[1], dimensionData.getMobs().get("zombie_villager")[2]));
        }
        if (dimensionData.getMobs().containsKey("skeleton")) {
            this.method_8708(class_1311.field_6302, new class_1959.class_1964(class_1299.field_6137, dimensionData.getMobs().get("skeleton")[0], dimensionData.getMobs().get("skeleton")[1], dimensionData.getMobs().get("skeleton")[2]));
        }
        if (dimensionData.getMobs().containsKey("creeper")) {
            this.method_8708(class_1311.field_6302, new class_1959.class_1964(class_1299.field_6046, dimensionData.getMobs().get("creeper")[0], dimensionData.getMobs().get("creeper")[1], dimensionData.getMobs().get("creeper")[2]));
        }
        if (dimensionData.getMobs().containsKey("slime")) {
            this.method_8708(class_1311.field_6302, new class_1959.class_1964(class_1299.field_6069, dimensionData.getMobs().get("slime")[0], dimensionData.getMobs().get("slime")[1], dimensionData.getMobs().get("slime")[2]));
        }
        if (dimensionData.getMobs().containsKey("enderman")) {
            this.method_8708(class_1311.field_6302, new class_1959.class_1964(class_1299.field_6091, dimensionData.getMobs().get("enderman")[0], dimensionData.getMobs().get("enderman")[1], dimensionData.getMobs().get("enderman")[2]));
        }
        if (dimensionData.getMobs().containsKey("witch")) {
            this.method_8708(class_1311.field_6302, new class_1959.class_1964(class_1299.field_6145, dimensionData.getMobs().get("witch")[0], dimensionData.getMobs().get("witch")[1], dimensionData.getMobs().get("witch")[2]));
        }
    }

    public static class_4640 getTreeConfig(DimensionTreeData treeData) {
        class_4640 config;
        int height = treeData.getBaseHeight();
        int foliageHeight = treeData.getFoliageHeight();
        WoodType woodType = treeData.getWoodType().woodType;
        class_2680 logState = woodType.getLog().method_9564();
        class_2680 leafState = woodType.getLeaves().method_9564();
        ArrayList<Object> decoratorsRaw = new ArrayList<Object>();
        if (treeData.hasLeafVines()) {
            decoratorsRaw.add(new class_4661());
        }
        if (treeData.hasTrunkVines()) {
            decoratorsRaw.add(new class_4664());
        }
        if (treeData.hasCocoaBeans()) {
            decoratorsRaw.add(new class_4660(Rands.randFloatRange(0.1f, 1.0f)));
        }
        if (treeData.hasPodzolUnderneath()) {
            decoratorsRaw.add(new class_4658((class_4651)new class_4656(class_2246.field_10520.method_9564())));
        }
        ImmutableList decorators = ImmutableList.copyOf(decoratorsRaw);
        switch (Rands.randInt(9)) {
            case 1: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new class_4650(Rands.randIntRange(1, 4), 0)).method_23428(Rands.randIntRange(1, 6)).method_23430(height - 1).method_23437(foliageHeight).method_23438(Rands.randIntRange(1, 6)).method_23439(treeData.getMaxWaterDepth()).method_23433(Rands.randIntRange(1, 8)).method_23434(Rands.randIntRange(1, 4)).method_23436(Rands.randIntRange(1, 2)).method_23427().method_23429((List)decorators).method_23431();
                break;
            }
            case 2: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new class_4649(Rands.randIntRange(1, 2), 0)).method_23428(Rands.randIntRange(1, 4)).method_23430(height - 1).method_23435(Rands.randIntRange(1, 2)).method_23437(foliageHeight / 2).method_23438(Rands.randIntRange(1, 4)).method_23439(Rands.randIntRange(0, 8)).method_23427().method_23429((List)decorators).method_23431();
                break;
            }
            case 3: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new class_4645(Rands.randIntRange(1, 4), 0)).method_23428(Rands.randIntRange(1, 6)).method_23430(height - 1).method_23432(height + Rands.randIntRange(1, 4)).method_23433(Rands.randIntRange(1, 8)).method_23437(foliageHeight).method_23439(Rands.randIntRange(0, 8)).method_23427().method_23429((List)decorators).method_23431();
                break;
            }
            case 4: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new CylinderFoliagePlacer(Rands.randIntRange(1, 3), 0)).method_23428(Rands.randIntRange(1, 6)).method_23430(height - 1).method_23432(height + Rands.randIntRange(1, 4)).method_23433(Rands.randIntRange(1, 8)).method_23437(foliageHeight).method_23439(Rands.randIntRange(0, 8)).method_23427().method_23429((List)decorators).method_23431();
                break;
            }
            case 5: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new UpsideDownOakFoliagePlacer(Rands.randIntRange(1, 3), 0)).method_23428(Rands.randIntRange(1, 6)).method_23430(height - 1).method_23432(height + Rands.randIntRange(1, 4)).method_23433(Rands.randIntRange(1, 8)).method_23437(foliageHeight).method_23439(Rands.randIntRange(0, 8)).method_23427().method_23429((List)decorators).method_23431();
                break;
            }
            case 6: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new LongOakFoliagePlacer(Rands.randIntRange(1, 3), 0)).method_23428(Rands.randIntRange(1, 6)).method_23430(height - 1).method_23432(height + Rands.randIntRange(1, 4)).method_23433(Rands.randIntRange(1, 8)).method_23437(foliageHeight).method_23439(Rands.randIntRange(0, 8)).method_23427().method_23429((List)decorators).method_23431();
                break;
            }
            case 7: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new BoringOakFoliagePlacer(Rands.randIntRange(1, 3), 0)).method_23428(Rands.randIntRange(1, 6)).method_23430(height - 1).method_23432(height + Rands.randIntRange(1, 4)).method_23433(Rands.randIntRange(1, 8)).method_23437(foliageHeight).method_23439(Rands.randIntRange(0, 8)).method_23427().method_23429((List)decorators).method_23431();
                break;
            }
            case 8: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new RandomSpruceFoliagePlacer(Rands.randIntRange(1, 3), 0)).method_23428(Rands.randIntRange(1, 6)).method_23430(height - 1).method_23432(height + Rands.randIntRange(1, 4)).method_23433(Rands.randIntRange(1, 8)).method_23437(foliageHeight).method_23439(Rands.randIntRange(0, 8)).method_23427().method_23429((List)decorators).method_23431();
                break;
            }
            default: {
                config = new class_4640.class_4641((class_4651)new class_4656(logState), (class_4651)new class_4656(leafState), (class_4647)new class_4646(Rands.randIntRange(1, 3), 0)).method_23428(Rands.randIntRange(1, 6)).method_23430(height - 1).method_23437(foliageHeight).method_23438(Rands.randIntRange(1, 6)).method_23439(Rands.randIntRange(0, 8)).method_23427().method_23429((List)decorators).method_23431();
            }
        }
        return config;
    }

    private static class_4647 getFoliagePlacer(DimensionTreeData treeData) {
        switch (treeData.getFoliagePlacerType()) {
            case ACACIA: {
                return new class_4645(treeData.getFoliageRange(), 0);
            }
            case SPRUCE: {
                return new class_4650(treeData.getFoliageRange(), 0);
            }
            case PINE: {
                return new class_4649(treeData.getFoliageRange(), 0);
            }
            case LONG: {
                return new LongOakFoliagePlacer(treeData.getFoliageRange(), 0);
            }
            case UPSIDE_DOWN: {
                return new UpsideDownOakFoliagePlacer(treeData.getFoliageRange(), 0);
            }
            case BORING: {
                return new BoringOakFoliagePlacer(treeData.getFoliageRange(), 0);
            }
            case RANDOM: {
                return new RandomSpruceFoliagePlacer(treeData.getFoliageRange(), 0);
            }
            case CYLINDER: {
                return new CylinderFoliagePlacer(treeData.getFoliageRange(), 0);
            }
        }
        return new class_4646(treeData.getFoliageRange(), 0);
    }

    private static class_3031<class_4636> getMegaTree(DimensionTreeTypes treeTypes) {
        switch (treeTypes) {
            case MEGA_JUNGLE: {
                return class_3031.field_13558;
            }
            case MEGA_SPRUCE: {
                return class_3031.field_13580;
            }
            case DARK_OAK: {
                return class_3031.field_13532;
            }
        }
        return null;
    }

    private static class_3031<class_4640> getNormalTree(DimensionTreeTypes treeTypes) {
        switch (treeTypes) {
            case NORMAL: {
                return class_3031.field_13510;
            }
            case ACACIA: {
                return class_3031.field_21218;
            }
            case DOUBLE: {
                return Features.DOUBLE_TREE;
            }
            case BENT: {
                return Features.BENT_TREE;
            }
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public int method_8697() {
        return this.dimensionData.getDimensionColorPalette().getSkyColor();
    }

    @Environment(value=EnvType.CLIENT)
    public int method_8711(double double_1, double double_2) {
        return this.dimensionData.getDimensionColorPalette().getGrassColor();
    }
}

