/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.feature;

import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.utils.FeatureUtils;
import io.github.vampirestudios.raa.utils.Utils;
import io.github.vampirestudios.raa.utils.noise.old.OctaveOpenSimplexNoise;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2888;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;

public class StoneCircleFeature
extends class_3031<class_3111> {
    private static final OctaveOpenSimplexNoise offsetNoise = new OctaveOpenSimplexNoise(new Random(0L), 2, 25.0, 4.0, 3.0);
    private static final class_2960 LOOT_TABLE = new class_2960("raa", "chest/stone_circle");
    private static class_2680 STONE;
    private static class_2680 COBBLESTONE;

    public StoneCircleFeature(DimensionData dimensionData) {
        super(class_3111::method_13565);
        STONE = ((class_2248)class_2378.field_11146.method_10223(Utils.appendToPath(dimensionData.getId(), "_stone"))).method_9564();
        COBBLESTONE = ((class_2248)class_2378.field_11146.method_10223(Utils.appendToPath(dimensionData.getId(), "_cobblestone"))).method_9564();
    }

    public boolean generate(class_1936 world, class_2794<? extends class_2888> chunkGenerator, Random rand, class_2338 pos, class_3111 config) {
        return this.generate(world, rand, pos);
    }

    private boolean generate(class_1936 world, Random rand, class_2338 pos) {
        if (world.method_8320(pos.method_10069(0, -1, 0)).method_11588() || !world.method_8320(pos.method_10069(0, -1, 0)).method_11619() || world.method_8320(pos.method_10069(0, -1, 0)).equals(class_2246.field_9987.method_9564())) {
            return true;
        }
        int centreX = pos.method_10263() + rand.nextInt(16) - 8;
        int centreZ = pos.method_10260() + rand.nextInt(16) - 8;
        int lowY = pos.method_10264() - 1;
        int radius = rand.nextInt(6) + 14;
        int squaredRadius = radius * radius;
        int baseHeight = rand.nextInt(3) + 5;
        double pythagRadiusPart = Math.sqrt((double)squaredRadius / 2.0);
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        class_2338.class_2339 posMutable2 = new class_2338.class_2339();
        for (int quarter = 0; quarter < 4; ++quarter) {
            for (int localPosition = -1; localPosition < 2; ++localPosition) {
                int qBit1 = quarter & 1;
                int qBit2 = quarter & 2;
                double xOffset = 0.0;
                double zOffset = 0.0;
                if (qBit1 == 0) {
                    switch (localPosition) {
                        case -1: {
                            xOffset = -pythagRadiusPart;
                            break;
                        }
                        case 1: {
                            xOffset = pythagRadiusPart;
                            break;
                        }
                    }
                    zOffset = qBit2 == 0 ? (xOffset == 0.0 ? (double)radius : pythagRadiusPart) : (xOffset == 0.0 ? (double)(-radius) : -pythagRadiusPart);
                } else {
                    switch (localPosition) {
                        case -1: {
                            zOffset = -pythagRadiusPart;
                            break;
                        }
                        case 1: {
                            zOffset = pythagRadiusPart;
                            break;
                        }
                    }
                    xOffset = qBit2 == 0 ? (zOffset == 0.0 ? (double)radius : pythagRadiusPart) : (zOffset == 0.0 ? (double)(-radius) : -pythagRadiusPart);
                }
                posMutable.method_20787((int)((double)centreX + xOffset));
                posMutable.method_20788((int)((double)centreZ + zOffset));
                posMutable2.method_20787((int)((double)centreX + xOffset));
                posMutable2.method_20788((int)((double)centreZ + zOffset));
                this.generateStone((class_1945)world, rand, (class_2338)posMutable, posMutable2, baseHeight + rand.nextInt(3), lowY);
            }
        }
        if (rand.nextInt(3) == 0) {
            FeatureUtils.setLootChest(world, new class_2338(centreX + rand.nextInt(3) - 1, lowY - 2 - rand.nextInt(3), centreZ + rand.nextInt(3) - 1), LOOT_TABLE, rand);
        }
        Utils.createSpawnsFile("stone_circle", world, pos);
        return true;
    }

    private void generateStone(class_1945 world, Random rand, class_2338 centre, class_2338.class_2339 mutable, int height, int lowY) {
        int posX = centre.method_10263();
        int posZ = centre.method_10260();
        for (int xOffset = -3; xOffset < 4; ++xOffset) {
            mutable.method_20787(posX + xOffset);
            for (int zOffset = -3; zOffset < 4; ++zOffset) {
                mutable.method_20788(posZ + zOffset);
                mutable.method_10099(0);
                double squaredDistanceTo = centre.method_10262((class_2382)mutable) / 9.0;
                int localHeight = (int)offsetNoise.sample(mutable.method_10263(), mutable.method_10260()) + (int)class_3532.method_16436((double)squaredDistanceTo, (double)height, (double)0.0) + lowY;
                for (int y = lowY - 5; y < localHeight + 1; ++y) {
                    mutable.method_10099(y);
                    world.method_8652((class_2338)mutable, rand.nextInt(3) == 0 ? COBBLESTONE : STONE, 19);
                }
            }
        }
    }
}

