/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.feature;

import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.utils.FeatureUtils;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.Utils;
import io.github.vampirestudios.raa.utils.noise.old.OctaveOpenSimplexNoise;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1936;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2888;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3531;
import net.minecraft.class_3532;

public class TombFeature
extends class_3031<class_3111> {
    private static final OctaveOpenSimplexNoise offsetNoise = new OctaveOpenSimplexNoise(new Random(0L), 2, 30.0, 4.0, 2.0);
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final class_1299<?> SKELETON = class_1299.field_6137;
    private static final class_2960 LOOT_TABLE = new class_2960("raa", "chest/tomb");
    private static class_2680 STONE;

    public TombFeature(DimensionData dimensionData) {
        super(class_3111::method_13565);
        STONE = ((class_2248)class_2378.field_11146.method_10223(Utils.appendToPath(dimensionData.getId(), "_stone"))).method_9564();
    }

    public boolean generate(class_1936 world, class_2794<? extends class_2888> chunkGenerator, Random rand, class_2338 pos, class_3111 config) {
        if (world.method_8320(pos.method_10069(0, -3, 0)).method_11588() || !world.method_8320(pos.method_10069(0, -3, 0)).method_11619() || world.method_8320(pos.method_10069(0, -1, 0)).equals(class_2246.field_9987.method_9564())) {
            return true;
        }
        class_1966 source = chunkGenerator.method_12098();
        return this.generate(world, rand, pos.method_10069(0, -3, 0), (x, y, z) -> source.method_16359(x, y, z).method_8722());
    }

    private boolean generate(class_1936 world, Random rand, class_2338 pos, Coordinate3iFunction<class_3531> configFunction) {
        int centreX = pos.method_10263() + rand.nextInt(16) - 8;
        int centreZ = pos.method_10260() + rand.nextInt(16) - 8;
        int lowY = pos.method_10264() - 3;
        int radius = rand.nextInt(10) + 7;
        int height = rand.nextInt(8) + 6;
        double radiusSquared = radius * radius;
        class_243 origin = new class_243((double)centreX, 0.0, (double)centreZ);
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            int x = centreX + xOffset;
            for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                int z = centreZ + zOffset;
                class_243 position = new class_243((double)x, 0.0, (double)z);
                double sqrDistTo = position.method_1025(origin);
                if (!(sqrDistTo <= radiusSquared)) continue;
                double progress = class_3532.method_16435((double)(sqrDistTo / radiusSquared));
                int heightOffset = (int)class_3532.method_16436((double)progress, (double)height, (double)0.0);
                posMutable.method_20787(x);
                posMutable.method_20788(z);
                this.generateBarrowColumn(world, rand, lowY, heightOffset += (int)class_3532.method_16436((double)progress, (double)offsetNoise.sample(x, z), (double)0.0), posMutable, configFunction.get(x, lowY + heightOffset, z));
            }
        }
        Utils.createSpawnsFile("tomb", world, pos);
        return true;
    }

    private void generateBarrowColumn(class_1936 world, Random rand, int lowY, int heightOffset, class_2338.class_2339 pos, class_3531 surfaceConfig) {
        int upperY;
        for (int y = upperY = lowY + heightOffset; y >= lowY; --y) {
            pos.method_10099(y);
            if (y == upperY) {
                world.method_8652((class_2338)pos, surfaceConfig.method_15337(), 19);
                continue;
            }
            if (y > upperY - 3) {
                world.method_8652((class_2338)pos, surfaceConfig.method_15336(), 19);
                continue;
            }
            if (y == lowY && rand.nextInt(48) == 0) {
                if (rand.nextInt(4) == 0) {
                    FeatureUtils.setLootChest(world, (class_2338)pos, LOOT_TABLE, rand);
                    continue;
                }
                FeatureUtils.setSpawner(world, (class_2338)pos, Rands.chance(2) ? SKELETON : class_1299.field_6051);
                continue;
            }
            world.method_8652((class_2338)pos, y <= lowY + 1 ? STONE : AIR, 19);
        }
    }

    private static interface Coordinate3iFunction<T> {
        public T get(int var1, int var2, int var3);
    }

    private static interface Coordinate2iFunction<T> {
        public T get(int var1, int var2);
    }
}

