/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.feature;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import io.github.vampirestudios.raa.utils.JsonConverter;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.Utils;
import io.github.vampirestudios.raa.utils.WorldStructureManipulation;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_39;

public class TowerFeature
extends class_3031<class_3111> {
    private final JsonConverter converter = new JsonConverter();
    private Map<String, JsonConverter.StructureValues> structures;

    public TowerFeature(Function<Dynamic<?>, ? extends class_3111> function) {
        super(function);
    }

    private static void placePiece(class_1936 world, class_2338 pos, int rotation, JsonConverter.StructureValues piece, int decay) {
        for (int i = 0; i < piece.getBlockPositions().size(); ++i) {
            class_2382 currBlockPos = piece.getBlockPositions().get(i);
            String currBlockType = piece.getBlockTypes().get(piece.getBlockStates().get(i));
            Map<String, String> currBlockProp = piece.getBlockProperties().get(piece.getBlockStates().get(i));
            currBlockPos = WorldStructureManipulation.rotatePos(rotation, currBlockPos, piece.getSize());
            if (currBlockType.equals("minecraft:air") || decay > 0 && Rands.chance(14 - decay)) {
                WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), "minecraft:air", new HashMap<String, String>(), rotation);
                continue;
            }
            if (currBlockType.equals("minecraft:stone_bricks")) {
                WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), "raa:" + world.method_8597().method_12460().method_12489().substring(4) + "_stone_bricks", new HashMap<String, String>(), rotation);
                continue;
            }
            if (currBlockType.equals("minecraft:ladder")) {
                WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), currBlockType, currBlockProp, (6 - rotation) % 4);
                continue;
            }
            WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), currBlockType, currBlockProp, rotation);
        }
    }

    private static void fillWindows(class_1936 world, class_2338 pos, int fill) {
        for (int i = 0; i < 4; ++i) {
            float xPart = 6.5f - 5.5f * class_3532.method_15362((float)((float)(1.5707963267948966 * (double)i)));
            float zPart = 6.5f - 5.5f * class_3532.method_15374((float)((float)(1.5707963267948966 * (double)i)));
            float xPart2 = 6.5f - 6.5f * class_3532.method_15362((float)((float)(1.5707963267948966 * (double)i)));
            float zPart2 = 6.5f - 6.5f * class_3532.method_15374((float)((float)(1.5707963267948966 * (double)i)));
            for (int j = 2; j < 4; ++j) {
                if (!world.method_22347(pos.method_10069(class_3532.method_15375((float)xPart2), j, class_3532.method_15375((float)zPart2))) || fill + 2 == j || fill == 2) {
                    world.method_8652(pos.method_10069(class_3532.method_15375((float)xPart), j, class_3532.method_15375((float)zPart)), ((class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)("raa:" + world.method_8597().method_12460().method_12489().substring(4) + "_stone_bricks")))).method_9564(), 2);
                }
                if (world.method_22347(pos.method_10069(class_3532.method_15386((float)xPart2), j, class_3532.method_15386((float)zPart2))) && fill + 2 != j && fill != 2) continue;
                world.method_8652(pos.method_10069(class_3532.method_15386((float)xPart), j, class_3532.method_15386((float)zPart)), ((class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)("raa:" + world.method_8597().method_12460().method_12489().substring(4) + "_stone_bricks")))).method_9564(), 2);
            }
        }
    }

    private static void placeDecoration(class_1936 world, class_2338 pos, int rotation, List<String> blocks, List<class_2382> blockPos, List<Map<String, String>> blockProps) {
        if (!world.method_22347(pos.method_10069(0, -1, 0))) {
            for (int i = 0; i < blockPos.size(); ++i) {
                String currBlock = blocks.get(i);
                class_2382 currPos = blockPos.get(i);
                Map<String, String> currProps = blockProps.get(i);
                int x = currPos.method_10263();
                int z = currPos.method_10260();
                int y = currPos.method_10264();
                int chestType = 0;
                int xTemp = x;
                x = (x + z) * Math.round(class_3532.method_15362((float)((float)(1.5707963267948966 * (double)(rotation - z)))));
                z = (xTemp + z) * -Math.round(class_3532.method_15374((float)((float)(1.5707963267948966 * (double)(rotation - z)))));
                currPos = new class_2382(x, currPos.method_10264(), z);
                if (currBlock.equals("armor_stand")) {
                    float standRotation = rotation % 2 == 0 ? -45.0f : 45.0f;
                    WorldStructureManipulation.spawnEntity(world, pos.method_10081(currPos), "minecraft:armor_stand", currProps, standRotation % 360.0f - 180.0f);
                    continue;
                }
                if (currBlock.equals("barrel") && blocks.size() != 1) {
                    int rotate = new Random().nextInt(3);
                    currProps.put("facing", rotate == 0 ? "SOUTH" : (rotate == 1 ? "EAST" : "UP"));
                } else if (currBlock.equals("potted_")) {
                    String[] plants = new String[]{"white_tulip", "spruce_sapling", "red_tulip", "red_mushroom", "poppy", "pink_tulip", "oxeye_daisy", "orange_tulip", "oak_sapling", "lily_of_the_valley", "jungle_sapling", "fern", "dead_bush", "dark_oak_sapling", "dandelion", "cactus", "brown_mushroom", "blue_orchid", "birch_sapling", "bamboo", "azure_bluet", "allium", "acacia_sapling", "cornflower"};
                    currBlock = currBlock + plants[new Random().nextInt(plants.length)];
                } else if (currBlock.equals("iron_bars") && currProps.get("west") == null) {
                    if (x == z && y == 0) {
                        currProps.put("north", "TRUE");
                        currProps.put("west", "TRUE");
                        currProps.put("south", "TRUE");
                        currProps.put("east", "TRUE");
                    } else {
                        currProps.put("north", "TRUE");
                        currProps.put("west", "TRUE");
                    }
                } else if (currBlock.contains("chest")) {
                    chestType = currBlock.equals("chest1") ? 1 : (currBlock.equals("chest2") ? 2 : 3);
                    currBlock = "chest";
                }
                WorldStructureManipulation.placeBlock(world, pos.method_10081(currPos), "minecraft:" + currBlock, currProps, rotation);
                if (chestType == 1) {
                    class_2621.method_11287((class_1922)world, (Random)Rands.getRandom(), (class_2338)pos.method_10069(x, y, z), (class_2960)class_39.field_880);
                    continue;
                }
                if (chestType == 2) {
                    class_2621.method_11287((class_1922)world, (Random)Rands.getRandom(), (class_2338)pos.method_10069(x, y, z), (class_2960)class_39.field_434);
                    continue;
                }
                if (chestType != 3) continue;
                if (Rands.chance(5)) {
                    class_2621.method_11287((class_1922)world, (Random)Rands.getRandom(), (class_2338)pos.method_10069(x, y, z), (class_2960)class_39.field_356);
                    continue;
                }
                if (Rands.chance(8)) {
                    class_2621.method_11287((class_1922)world, (Random)Rands.getRandom(), (class_2338)pos.method_10069(x, y, z), (class_2960)class_39.field_683);
                    continue;
                }
                class_2621.method_11287((class_1922)world, (Random)Rands.getRandom(), (class_2338)pos.method_10069(x, y, z), (class_2960)class_39.field_16751);
            }
        }
    }

    private static void placeRoom(class_1936 world, class_2338 pos, Map<String, JsonConverter.StructureValues> pieces, String type, int decay) {
        TowerFeature.placePiece(world, pos.method_10069(1, 0, 1), 0, pieces.get("tower_walls"), decay + 2);
        if (Rands.chance(2)) {
            TowerFeature.placePiece(world, pos, new Random().nextInt(4), pieces.get("tower_stairs"), decay - 1);
        } else {
            TowerFeature.placePiece(world, pos, new Random().nextInt(4), pieces.get("tower_ladders"), decay - 1);
        }
        String cornerBlocksString = "barrel, barrel, barrel, barrel; wall_torch; smoker; furnace; crafting_table; iron_bars, iron_bars, iron_bars, iron_bars; oak_fence, oak_pressure_plate; smithing_table; blast_furnace; armor_stand; oak_stairs, oak_stairs, white_carpet, red_carpet; oak_fence, oak_pressure_plate, oak_stairs; scaffolding, potted_; bookshelf, bookshelf; armor_stand";
        String cornerPosString = "0 0 0, 0 0 1, 1 0 0, 0 1 0; 0 1 0; 0 0 0; 0 0 0; 0 0 0; 0 0 0, 0 0 1, 1 0 0, 0 1 0; 0 0 0, 0 1 0; 0 0 0; 0 0 0; 0 0 0; 0 0 0, 0 0 1, 0 1 0, 0 1 1; 0 0 0, 0 1 0, 0 0 1; 0 0 0, 0 1 0; 0 0 0, 0 1 0; 0 0 0";
        String cornerPropsString = "facing:UP, facing:UP, facing:UP, facing:UP; facing:SOUTH; facing:SOUTH; facing:SOUTH; NULL; NULL, NULL, NULL, NULL; NULL, NULL; NULL; facing:SOUTH; NULL; facing:NORTH half:TOP shape:STRAIGHT, facing:SOUTH half:TOP shape:STRAIGHT, NULL, NULL; NULL, NULL, facing:SOUTH half:BOTTOM shape:STRAIGHT; distance:0, NULL; NULL, NULL; NULL";
        String centerBlocksString = "chest1, air; barrel; stonecutter; tnt; oak_fence, oak_pressure_plate; chest2, air; iron_bars; damaged_anvil; grindstone; armor_stand; chest3, air; bell; scaffolding, oak_pressure_plate; scaffolding, lantern";
        String centerPosString = "0 0 0, 0 0 1; 0 0 0; 0 0 0; 0 0 0; 0 0 0, 0 1 0; 0 0 0, 0 0 1; 0 0 0; 0 0 0; 0 0 0; 0 0 0; 0 0 0, 0 0 1; 0 1 0; 0 0 0, 0 1 0; 0 0 0, 0 1 0";
        String centerPropsString = "facing:SOUTH type:SINGLE, NULL; facing:UP; facing:SOUTH; NULL; NULL, NULL; facing:SOUTH type:SINGLE, NULL; west:TRUE east:TRUE; facing:WEST; face:FLOOR facing:WEST; head:5 chest:5 legs:5 feet:5 weapon:4; facing:SOUTH type:SINGLE, NULL; attachment:SINGLE_WALL facing:NORTH; distance:0, NULL; distance:0, NULL";
        ArrayList<List<String>> cornerBlocks = new ArrayList<List<String>>();
        ArrayList<List<class_2382>> cornerPos = new ArrayList<List<class_2382>>();
        ArrayList<List<Map<String, String>>> cornerProps = new ArrayList<List<Map<String, String>>>();
        TowerFeature.decorateRooms(cornerBlocksString, cornerPosString, cornerPropsString, cornerBlocks, cornerPos, cornerProps);
        ArrayList<List<String>> centerBlocks = new ArrayList<List<String>>();
        ArrayList<List<class_2382>> centerPos = new ArrayList<List<class_2382>>();
        ArrayList<List<Map<String, String>>> centerProps = new ArrayList<List<Map<String, String>>>();
        TowerFeature.decorateRooms(centerBlocksString, centerPosString, centerPropsString, centerBlocks, centerPos, centerProps);
        Random rand = new Random();
        switch (type) {
            case "Storage": {
                int randIndex;
                int i;
                for (i = 0; i < 8; ++i) {
                    world.method_8652(pos.method_10069(6 + i % 2, 0, 5 + i / 2), (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036), 2);
                    if (i % 6 / 2 == 0) continue;
                    world.method_8652(pos.method_10069(6 + i % 2, 1, 5 + i / 2), (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036), 2);
                }
                world.method_8652(pos.method_10069(5, 0, 7), (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036), 2);
                world.method_8652(pos.method_10069(8, 0, 6), (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036), 2);
                for (i = 0; i < 4; ++i) {
                    randIndex = rand.nextInt(5);
                    TowerFeature.placeDecoration(world, pos.method_10069(3 + 7 * (i / 2), 0, 3 + 7 * Math.round(class_3532.method_15374((float)((float)(1.0471975511965976 * (double)i))))), i, (List)cornerBlocks.get(randIndex), (List)cornerPos.get(randIndex), (List)cornerProps.get(randIndex));
                }
                randIndex = rand.nextInt(5);
                TowerFeature.placeDecoration(world, pos.method_10069(5, 0, 6), 3, (List)centerBlocks.get(randIndex), (List)centerPos.get(randIndex), (List)centerProps.get(randIndex));
                randIndex = rand.nextInt(5);
                TowerFeature.placeDecoration(world, pos.method_10069(8, 0, 7), 1, (List)centerBlocks.get(randIndex), (List)centerPos.get(randIndex), (List)centerProps.get(randIndex));
                TowerFeature.fillWindows(world, pos, 2);
                break;
            }
            case "Armory": {
                int randIndex;
                int i;
                for (i = 0; i < 4; ++i) {
                    world.method_8652(pos.method_10069(6 + i % 2, 0, 5 + i / 2 * 3), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), 2);
                }
                world.method_8652(pos.method_10069(5, 0, 5), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), 2);
                world.method_8652(pos.method_10069(5, 0, 8), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), 2);
                world.method_8652(pos.method_10069(8, 0, 5), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), 2);
                world.method_8652(pos.method_10069(8, 0, 8), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), 2);
                world.method_8652(pos.method_10069(5, 0, 7), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), 2);
                world.method_8652(pos.method_10069(8, 0, 6), (class_2680)((class_2680)class_2246.field_10576.method_9564().method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), 2);
                for (i = 0; i < 4; ++i) {
                    randIndex = rand.nextInt(5) + 5;
                    TowerFeature.placeDecoration(world, pos.method_10069(3 + 7 * (i / 2), 0, 3 + 7 * Math.round(class_3532.method_15374((float)((float)(1.0471975511965976 * (double)i))))), i, (List)cornerBlocks.get(randIndex), (List)cornerPos.get(randIndex), (List)cornerProps.get(randIndex));
                }
                randIndex = rand.nextInt(5) + 5;
                TowerFeature.placeDecoration(world, pos.method_10069(5, 0, 6), 3, (List)centerBlocks.get(randIndex), (List)centerPos.get(randIndex), (List)centerProps.get(randIndex));
                randIndex = rand.nextInt(5) + 5;
                TowerFeature.placeDecoration(world, pos.method_10069(8, 0, 7), 1, (List)centerBlocks.get(randIndex), (List)centerPos.get(randIndex), (List)centerProps.get(randIndex));
                TowerFeature.fillWindows(world, pos, 0);
                break;
            }
            case "Barracks": {
                int randIndex;
                int i;
                for (int i2 = 0; i2 < 4; ++i2) {
                    world.method_8652(pos.method_10069(6 + i2 % 2, 0, 6 + i2 / 2), class_2246.field_10161.method_9564(), 2);
                    world.method_8652(pos.method_10069(6 + i2 % 2, 1, 6 + i2 / 2), class_2246.field_10504.method_9564(), 2);
                }
                List<String> bedSheets = Arrays.asList("white_carpet", "red_carpet");
                List<class_2382> bedPos = Arrays.asList(class_2382.field_11176, new class_2382(0, 0, 1), new class_2382(0, 1, 0), new class_2382(0, 1, 1));
                List<Map<String, String>> bedProps = Arrays.asList(ImmutableMap.of((Object)"facing", (Object)"NORTH", (Object)"half", (Object)"TOP", (Object)"shape", (Object)"STRAIGHT"), ImmutableMap.of((Object)"facing", (Object)"SOUTH", (Object)"half", (Object)"TOP", (Object)"shape", (Object)"STRAIGHT"), new HashMap(), new HashMap());
                for (i = 0; i < 4; ++i) {
                    int x = 5 + 3 * (i / 2);
                    int z = 5 + 3 * Math.round(class_3532.method_15374((float)((float)(1.0471975511965976 * (double)i))));
                    List<String> bedItems = Arrays.asList("oak_stairs", "oak_stairs", bedSheets.get((i + 1) % 2), bedSheets.get(i % 2));
                    TowerFeature.placeDecoration(world, pos.method_10069(x, 0, z), (i + 1) % 4, bedItems, bedPos, bedProps);
                    if (i % 2 != 0) continue;
                    List<String> tableItems = Arrays.asList("scaffolding", "oak_pressure_plate");
                    List<class_2382> tablePos = Arrays.asList(class_2382.field_11176, new class_2382(0, 1, 0));
                    List<Map<String, String>> tableProps = Arrays.asList(ImmutableMap.of((Object)"distance", (Object)"0"), new HashMap());
                    TowerFeature.placeDecoration(world, pos.method_10069(x - 2 * i + 2, 0, z), i, tableItems, tablePos, tableProps);
                }
                for (i = 0; i < 4; ++i) {
                    randIndex = rand.nextInt(5) + 10;
                    TowerFeature.placeDecoration(world, pos.method_10069(3 + 7 * (i / 2), 0, 3 + 7 * Math.round(class_3532.method_15374((float)((float)(1.0471975511965976 * (double)i))))), i, (List)cornerBlocks.get(randIndex), (List)cornerPos.get(randIndex), (List)cornerProps.get(randIndex));
                }
                randIndex = rand.nextInt(4) + 10;
                TowerFeature.placeDecoration(world, pos.method_10069(5, 0, 6), 3, (List)centerBlocks.get(randIndex), (List)centerPos.get(randIndex), (List)centerProps.get(randIndex));
                randIndex = rand.nextInt(4) + 10;
                TowerFeature.placeDecoration(world, pos.method_10069(8, 0, 7), 1, (List)centerBlocks.get(randIndex), (List)centerPos.get(randIndex), (List)centerProps.get(randIndex));
                TowerFeature.fillWindows(world, pos, 1);
                break;
            }
            case "Empty2": {
                TowerFeature.fillWindows(world, pos, 1);
                break;
            }
            default: {
                TowerFeature.fillWindows(world, pos, 0);
            }
        }
        if (Rands.chance(2)) {
            TowerFeature.placePiece(world, pos.method_10069(6, 0, 6), 0, pieces.get("tower_pillar"), decay);
        }
    }

    private static void decorateRooms(String blocksString, String posString, String propsString, List<List<String>> blocks, List<List<class_2382>> pos, List<List<Map<String, String>>> props) {
        Object temp4;
        String[] temp3;
        ArrayList<Object> temp2;
        List<String> temp1 = Arrays.asList(blocksString.split("; "));
        for (String i : temp1) {
            blocks.add(Arrays.asList(i.split(", ")));
        }
        temp1 = Arrays.asList(posString.split("; "));
        for (String i : temp1) {
            temp2 = new ArrayList<Object>();
            for (String j : temp3 = i.split(", ")) {
                temp4 = Arrays.asList(j.split(" "));
                temp2.add(new class_2382(Integer.parseInt(temp4.get(0)), Integer.parseInt(temp4.get(1)), Integer.parseInt((String)temp4.get(2))));
            }
            pos.add(temp2);
        }
        temp1 = Arrays.asList(propsString.split("; "));
        for (String i : temp1) {
            temp2 = new ArrayList();
            for (String j : temp3 = i.split(", ")) {
                temp4 = new HashMap();
                if (!j.equals("NULL")) {
                    String[] temp5;
                    for (String k : temp5 = j.split(" ")) {
                        List<String> temp6 = Arrays.asList(k.split(":"));
                        temp4.put(temp6.get(0), temp6.get(1));
                    }
                }
                temp2.add(temp4);
            }
            props.add(temp2);
        }
    }

    public boolean generate(class_1936 world, class_2794 chunkGenerator, Random random, class_2338 pos, class_3111 config) {
        int i;
        JsonObject towerBase = null;
        JsonObject towerWalls = null;
        JsonObject towerStairs = null;
        JsonObject towerLadders = null;
        JsonObject towerPillar = null;
        JsonObject towerRoof = null;
        try {
            class_3298 towerBasePath = world.method_8410().method_8503().method_3809().method_14486(new class_2960("raa:structures/tower/tower_base.json"));
            final JsonObject finalTowerBase = towerBase = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(towerBasePath.method_14482()), JsonObject.class);
            class_3298 towerWallsPath = world.method_8410().method_8503().method_3809().method_14486(new class_2960("raa:structures/tower/tower_walls.json"));
            final JsonObject finalTowerWalls = towerWalls = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(towerWallsPath.method_14482()), JsonObject.class);
            class_3298 towerStairsPath = world.method_8410().method_8503().method_3809().method_14486(new class_2960("raa:structures/tower/tower_stairs.json"));
            final JsonObject finalTowerStairs = towerStairs = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(towerStairsPath.method_14482()), JsonObject.class);
            class_3298 towerLaddersPath = world.method_8410().method_8503().method_3809().method_14486(new class_2960("raa:structures/tower/tower_ladders.json"));
            final JsonObject finalTowerLadders = towerLadders = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(towerLaddersPath.method_14482()), JsonObject.class);
            class_3298 towerPillarPath = world.method_8410().method_8503().method_3809().method_14486(new class_2960("raa:structures/tower/tower_pillar.json"));
            final JsonObject finalTowerPillar = towerPillar = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(towerPillarPath.method_14482()), JsonObject.class);
            class_3298 towerRoofPath = world.method_8410().method_8503().method_3809().method_14486(new class_2960("raa:structures/tower/tower_roof.json"));
            final JsonObject finalTowerRoof = towerRoof = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(towerRoofPath.method_14482()), JsonObject.class);
            this.structures = new HashMap<String, JsonConverter.StructureValues>(){
                {
                    this.put("tower_base", TowerFeature.this.converter.loadStructure(finalTowerBase));
                    this.put("tower_walls", TowerFeature.this.converter.loadStructure(finalTowerWalls));
                    this.put("tower_stairs", TowerFeature.this.converter.loadStructure(finalTowerStairs));
                    this.put("tower_ladders", TowerFeature.this.converter.loadStructure(finalTowerLadders));
                    this.put("tower_pillar", TowerFeature.this.converter.loadStructure(finalTowerPillar));
                    this.put("tower_roof", TowerFeature.this.converter.loadStructure(finalTowerRoof));
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (towerBase == null || towerWalls == null || towerStairs == null || towerLadders == null || towerPillar == null || towerRoof == null) {
            System.out.println("Can't get the file");
            return true;
        }
        class_2382 size = this.structures.get("tower_base").getSize();
        class_2382 tempPos = WorldStructureManipulation.circularSpawnCheck(world, pos, new class_2382(size.method_10263(), 9, size.method_10260()), 0.25f);
        if (tempPos.method_10265(class_2382.field_11176) == 0) {
            return true;
        }
        pos = new class_2338(tempPos);
        if (pos.method_10264() > 10 && Rands.chance(3)) {
            TowerFeature.placePiece(world, pos.method_10069(0, -7, 0), 0, this.structures.get("tower_base"), 0);
            TowerFeature.placeRoom(world, pos.method_10069(0, -6, 0), this.structures, "Storage", -2);
        }
        TowerFeature.placePiece(world, pos, 0, this.structures.get("tower_base"), 0);
        int lastFloor = -1;
        int levelChance = new Random().nextInt(20);
        int level = 0;
        while (levelChance < 24 - 7 * level && pos.method_10264() + 7 * level < 248) {
            int roomNum = new Random().nextInt(3);
            while (roomNum == lastFloor) {
                roomNum = new Random().nextInt(3);
            }
            lastFloor = roomNum;
            String roomName = roomNum == 0 ? "Armory" : (roomNum == 1 ? "Barracks" : (roomNum == 2 && Rands.chance(2) ? "Empty2" : "Empty"));
            TowerFeature.placeRoom(world, pos.method_10069(0, 1 + level * 7, 0), this.structures, roomName, 2 * level + 2);
            ++level;
        }
        TowerFeature.placePiece(world, pos.method_10069(0, 1 + level * 7, 0), 0, this.structures.get("tower_roof"), 2 * level + 4);
        List<Integer> windowsOpen = Arrays.asList(0, 0, 0, 0);
        int max = 0;
        int index = 0;
        for (i = 0; i < 4; ++i) {
            for (int j = 1; j < 4; ++j) {
                if (world.method_22347(pos.method_10069(class_3532.method_15375((float)(6.5f + 6.5f * class_3532.method_15362((float)(1.5707964f * (float)i)))), j, class_3532.method_15375((float)(6.5f + 6.5f * class_3532.method_15374((float)(1.5707964f * (float)i))))))) {
                    windowsOpen.set(i, windowsOpen.get(i) + 1);
                }
                if (!world.method_22347(pos.method_10069(class_3532.method_15386((float)(6.5f + 6.5f * class_3532.method_15362((float)(1.5707964f * (float)i)))), j, class_3532.method_15386((float)(6.5f + 6.5f * class_3532.method_15374((float)(1.5707964f * (float)i))))))) continue;
                windowsOpen.set(i, windowsOpen.get(i) + 1);
            }
            if (windowsOpen.get(i) <= max) continue;
            max = windowsOpen.get(i);
            index = i;
        }
        for (i = 0; i < 4; ++i) {
            if (i == 0) {
                world.method_8652(pos.method_10069(class_3532.method_15375((float)(6.5f + 5.5f * class_3532.method_15362((float)(1.5707964f * (float)index)))), 4 - i, class_3532.method_15375((float)(6.5f + 5.5f * class_3532.method_15374((float)(1.5707964f * (float)index))))), ((class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)("raa:" + world.method_8597().method_12460().method_12489().substring(4) + "_stone_bricks")))).method_9564(), 2);
                world.method_8652(pos.method_10069(class_3532.method_15386((float)(6.5f + 5.5f * class_3532.method_15362((float)(1.5707964f * (float)index)))), 4 - i, class_3532.method_15386((float)(6.5f + 5.5f * class_3532.method_15374((float)(1.5707964f * (float)index))))), ((class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)("raa:" + world.method_8597().method_12460().method_12489().substring(4) + "_stone_bricks")))).method_9564(), 2);
                continue;
            }
            world.method_8652(pos.method_10069(class_3532.method_15375((float)(6.5f + 5.5f * class_3532.method_15362((float)(1.5707964f * (float)index)))), 4 - i, class_3532.method_15375((float)(6.5f + 5.5f * class_3532.method_15374((float)(1.5707964f * (float)index))))), class_2246.field_10124.method_9564(), 2);
            world.method_8652(pos.method_10069(class_3532.method_15386((float)(6.5f + 5.5f * class_3532.method_15362((float)(1.5707964f * (float)index)))), 4 - i, class_3532.method_15386((float)(6.5f + 5.5f * class_3532.method_15374((float)(1.5707964f * (float)index))))), class_2246.field_10124.method_9564(), 2);
        }
        Utils.createSpawnsFile("tower", world, pos);
        return true;
    }
}

