/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.feature;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import io.github.vampirestudios.raa.utils.JsonConverter;
import io.github.vampirestudios.raa.utils.Utils;
import io.github.vampirestudios.raa.utils.WorldStructureManipulation;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2888;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3298;

public class UndegroundBeeHiveFeature
extends class_3031<class_3111> {
    private JsonConverter converter = new JsonConverter();
    private Map<String, JsonConverter.StructureValues> structures;

    public UndegroundBeeHiveFeature(Function<Dynamic<?>, ? extends class_3111> function) {
        super(function);
    }

    public boolean generate(class_1936 world, class_2794<? extends class_2888> generator, Random random, class_2338 pos, class_3111 config) {
        JsonObject jsonObject = null;
        try {
            class_3298 path = world.method_8410().method_8503().method_3809().method_14486(new class_2960("raa:structures/underground_bee_nest.json"));
            final JsonObject finalJsonObject = jsonObject = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(path.method_14482()), JsonObject.class);
            this.structures = new HashMap<String, JsonConverter.StructureValues>(){
                {
                    this.put("underground_bee_nest", UndegroundBeeHiveFeature.this.converter.loadStructure(finalJsonObject));
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (jsonObject == null) {
            System.out.println("Can't get the file");
            return true;
        }
        class_2382 tempPos = WorldStructureManipulation.circularSpawnCheck(world, pos, this.structures.get("underground_bee_nest").getSize(), 0.125f, true);
        if (tempPos.method_10265(class_2382.field_11176) == 0) {
            return true;
        }
        pos = new class_2338(tempPos);
        JsonConverter.StructureValues shrine = this.structures.get("underground_bee_nest");
        int rotation = new Random().nextInt(4);
        for (int i = 0; i < shrine.getBlockPositions().size(); ++i) {
            String currBlockType = shrine.getBlockTypes().get(shrine.getBlockStates().get(i));
            if (!currBlockType.equals("minecraft:cave_air")) continue;
            class_2382 currBlockPos = shrine.getBlockPositions().get(i);
            Map<String, String> currBlockProp = shrine.getBlockProperties().get(shrine.getBlockStates().get(i));
            currBlockPos = WorldStructureManipulation.rotatePos(rotation, currBlockPos, shrine.getSize());
            WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), currBlockType, currBlockProp, rotation);
        }
        Utils.createSpawnsFile("underground_bee_hive", world, pos);
        return true;
    }
}

