/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.feature.portalHub;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.generation.feature.portalHub.PortalHubTheme;
import io.github.vampirestudios.raa.generation.feature.portalHub.PortalHubThemes;
import io.github.vampirestudios.raa.registries.Dimensions;
import io.github.vampirestudios.raa.utils.JsonConverter;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.WorldStructureManipulation;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3298;

public class PortalHubFeature
extends class_3031<class_3111> {
    private JsonConverter converter = new JsonConverter();
    private Map<String, JsonConverter.StructureValues> structures;

    public PortalHubFeature(Function<Dynamic<?>, ? extends class_3111> function) {
        super(function);
    }

    public static void placePiece(class_1936 world, class_2338 pos, JsonConverter.StructureValues piece, int decay) {
        int themeNum = Rands.randInt(PortalHubThemes.PORTAL_HUB_THEMES.method_10235().size());
        PortalHubTheme theme = (PortalHubTheme)PortalHubThemes.PORTAL_HUB_THEMES.method_10200(themeNum);
        assert (theme != null);
        block14: for (int i = 0; i < piece.getBlockPositions().size(); ++i) {
            class_2382 currBlockPos = piece.getBlockPositions().get(i);
            String currBlockType = piece.getBlockTypes().get(piece.getBlockStates().get(i));
            Map<String, String> currBlockProp = piece.getBlockProperties().get(piece.getBlockStates().get(i));
            if (decay > 0 && Rands.chance(14 - decay)) continue;
            switch (currBlockType) {
                case "minecraft:stone_bricks": {
                    WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), class_2378.field_11146.method_10221((Object)theme.getBlock()).toString(), currBlockProp, 0);
                    continue block14;
                }
                case "minecraft:stone_brick_slab": {
                    WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), class_2378.field_11146.method_10221((Object)theme.getSlab()).toString(), currBlockProp, 0);
                    continue block14;
                }
                case "minecraft:stone_brick_stairs": {
                    WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), class_2378.field_11146.method_10221((Object)theme.getStairs()).toString(), currBlockProp, 0);
                    continue block14;
                }
                case "minecraft:stone_brick_wall": {
                    if (themeNum < 14) {
                        WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), class_2378.field_11146.method_10221((Object)theme.getWall()).toString(), currBlockProp, 0);
                        continue block14;
                    }
                    if (themeNum < 16) {
                        WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), class_2378.field_11146.method_10221((Object)theme.getWall()).toString(), new HashMap<String, String>(), 0);
                        continue block14;
                    }
                    currBlockProp.remove("up");
                    WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), class_2378.field_11146.method_10221((Object)theme.getWall()).toString(), currBlockProp, 0);
                    continue block14;
                }
                case "minecraft:orange_wool": {
                    ArrayList dimensionDataList = new ArrayList();
                    Dimensions.DIMENSIONS.forEach(dimensionDataList::add);
                    WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), "raa:" + ((DimensionData)Rands.list(dimensionDataList)).getName().toLowerCase() + "_portal", currBlockProp, 0);
                    continue block14;
                }
                default: {
                    WorldStructureManipulation.placeBlock(world, pos.method_10081(currBlockPos), currBlockType, currBlockProp, 0);
                }
            }
        }
    }

    public boolean generate(class_1936 world, class_2794 chunkGenerator, Random random, class_2338 pos, class_3111 config) {
        JsonObject jsonObject = null;
        try {
            class_3298 path = world.method_8410().method_8503().method_3809().method_14486(new class_2960("raa:structures/portal_hub/portal_hub.json"));
            final JsonObject finalJsonObject = jsonObject = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(path.method_14482()), JsonObject.class);
            this.structures = new HashMap<String, JsonConverter.StructureValues>(){
                {
                    this.put("portal_hub", PortalHubFeature.this.converter.loadStructure(finalJsonObject));
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (jsonObject == null) {
            System.out.println("Can't get the file");
            return true;
        }
        if (!world.method_8597().method_12460().method_12489().equals("")) {
            return true;
        }
        class_2382 tempPos = WorldStructureManipulation.circularSpawnCheck(world, pos, this.structures.get("portal_hub").getSize(), 0.125f);
        if (tempPos.method_10265(class_2382.field_11176) == 0) {
            return true;
        }
        pos = new class_2338(tempPos);
        PortalHubFeature.placePiece(world, pos, this.structures.get("portal_hub"), 0);
        try {
            class_1937 world2 = world.method_8410();
            String path = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? "saves/" + ((class_3218)world2).method_17982().method_132().getName() + "/data/portal_hub_spawns.txt" : world.method_8401().method_150() + "/data/portal_hub_spawns.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(path, true));
            writer.append(pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

