/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.generation.materials;

import io.github.vampirestudios.raa.api.enums.OreType;
import io.github.vampirestudios.raa.api.enums.TextureTypes;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.generation.materials.Material;
import io.github.vampirestudios.raa.generation.materials.data.CustomArmorMaterial;
import io.github.vampirestudios.raa.generation.materials.data.CustomToolMaterial;
import io.github.vampirestudios.raa.generation.materials.data.MaterialFoodData;
import io.github.vampirestudios.raa.generation.materials.data.MaterialTexturesInformation;
import io.github.vampirestudios.raa.generation.materials.data.OreInformation;
import io.github.vampirestudios.raa.utils.Rands;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public class DimensionMaterial
extends Material {
    private transient DimensionData dimensionData;

    DimensionMaterial(OreInformation oreInformation, class_2960 id, String name, MaterialTexturesInformation texturesInformation, int color, int miningLevel, boolean armor, CustomArmorMaterial armorMaterial, boolean tools, boolean weapons, CustomToolMaterial toolMaterial, boolean glowing, boolean oreFlower, boolean food, DimensionData dimensionData, MaterialFoodData foodData, float compostbleAmount, boolean compostable) {
        super(oreInformation, id, name, texturesInformation, color, miningLevel, armor, armorMaterial, tools, weapons, toolMaterial, glowing, oreFlower, food, foodData, compostbleAmount, compostable);
        this.dimensionData = dimensionData;
    }

    public DimensionData getDimensionData() {
        return this.dimensionData;
    }

    public static class Builder {
        private OreType oreType;
        private class_2960 id;
        private String name;
        private int RGB = -1;
        private class_2960 generatesIn;
        private int oreCount = Rands.randInt(19) + 1;
        private CustomArmorMaterial armorMaterial;
        private CustomToolMaterial toolMaterial;
        private MaterialFoodData foodData;
        private boolean armor = false;
        private boolean tools = false;
        private boolean weapons = false;
        private boolean glowing = false;
        private boolean oreFlower = false;
        private boolean food = false;
        private int minXPAmount = 0;
        private int maxXPAmount = 10;
        private int oreClusterSize = 9;
        private int miningLevel = Rands.randInt(4);
        private DimensionData dimensionData;
        private float compostbleAmount;
        private boolean compostable;

        protected Builder() {
        }

        @Deprecated
        public static Builder create() {
            return new Builder();
        }

        public static Builder create(class_2960 id, String name) {
            Builder builder = new Builder();
            builder.id = id;
            builder.name = name;
            return builder;
        }

        public Builder oreCount(int oreCount) {
            this.oreCount = oreCount;
            return this;
        }

        public Builder miningLevel(int miningLevel) {
            this.miningLevel = miningLevel;
            return this;
        }

        public Builder id(class_2960 id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder oreType(OreType oreType) {
            this.oreType = oreType;
            return this;
        }

        public Builder color(int RGB) {
            this.RGB = RGB;
            return this;
        }

        public Builder compostbleAmount(float compostbleAmount) {
            this.compostbleAmount = compostbleAmount;
            return this;
        }

        public Builder compostable(boolean compostable) {
            this.compostable = compostable;
            return this;
        }

        public Builder target(class_2960 target) {
            this.generatesIn = target;
            return this;
        }

        public Builder armor(boolean armor) {
            this.armor = armor;
            return this;
        }

        public Builder armor(CustomArmorMaterial armorMaterial) {
            this.armor = true;
            this.armorMaterial = armorMaterial;
            return this;
        }

        public Builder foodData(MaterialFoodData foodData) {
            this.foodData = foodData;
            return this;
        }

        public Builder tools(boolean tools) {
            this.tools = tools;
            return this;
        }

        public Builder tools(CustomToolMaterial toolMaterial) {
            this.tools = true;
            this.toolMaterial = toolMaterial;
            return this;
        }

        public Builder weapons(boolean weapons) {
            this.weapons = weapons;
            return this;
        }

        public Builder weapons(CustomToolMaterial toolMaterial) {
            this.weapons = true;
            this.toolMaterial = toolMaterial;
            return this;
        }

        public Builder glowing(boolean glowing) {
            this.glowing = glowing;
            return this;
        }

        public Builder oreFlower(boolean oreFlower) {
            this.oreFlower = oreFlower;
            return this;
        }

        public Builder food(boolean food) {
            this.food = food;
            return this;
        }

        public Builder minXPAmount(int minXPAmount) {
            this.minXPAmount = minXPAmount;
            return this;
        }

        public Builder maxXPAmount(int maxXPAmount) {
            this.maxXPAmount = maxXPAmount;
            return this;
        }

        public Builder oreClusterSize(int oreClusterSize) {
            this.oreClusterSize = oreClusterSize;
            return this;
        }

        public Builder dimensionData(DimensionData dimensionData) {
            this.dimensionData = dimensionData;
            return this;
        }

        public DimensionMaterial build() {
            if (this.id == null || this.name == null) {
                throw new IllegalStateException("A Material must not have a null name or identifier");
            }
            if (this.armor && this.armorMaterial == null) {
                this.armorMaterial = CustomArmorMaterial.generate(this.id, this.oreType);
            }
            if ((this.tools || this.weapons) && this.toolMaterial == null) {
                this.toolMaterial = CustomToolMaterial.generate(this.id, this.oreType, this.miningLevel);
            }
            class_2960 overlayTexture = this.oreType == OreType.METAL ? Rands.list(TextureTypes.METAL_ORE_TEXTURES) : (this.oreType == OreType.GEM ? Rands.list(TextureTypes.GEM_ORE_TEXTURES) : Rands.list(TextureTypes.CRYSTAL_ORE_TEXTURES));
            class_2960 storageBlockTexture = this.oreType == OreType.METAL ? Rands.list(TextureTypes.METAL_BLOCK_TEXTURES) : (this.oreType == OreType.GEM ? Rands.list(TextureTypes.GEM_BLOCK_TEXTURES) : Rands.list(TextureTypes.CRYSTAL_BLOCK_TEXTURES));
            class_2960 resourceItemTexture = this.oreType == OreType.METAL ? Rands.list(TextureTypes.INGOT_TEXTURES) : (this.oreType == OreType.GEM ? Rands.list(TextureTypes.GEM_ITEM_TEXTURES) : Rands.list(TextureTypes.CRYSTAL_ITEM_TEXTURES));
            class_2960 nuggetTexture = this.oreType == OreType.METAL ? Rands.list(TextureTypes.METAL_NUGGET_TEXTURES) : null;
            Map.Entry<class_2960, class_2960> pickaxe = Rands.map(TextureTypes.PICKAXES);
            Map.Entry<class_2960, class_2960> axe = Rands.map(TextureTypes.AXES);
            Map.Entry<class_2960, class_2960> hoe = Rands.map(TextureTypes.HOES);
            Map.Entry<class_2960, class_2960> sword = Rands.map(TextureTypes.SWORDS);
            Map.Entry<class_2960, class_2960> shovel = Rands.map(TextureTypes.SHOVELS);
            MaterialTexturesInformation texturesInformation = MaterialTexturesInformation.Builder.create().pickaxeTexture((class_3545<class_2960, class_2960>)new class_3545((Object)pickaxe.getKey(), (Object)pickaxe.getValue())).axeTexture((class_3545<class_2960, class_2960>)new class_3545((Object)axe.getKey(), (Object)axe.getValue())).hoeTexture((class_3545<class_2960, class_2960>)new class_3545((Object)hoe.getKey(), (Object)hoe.getValue())).swordTexture((class_3545<class_2960, class_2960>)new class_3545((Object)sword.getKey(), (Object)sword.getValue())).shovelTexture((class_3545<class_2960, class_2960>)new class_3545((Object)shovel.getKey(), (Object)shovel.getValue())).helmetTexture(Rands.list(TextureTypes.HELMET_TEXTURES)).chestplateTexture(Rands.list(TextureTypes.CHESTPLATE_TEXTURES)).leggingsTexture(Rands.list(TextureTypes.LEGGINGS_TEXTURES)).bootsTexture(Rands.list(TextureTypes.BOOTS_TEXTURES)).overlayTexture(overlayTexture).storageBlockTexture(storageBlockTexture).resourceItemTexture(resourceItemTexture).nuggetTexture(nuggetTexture).fruitTexture(Rands.list(TextureTypes.FRUIT_TEXTURES)).build();
            OreInformation oreInformation = new OreInformation(this.oreType, this.generatesIn, this.oreCount, this.minXPAmount, this.maxXPAmount, this.oreClusterSize);
            return new DimensionMaterial(oreInformation, this.id, this.name, texturesInformation, this.RGB, this.miningLevel, this.armor, this.armorMaterial, this.tools, this.weapons, this.toolMaterial, this.glowing, this.oreFlower, this.food, this.dimensionData, this.foodData, this.compostbleAmount, this.compostable);
        }
    }
}

