/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.history;

import io.github.vampirestudios.raa.history.ProtoDimension;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.Utils;
import net.minecraft.class_2960;

public class Civilization {
    private String name;
    private class_2960 homeDimensionId;
    private ProtoDimension homeDimension;
    private double influenceRadius;
    private int techLevel;
    private String causeOfDeath;

    public Civilization(String name, ProtoDimension homeDimension) {
        this.name = name;
        this.homeDimension = homeDimension;
        this.homeDimensionId = (class_2960)homeDimension.getName().method_15441();
    }

    public void simulate() {
        boolean survived;
        if (Utils.checkBitFlag(this.homeDimension.getFlags(), 2) || Utils.checkBitFlag(this.homeDimension.getFlags(), 32) || Utils.checkBitFlag(this.homeDimension.getFlags(), 64)) {
            survived = false;
            for (int i = 0; i < Rands.randIntRange(3, 5) && !(survived = Rands.chance(6)); ++i) {
            }
            if (!survived) {
                this.influenceRadius = 0.0;
                this.techLevel = 0;
                return;
            }
            this.influenceRadius += (double)Rands.randFloatRange(0.05f, 0.1f);
        }
        if ((double)this.homeDimension.getTemperature() < 0.5 || (double)this.homeDimension.getTemperature() > 1.5) {
            survived = false;
            int rolls = 2;
            if ((double)this.homeDimension.getTemperature() < 0.5) {
                rolls += Math.round(this.homeDimension.getTemperature() * 8.0f);
            }
            if ((double)this.homeDimension.getTemperature() > 1.5) {
                rolls += Math.round(Math.abs(2.0f - this.homeDimension.getTemperature()) * 8.0f);
            }
            for (int i = 0; i < rolls && !(survived = Rands.chance(6)); ++i) {
            }
            if (!survived) {
                this.influenceRadius = 0.0;
                this.techLevel = 0;
                return;
            }
            this.influenceRadius += (double)Rands.randFloatRange((float)rolls / 80.0f, (float)rolls / 80.0f * 2.0f);
        }
        ++this.techLevel;
        this.influenceRadius += (double)Rands.randFloatRange(0.025f, 0.05f);
        float temperatureDeviation = Math.abs(1.0f - this.homeDimension.getTemperature());
        this.influenceRadius += (double)(temperatureDeviation / 4.0f);
        if (Utils.checkBitFlag(this.homeDimension.getFlags(), 8)) {
            this.influenceRadius += (double)Rands.randFloatRange(0.1f, 0.15f);
            ++this.techLevel;
        }
        if ((double)this.homeDimension.getScale() < 0.75) {
            this.influenceRadius += (double)(this.homeDimension.getScale() / 4.0f);
            ++this.techLevel;
        }
        if (Rands.chance(6)) {
            this.influenceRadius += (double)Rands.randFloatRange(0.025f, 0.05f);
            ++this.techLevel;
        }
        if (Rands.chance(6)) {
            this.influenceRadius += (double)Rands.randFloatRange(0.025f, 0.05f);
            ++this.techLevel;
        }
        if (this.techLevel >= 2) {
            this.homeDimension.setAbandoned();
        }
        if (this.techLevel >= 3) {
            this.homeDimension.setCivilized();
        }
        if (this.techLevel == 3 && Rands.chance(6)) {
            this.homeDimension.setDead();
        }
        if (this.techLevel >= 4 && Rands.chance(4)) {
            this.homeDimension.setDead();
        }
    }

    private void finalizeInfluence() {
        if (this.techLevel == 1 && this.influenceRadius > 0.15) {
            this.influenceRadius = 0.15;
        }
        if (this.techLevel == 2 && this.influenceRadius > 0.35) {
            this.influenceRadius = 0.35;
        }
        if (this.techLevel == 3 && this.influenceRadius > 0.55) {
            this.influenceRadius = 0.55;
        }
    }

    public String getName() {
        return this.name;
    }

    public double getInfluenceRadius() {
        return this.influenceRadius;
    }

    public int getTechLevel() {
        return this.techLevel;
    }

    public String getCauseOfDeath() {
        return this.causeOfDeath;
    }

    public class_2960 getHomeDimensionId() {
        return this.homeDimensionId;
    }

    public ProtoDimension getHomeDimension() {
        return this.homeDimension;
    }
}

