/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.registries;

import io.github.vampirestudios.raa.RandomlyAddingAnything;
import io.github.vampirestudios.raa.api.dimension.DimensionChunkGenerators;
import io.github.vampirestudios.raa.api.dimension.PlayerPlacementHandlers;
import io.github.vampirestudios.raa.api.enums.TextureTypes;
import io.github.vampirestudios.raa.api.namegeneration.INameGenerator;
import io.github.vampirestudios.raa.blocks.DimensionalBlock;
import io.github.vampirestudios.raa.blocks.DimensionalStone;
import io.github.vampirestudios.raa.blocks.PortalBlock;
import io.github.vampirestudios.raa.generation.dimensions.CustomDimension;
import io.github.vampirestudios.raa.generation.dimensions.CustomDimensionalBiome;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionBiomeData;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionColorPalette;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionFoliagePlacers;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionTextureData;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionTreeData;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionTreeTypes;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionWoodType;
import io.github.vampirestudios.raa.history.Civilization;
import io.github.vampirestudios.raa.history.ProtoDimension;
import io.github.vampirestudios.raa.items.RAABlockItemAlt;
import io.github.vampirestudios.raa.items.dimension.DimensionalAxeItem;
import io.github.vampirestudios.raa.items.dimension.DimensionalHoeItem;
import io.github.vampirestudios.raa.items.dimension.DimensionalPickaxeItem;
import io.github.vampirestudios.raa.items.dimension.DimensionalShovelItem;
import io.github.vampirestudios.raa.items.dimension.DimensionalSwordItem;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.RegistryUtils;
import io.github.vampirestudios.raa.utils.Utils;
import io.github.vampirestudios.raa.utils.debug.ConsolePrinting;
import io.github.vampirestudios.vampirelib.utils.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensionType;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2386;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4545;
import net.minecraft.class_4547;

public class Dimensions {
    public static final Set<class_2960> DIMENSION_NAMES = new HashSet<class_2960>();
    public static final class_2378<DimensionData> DIMENSIONS = new class_2348("raa:dimensions");

    public static void generate() {
        ArrayList<ProtoDimension> protoDimensions = new ArrayList<ProtoDimension>();
        for (int a = 0; a < RandomlyAddingAnything.CONFIG.dimensionsGenAmount; ++a) {
            float temperature = Rands.randFloat(2.0f);
            int flags = Dimensions.generateDimensionFlags();
            INameGenerator nameGenerator = RandomlyAddingAnything.CONFIG.namingLanguage.getDimensionNameGenerator();
            class_3545<String, class_2960> name = nameGenerator.generateUnique(DIMENSION_NAMES, "raa");
            DIMENSION_NAMES.add((class_2960)name.method_15441());
            protoDimensions.add(new ProtoDimension(name, flags, temperature, Rands.randFloat(2.0f)));
        }
        for (ProtoDimension dimension : protoDimensions) {
            dimension.setXandY(Rands.randFloatRange(0.0f, 1.0f), Rands.randFloatRange(0.0f, 1.0f));
        }
        ArrayList<Civilization> civs = new ArrayList<Civilization>();
        HashSet<class_2960> civNames = new HashSet<class_2960>();
        HashSet<ProtoDimension> usedDimensions = new HashSet<ProtoDimension>();
        for (int i = 0; i < 10; ++i) {
            INameGenerator nameGenerator = RandomlyAddingAnything.CONFIG.namingLanguage.getDimensionNameGenerator();
            class_3545<String, class_2960> name = nameGenerator.generateUnique(civNames, "raa");
            civNames.add((class_2960)name.method_15441());
            ProtoDimension generatedDimension = (ProtoDimension)Rands.list(protoDimensions);
            if (usedDimensions.contains(generatedDimension)) continue;
            usedDimensions.add(generatedDimension);
            civs.add(new Civilization((String)name.method_15442(), generatedDimension));
        }
        civs.forEach(Civilization::simulate);
        for (Civilization civ : civs) {
            if (civ.getTechLevel() == 0) continue;
            for (ProtoDimension dimension : protoDimensions) {
                if (dimension != civ.getHomeDimension()) {
                    double d = Utils.dist(dimension.getX(), dimension.getY(), civ.getHomeDimension().getX(), civ.getHomeDimension().getY());
                    if (d <= civ.getInfluenceRadius()) {
                        double percent = (civ.getInfluenceRadius() - d) / civ.getInfluenceRadius();
                        dimension.addInfluence(civ.getName(), percent);
                        if (percent > 0.4 && civ.getTechLevel() >= 2 && Rands.chance(5)) {
                            dimension.setAbandoned();
                        }
                        if (percent > 0.6) {
                            if (civ.getTechLevel() >= 2 && Rands.chance(4)) {
                                dimension.setAbandoned();
                            }
                            if (civ.getTechLevel() >= 3 && Rands.chance(5)) {
                                dimension.setDead();
                            }
                        }
                        if (percent > 0.8) {
                            if (civ.getTechLevel() >= 2 && Rands.chance(3)) {
                                dimension.setAbandoned();
                            }
                            if (civ.getTechLevel() >= 3 && Rands.chance(4)) {
                                dimension.setDead();
                            }
                        }
                        if (percent > 0.7 && civ.getTechLevel() >= 3) {
                            dimension.setCivilized();
                        }
                    }
                } else {
                    dimension.addInfluence(civ.getName(), 1.0);
                }
                if (!Utils.checkBitFlag(dimension.getFlags(), 2) || !Utils.checkBitFlag(dimension.getFlags(), 8)) continue;
                dimension.removeLush();
            }
        }
        for (ProtoDimension dimension : protoDimensions) {
            float scale;
            int difficulty = 0;
            int flags = dimension.getFlags();
            class_3545<String, class_2960> name = dimension.getName();
            float hue = Rands.randFloatRange(0.0f, 1.0f);
            float foliageColor = hue + Rands.randFloatRange(-0.15f, 0.15f);
            float stoneColor = hue + Rands.randFloatRange(-0.45f, 0.45f);
            float fogHue = hue + 0.3333f;
            float skyHue = fogHue + 0.3333f;
            float saturation = Rands.randFloatRange(0.5f, 1.0f);
            float stoneSaturation = Rands.randFloatRange(0.2f, 0.6f);
            if (Utils.checkBitFlag(flags, 2)) {
                stoneSaturation = saturation = Rands.randFloatRange(0.0f, 0.2f);
                difficulty += 2;
                if (Utils.checkBitFlag(flags, 16)) {
                    ++difficulty;
                }
            }
            if (Utils.checkBitFlag(flags, 8)) {
                saturation = Rands.randFloatRange(0.7f, 1.0f);
            }
            if (Utils.checkBitFlag(flags, 1)) {
                difficulty += 2;
            }
            if (Utils.checkBitFlag(flags, 32)) {
                difficulty += 2;
            }
            if (Utils.checkBitFlag(flags, 64)) {
                difficulty += 2;
            }
            if (Utils.checkBitFlag(flags, 128)) {
                ++difficulty;
            }
            float value = Rands.randFloatRange(0.5f, 1.0f);
            Color GRASS_COLOR = new Color(Color.HSBtoRGB((float)hue, (float)saturation, (float)value));
            Color FOLIAGE_COLOR = new Color(Color.HSBtoRGB((float)foliageColor, (float)saturation, (float)value));
            Color FOG_COLOR = new Color(Color.HSBtoRGB((float)fogHue, (float)saturation, (float)value));
            Color SKY_COLOR = new Color(Color.HSBtoRGB((float)skyHue, (float)saturation, (float)value));
            Color WATER_COLOR = new Color(Color.HSBtoRGB((float)Rands.randFloatRange(0.0f, 1.0f), (float)saturation, (float)Rands.randFloatRange(0.5f, 1.0f)));
            Color STONE_COLOR = new Color(Color.HSBtoRGB((float)stoneColor, (float)stoneSaturation, (float)value));
            DimensionChunkGenerators gen = Utils.randomCG(Rands.randIntRange(0, 100));
            if (gen == DimensionChunkGenerators.FLOATING) {
                ++difficulty;
            }
            if (gen == DimensionChunkGenerators.CAVE) {
                difficulty += 2;
            }
            if ((double)(scale = dimension.getScale()) > 0.8) {
                ++difficulty;
            }
            if ((double)scale > 1.6) {
                ++difficulty;
            }
            class_3545<Integer, HashMap<String, int[]>> difficultyAndMobs = Dimensions.generateDimensionMobs(flags, difficulty);
            DimensionData.Builder builder = DimensionData.Builder.create((class_2960)name.method_15441(), (String)name.method_15442()).hasSkyLight(Rands.chance(1)).hasSky(!Rands.chance(2)).canSleep(Rands.chance(10)).waterVaporize(Rands.chance(100)).shouldRenderFog(Rands.chance(40)).chunkGenerator(gen).flags(flags).difficulty((Integer)difficultyAndMobs.method_15442()).mobs((HashMap)difficultyAndMobs.method_15441()).civilizationInfluences(dimension.getCivilizationInfluences()).stoneHardness(Rands.randFloatRange(0.2f, 5.0f), Rands.randFloatRange(3.0f, 18.0f)).surfaceBuilder(Rands.randInt(100));
            DimensionTextureData texturesInformation = DimensionTextureData.Builder.create().stoneTexture(Rands.list(TextureTypes.STONE_TEXTURES)).stoneBricksTexture(Rands.list(TextureTypes.STONE_BRICKS_TEXTURES)).mossyStoneBricksTexture(Rands.list(TextureTypes.MOSSY_STONE_BRICKS_TEXTURES)).crackedStoneBricksTexture(Rands.list(TextureTypes.CRACKED_STONE_BRICKS_TEXTURES)).cobblestoneTexture(Rands.list(TextureTypes.COBBLESTONE_TEXTURES)).mossyCobblestoneTexture(Rands.list(TextureTypes.MOSSY_COBBLESTONE_TEXTURES)).chiseledTexture(Rands.list(TextureTypes.CHISELED_STONE_TEXTURES)).mossyChiseledTexture(Rands.list(TextureTypes.MOSSY_CHISELED_STONE_TEXTURES)).crackedChiseledTexture(Rands.list(TextureTypes.CRACKED_CHISELED_STONE_TEXTURES)).polishedTexture(Rands.list(TextureTypes.POLISHED_STONE_TEXTURES)).iceTexture(TextureTypes.ICE_TEXTURES.get(0)).build();
            builder.texturesInformation(texturesInformation);
            for (int i = 0; i < Rands.randIntRange(1, 12); ++i) {
                float grassColor = hue + Rands.randFloatRange(-0.25f, 0.25f);
                ArrayList<DimensionTreeData> treeDataList = new ArrayList<DimensionTreeData>();
                int treeAmount = Rands.randIntRange(1, 5);
                if (Utils.checkBitFlag(flags, 8)) {
                    treeAmount = 8;
                }
                for (int j = 0; j < treeAmount; ++j) {
                    DimensionTreeData treeData = DimensionTreeData.Builder.create().woodType(Rands.list(Arrays.asList(DimensionWoodType.values()))).foliagePlacerType(Rands.list(Arrays.asList(DimensionFoliagePlacers.values()))).treeType(Rands.list(Arrays.asList(DimensionTreeTypes.values()))).baseHeight(Rands.randIntRange(2, 24)).maxWaterDepth(Rands.randIntRange(0, 8)).foliageHeight(Rands.randIntRange(1, 5)).chance(Rands.randFloatRange(0.05f, 0.6f)).hasCocoaBeans(Rands.chance(3)).hasLeafVines(Rands.chance(3)).hasPodzolUnderneath(Rands.chance(3)).hasTrunkVines(Rands.chance(3)).build();
                    treeDataList.add(treeData);
                }
                DimensionBiomeData biomeData = DimensionBiomeData.Builder.create(Utils.appendToPath((class_2960)name.method_15441(), "_biome_" + i), (String)name.method_15442()).surfaceBuilderVariantChance(Rands.randInt(100)).depth(Rands.randFloatRange(-2.0f, 5.0f)).scale(scale + Rands.randFloatRange(-0.75f, 0.75f)).temperature(dimension.getTemperature() + Rands.randFloatRange(-0.5f, 0.5f)).downfall(Rands.randFloat(1.0f)).waterColor(WATER_COLOR.getColor()).grassColor(new Color(Color.HSBtoRGB((float)grassColor, (float)saturation, (float)value)).getColor()).foliageColor(new Color(Color.HSBtoRGB((float)(grassColor + Rands.randFloatRange(-0.1f, 0.1f)), (float)saturation, (float)value)).getColor()).treeData(treeDataList).largeSkeletonTreeChance(Rands.randFloatRange(0.0f, 0.5f)).spawnsCratersInNonCorrupted(Rands.chance(4)).campfireChance(Rands.randFloatRange(0.003f, 0.005f)).outpostChance(Rands.randFloatRange(0.001f, 0.003f)).towerChance(Rands.randFloatRange(0.001f, 0.0015f)).hasMushrooms(Rands.chance(6)).hasMossyRocks(Rands.chance(8)).build();
                builder.biome(biomeData);
            }
            DimensionColorPalette colorPalette = DimensionColorPalette.Builder.create().skyColor(SKY_COLOR.getColor()).grassColor(GRASS_COLOR.getColor()).fogColor(FOG_COLOR.getColor()).foliageColor(FOLIAGE_COLOR.getColor()).stoneColor(STONE_COLOR.getColor()).build();
            builder.colorPalette(colorPalette);
            DimensionData dimensionData = builder.build();
            class_2378.method_10230(DIMENSIONS, (class_2960)dimensionData.getId(), (Object)dimensionData);
            if (!RandomlyAddingAnything.CONFIG.debug) continue;
            ConsolePrinting.dimensionDebug(dimensionData);
        }
    }

    public static void createDimensions() {
        DIMENSIONS.forEach(dimension -> {
            class_2960 identifier = dimension.getId();
            class_2248 stoneBlock = RegistryUtils.register((class_2248)new DimensionalStone((DimensionData)dimension), Utils.appendToPath(identifier, "_stone"), RandomlyAddingAnything.RAA_DIMENSION_BLOCKS, dimension.getName(), "stone");
            LinkedHashSet<CustomDimensionalBiome> biomes = new LinkedHashSet<CustomDimensionalBiome>();
            for (int i = 0; i < dimension.getBiomeData().size(); ++i) {
                CustomDimensionalBiome biome = new CustomDimensionalBiome((DimensionData)dimension, dimension.getBiomeData().get(i));
                RegistryUtils.registerBiome(dimension.getBiomeData().get(i).getId(), biome);
                biomes.add(biome);
            }
            FabricDimensionType.Builder typee = FabricDimensionType.builder().biomeAccessStrategy((class_4545)class_4547.field_20646).skyLight(dimension.hasSkyLight()).factory((world, dimensionType) -> new CustomDimension((class_1937)world, (class_2874)dimensionType, (DimensionData)dimension, (Set<class_1959>)biomes, Rands.chance(50) ? class_2246.field_10340 : stoneBlock));
            if (dimension.getDimensionChunkGenerator() == DimensionChunkGenerators.CAVE || dimension.getDimensionChunkGenerator() == DimensionChunkGenerators.FLAT_CAVES || dimension.getDimensionChunkGenerator() == DimensionChunkGenerators.HIGH_CAVES) {
                typee.defaultPlacer(PlayerPlacementHandlers.CAVE_WORLD.getEntityPlacer());
            } else if (dimension.getDimensionChunkGenerator() == DimensionChunkGenerators.FLOATING || dimension.getDimensionChunkGenerator() == DimensionChunkGenerators.LAYERED_FLOATING || dimension.getDimensionChunkGenerator() == DimensionChunkGenerators.PRE_CLASSIC_FLOATING) {
                typee.defaultPlacer(PlayerPlacementHandlers.FLOATING_WORLD.getEntityPlacer());
            } else {
                typee.defaultPlacer(PlayerPlacementHandlers.SURFACE_WORLD.getEntityPlacer());
            }
            FabricDimensionType type = typee.buildAndRegister(dimension.getId());
            class_2874 dimensionType2 = class_2378.field_11155.method_10223(dimension.getId()) == null ? (class_2874)class_2378.method_10230((class_2378)class_2378.field_11155, (class_2960)dimension.getId(), (Object)type) : (class_2874)class_2378.field_11155.method_10223(dimension.getId());
            class_1832 toolMaterial = new class_1832((DimensionData)dimension, identifier){
                final /* synthetic */ DimensionData val$dimension;
                final /* synthetic */ class_2960 val$identifier;
                {
                    this.val$dimension = dimensionData;
                    this.val$identifier = class_29602;
                }

                public int method_8025() {
                    return (int)((float)class_1834.field_8927.method_8025() * this.val$dimension.getStoneHardness() / 2.0f);
                }

                public float method_8027() {
                    return class_1834.field_8927.method_8027() * this.val$dimension.getStoneHardness() / 2.0f;
                }

                public float method_8028() {
                    return class_1834.field_8927.method_8028() * this.val$dimension.getStoneHardness() / 4.0f;
                }

                public int method_8024() {
                    return class_1834.field_8927.method_8024();
                }

                public int method_8026() {
                    return (int)((float)class_1834.field_8927.method_8026() * this.val$dimension.getStoneHardness() / 4.0f);
                }

                public class_1856 method_8023() {
                    return class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)class_2378.field_11142.method_10223(Utils.appendToPath(this.val$identifier, "_cobblestone"))});
                }
            };
            RegistryUtils.registerItem((class_1792)new DimensionalPickaxeItem((DimensionData)dimension, toolMaterial, 1, -2.8f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)class_2378.field_11142.method_10223(Utils.appendToPath(identifier, "_cobblestone")))), Utils.appendToPath(identifier, "_pickaxe"));
            RegistryUtils.registerItem((class_1792)new DimensionalAxeItem((DimensionData)dimension, toolMaterial, 7.0f, -3.2f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)class_2378.field_11142.method_10223(Utils.appendToPath(identifier, "_cobblestone")))), Utils.appendToPath(identifier, "_axe"));
            RegistryUtils.registerItem((class_1792)new DimensionalShovelItem((DimensionData)dimension, toolMaterial, 1.5f, -3.0f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)class_2378.field_11142.method_10223(Utils.appendToPath(identifier, "_cobblestone")))), Utils.appendToPath(identifier, "_shovel"));
            RegistryUtils.registerItem((class_1792)new DimensionalHoeItem((DimensionData)dimension, toolMaterial, -2.0f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)class_2378.field_11142.method_10223(Utils.appendToPath(identifier, "_cobblestone")))), Utils.appendToPath(identifier, "_hoe"));
            RegistryUtils.registerItem((class_1792)new DimensionalSwordItem(toolMaterial, (DimensionData)dimension, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_WEAPONS).method_7896((class_1792)class_2378.field_11142.method_10223(Utils.appendToPath(identifier, "_cobblestone")))), Utils.appendToPath(identifier, "_sword"));
            RegistryUtils.register((class_2248)new DimensionalBlock(), Utils.appendToPath(dimension.getId(), "_stone"), RandomlyAddingAnything.RAA_DIMENSION_BLOCKS, dimension.getName(), "stoneBricks");
            RegistryUtils.register((class_2248)new DimensionalBlock(), Utils.appendToPath(dimension.getId(), "_cobblestone"), RandomlyAddingAnything.RAA_DIMENSION_BLOCKS, dimension.getName(), "cobblestone");
            RegistryUtils.register((class_2248)new DimensionalBlock(), Utils.prependToPath(dimension.getId(), "chiseled_"), RandomlyAddingAnything.RAA_DIMENSION_BLOCKS, dimension.getName(), "chiseled");
            RegistryUtils.register((class_2248)new DimensionalBlock(), Utils.prependToPath(dimension.getId(), "polished_"), RandomlyAddingAnything.RAA_DIMENSION_BLOCKS, dimension.getName(), "polished");
            RegistryUtils.register((class_2248)new class_2386(class_2248.class_2251.method_9630((class_2248)class_2246.field_10295)), Utils.appendToPath(dimension.getId(), "_ice"), RandomlyAddingAnything.RAA_DIMENSION_BLOCKS, dimension.getName(), "ice");
            class_2248 portalBlock = RegistryUtils.registerBlockWithoutItem(new PortalBlock(dimensionType2), Utils.appendToPath(dimension.getId(), "_portal"));
            RegistryUtils.registerItem((class_1792)new RAABlockItemAlt(dimension.getName(), "portal", portalBlock, new class_1792.class_1793().method_7892(class_1761.field_7923)), Utils.appendToPath(dimension.getId(), "_portal"));
        });
    }

    public static class_3545<Integer, HashMap<String, int[]>> generateDimensionMobs(int flags, int difficulty) {
        HashMap<String, int[]> list = new HashMap<String, int[]>();
        if (Utils.checkBitFlag(flags, 8)) {
            String[] names;
            for (String name : names = new String[]{"cow", "pig", "chicken", "horse", "donkey", "sheep", "llama"}) {
                int spawnSize = Rands.randIntRange(4, 16);
                list.put(name, new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 8)});
            }
        } else if (!Utils.checkBitFlag(flags, 2)) {
            int spawnSize;
            if (Rands.chance(2)) {
                spawnSize = Rands.randIntRange(2, 12);
                list.put("cow", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
            } else {
                ++difficulty;
            }
            if (Rands.chance(2)) {
                spawnSize = Rands.randIntRange(2, 12);
                list.put("pig", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
            } else {
                ++difficulty;
            }
            if (Rands.chance(2)) {
                spawnSize = Rands.randIntRange(2, 12);
                list.put("chicken", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
            } else {
                ++difficulty;
            }
            if (Rands.chance(2)) {
                spawnSize = Rands.randIntRange(2, 8);
                list.put("horse", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
            }
            if (Rands.chance(2)) {
                spawnSize = Rands.randIntRange(2, 8);
                list.put("donkey", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
            }
            if (Rands.chance(2)) {
                spawnSize = Rands.randIntRange(2, 12);
                list.put("sheep", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
            } else {
                ++difficulty;
            }
            if (Rands.chance(2)) {
                spawnSize = Rands.randIntRange(2, 8);
                list.put("llama", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
            }
        } else {
            difficulty += 4;
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 12);
            list.put("bat", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 8);
            list.put("spider", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
        } else {
            --difficulty;
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 12);
            list.put("zombie", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
        } else {
            --difficulty;
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 4);
            list.put("zombie_villager", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + 1});
        } else {
            --difficulty;
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 12);
            list.put("skeleton", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
        } else {
            --difficulty;
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 8);
            list.put("creeper", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
        } else {
            difficulty -= 2;
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 4);
            list.put("slime", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize + Rands.randIntRange(2, 4)});
        } else {
            --difficulty;
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 4);
            list.put("enderman", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize});
        } else {
            difficulty -= 2;
        }
        if (Rands.chance(2)) {
            int spawnSize = Rands.randIntRange(2, 3);
            list.put("witch", new int[]{Rands.randIntRange(1, 300), spawnSize, spawnSize});
        } else {
            difficulty -= 2;
        }
        return new class_3545((Object)difficulty, list);
    }

    public static int generateDimensionFlags() {
        int flags = 0;
        if (Rands.chance(35)) {
            flags = 199;
            return flags;
        }
        if (Rands.chance(20)) {
            flags |= 1;
            if (Rands.chance(8)) {
                flags |= 2;
            }
            if (Rands.chance(3)) {
                flags |= 0x20;
            }
            if (Rands.chance(4)) {
                flags |= 0x40;
            }
        } else if (Rands.chance(18)) {
            flags |= 2;
            if (Rands.chance(6)) {
                flags |= 0x20;
            }
            if (Rands.chance(5)) {
                flags |= 0x40;
            }
        } else if (Rands.chance(4)) {
            flags |= 8;
        }
        if (Rands.chance(10)) {
            flags |= 0x80;
        }
        boolean chance = Rands.chance(10);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            chance = true;
        }
        if (chance) {
            flags |= 0x100;
        }
        return flags;
    }
}

