/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.registries;

import com.google.common.collect.ImmutableSet;
import io.github.vampirestudios.raa.commands.CommandLocateRAAStructure;
import io.github.vampirestudios.raa.generation.carvers.CaveCarver;
import io.github.vampirestudios.raa.generation.carvers.RavineCarver;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.generation.feature.BeeNestFeature;
import io.github.vampirestudios.raa.generation.feature.CampfireFeature;
import io.github.vampirestudios.raa.generation.feature.CaveCampfireFeature;
import io.github.vampirestudios.raa.generation.feature.CraterFeature;
import io.github.vampirestudios.raa.generation.feature.FossilFeature;
import io.github.vampirestudios.raa.generation.feature.LargeSkeletalTreeFeature;
import io.github.vampirestudios.raa.generation.feature.MushRuinFeature;
import io.github.vampirestudios.raa.generation.feature.NetherrackFeature;
import io.github.vampirestudios.raa.generation.feature.OutpostFeature;
import io.github.vampirestudios.raa.generation.feature.ShrineFeature;
import io.github.vampirestudios.raa.generation.feature.SmallSkeletalTreeFeature;
import io.github.vampirestudios.raa.generation.feature.SpiderLairFeature;
import io.github.vampirestudios.raa.generation.feature.TowerFeature;
import io.github.vampirestudios.raa.generation.feature.UndegroundBeeHiveFeature;
import io.github.vampirestudios.raa.generation.feature.config.CorruptedFeatureConfig;
import io.github.vampirestudios.raa.generation.feature.portalHub.PortalHubFeature;
import io.github.vampirestudios.raa.generation.feature.tree.BentTreeFeature;
import io.github.vampirestudios.raa.generation.feature.tree.DoubleTreeFeature;
import io.github.vampirestudios.raa.generation.feature.tree.FixedTreeFeature;
import io.github.vampirestudios.raa.utils.Utils;
import java.util.Set;
import net.fabricmc.fabric.api.registry.CommandRegistry;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2920;
import net.minecraft.class_2939;
import net.minecraft.class_2960;
import net.minecraft.class_2997;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3133;
import net.minecraft.class_3195;
import net.minecraft.class_3284;
import net.minecraft.class_3612;
import net.minecraft.class_3773;
import net.minecraft.class_4640;
import net.minecraft.class_4642;
import net.minecraft.class_4643;

public class Features {
    public static NetherrackFeature CORRUPTED_NETHRRACK;
    public static CraterFeature CRATER_FEATURE;
    public static OutpostFeature OUTPOST;
    public static CampfireFeature CAMPFIRE;
    public static SmallSkeletalTreeFeature SMALL_SKELETON_TREE;
    public static LargeSkeletalTreeFeature LARGE_SKELETON_TREE;
    public static SpiderLairFeature SPIDER_LAIR;
    public static FixedTreeFeature FIXED_TREE;
    public static BentTreeFeature BENT_TREE;
    public static DoubleTreeFeature DOUBLE_TREE;
    public static TowerFeature TOWER;
    public static FossilFeature FOSSIL;
    public static PortalHubFeature PORTAL_HUB;
    public static ShrineFeature SHRINE;
    public static BeeNestFeature BEE_NEST;
    public static CaveCampfireFeature CAVE_CAMPFIRE;
    public static MushRuinFeature MUSHROOM_RUIN;
    public static UndegroundBeeHiveFeature UNDERGROUND_BEE_HIVE;

    public static void init() {
        CommandRegistry.INSTANCE.register(false, CommandLocateRAAStructure::register);
        CORRUPTED_NETHRRACK = Features.register("corrupted_netherrack", new NetherrackFeature(class_3111::method_13565));
        CRATER_FEATURE = Features.register("crater_feature", new CraterFeature(CorruptedFeatureConfig::deserialize));
        OUTPOST = Features.register("outpost", new OutpostFeature(class_3111::method_13565));
        CAMPFIRE = Features.register("campfire", new CampfireFeature(class_3111::method_13565));
        TOWER = Features.register("tower", new TowerFeature(class_3111::method_13565));
        FOSSIL = Features.register("fossil", new FossilFeature(class_3111::method_13565));
        SHRINE = Features.register("shrine", new ShrineFeature(class_3111::method_13565));
        SMALL_SKELETON_TREE = Features.register("skeleton_tree_small", new SmallSkeletalTreeFeature(class_4643::method_23444));
        LARGE_SKELETON_TREE = Features.register("skeleton_tree_large", new LargeSkeletalTreeFeature(class_4643::method_23444));
        SPIDER_LAIR = Features.register("spider_lair", new SpiderLairFeature(class_3111::method_13565));
        FIXED_TREE = Features.register("fixed_tree", new FixedTreeFeature(class_4640::method_23426));
        BENT_TREE = Features.register("bent_tree", new BentTreeFeature(class_4640::method_23426));
        DOUBLE_TREE = Features.register("double_tree", new DoubleTreeFeature(class_4640::method_23426));
        PORTAL_HUB = Features.register("portal_hub", new PortalHubFeature(class_3111::method_13565));
        BEE_NEST = Features.register("bee_nest", new BeeNestFeature(class_3111::method_13565));
        CAVE_CAMPFIRE = Features.register("cave_campfire", new CaveCampfireFeature(class_3111::method_13565));
        MUSHROOM_RUIN = Features.register("mushroom_ruin", new MushRuinFeature(class_3111::method_13565));
        UNDERGROUND_BEE_HIVE = Features.register("underground_bee_hive", new UndegroundBeeHiveFeature(class_3111::method_13565));
    }

    public static void addDefaultCarvers(class_1959 biome, DimensionData dimensionData) {
        if (Utils.checkBitFlag(dimensionData.getFlags(), 128)) {
            CaveCarver caveCarver = Features.registerCarver("cave_carver", new CaveCarver(dimensionData));
            biome.method_8691(class_2893.class_2894.field_13169, class_1959.method_8714((class_2939)caveCarver, (class_2920)new class_3133(1.0f)));
            RavineCarver ravineCarver = Features.registerCarver("ravine_carver", new RavineCarver(dimensionData));
            biome.method_8691(class_2893.class_2894.field_13169, class_1959.method_8714((class_2939)ravineCarver, (class_2920)new class_3133(1.0f)));
        } else {
            CaveCarver caveCarver = Features.registerCarver("cave_carver", new CaveCarver(dimensionData));
            biome.method_8691(class_2893.class_2894.field_13169, class_1959.method_8714((class_2939)caveCarver, (class_2920)new class_3133(0.14285715f)));
            RavineCarver ravineCarver = Features.registerCarver("ravine_carver", new RavineCarver(dimensionData));
            biome.method_8691(class_2893.class_2894.field_13169, class_1959.method_8714((class_2939)ravineCarver, (class_2920)new class_3133(0.02f)));
        }
    }

    public static void addDefaultSprings(class_1959 biome, DimensionData data) {
        biome.method_8719(class_2893.class_2895.field_13178, class_3031.field_13513.method_23397((class_3037)new class_4642(class_3612.field_15910.method_15785(), true, 4, 1, (Set)ImmutableSet.of((Object)class_2378.field_11146.method_10223(Utils.appendToPath(data.getId(), "_stone"))))).method_23388(class_3284.field_14255.method_23475((class_2998)new class_2997(50, 8, 8, 256))));
        biome.method_8719(class_2893.class_2895.field_13178, class_3031.field_13513.method_23397((class_3037)new class_4642(class_3612.field_15908.method_15785(), true, 4, 1, (Set)ImmutableSet.of((Object)class_2378.field_11146.method_10223(Utils.appendToPath(data.getId(), "_stone"))))).method_23388(class_3284.field_14266.method_23475((class_2998)new class_2997(20, 8, 16, 256))));
    }

    public static <C extends class_3037, F extends class_3031<C>> F register(String name, F feature) {
        if (class_2378.field_11138.method_10223(new class_2960("raa", name)) == null) {
            return (F)((class_3031)class_2378.method_10230((class_2378)class_2378.field_11138, (class_2960)new class_2960("raa", name), feature));
        }
        return feature;
    }

    public static <F extends class_3195<?>> F registerStructure(String name, F structureFeature) {
        if (class_2378.field_16644.method_10223(new class_2960("raa", name)) == null) {
            return (F)((class_3195)class_2378.method_10230((class_2378)class_2378.field_16644, (class_2960)new class_2960("raa", name), structureFeature));
        }
        return structureFeature;
    }

    public static <F extends class_3773> F registerStructurePiece(String name, F structurePieceType) {
        if (class_2378.field_16645.method_10223(new class_2960("raa", name)) == null) {
            return (F)((class_3773)class_2378.method_10230((class_2378)class_2378.field_16645, (class_2960)new class_2960("raa", name), structurePieceType));
        }
        return structurePieceType;
    }

    public static <F extends class_2920, C extends class_2939<F>> C registerCarver(String name, C carver) {
        if (class_2378.field_11157.method_10223(new class_2960("raa", name)) == null) {
            return (C)((class_2939)class_2378.method_10230((class_2378)class_2378.field_11157, (class_2960)new class_2960("raa", name), carver));
        }
        return carver;
    }
}

