/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.registries;

import io.github.vampirestudios.raa.RandomlyAddingAnything;
import io.github.vampirestudios.raa.api.RAARegisteries;
import io.github.vampirestudios.raa.api.enums.OreType;
import io.github.vampirestudios.raa.api.namegeneration.INameGenerator;
import io.github.vampirestudios.raa.blocks.LayeredOreBlock;
import io.github.vampirestudios.raa.blocks.RAABlock;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.generation.materials.DimensionMaterial;
import io.github.vampirestudios.raa.generation.materials.Material;
import io.github.vampirestudios.raa.generation.materials.data.MaterialFoodData;
import io.github.vampirestudios.raa.items.RAAArmorItem;
import io.github.vampirestudios.raa.items.RAABlockItem;
import io.github.vampirestudios.raa.items.RAADebugItem;
import io.github.vampirestudios.raa.items.RAAFoodItem;
import io.github.vampirestudios.raa.items.RAAHorseArmorItem;
import io.github.vampirestudios.raa.items.RAAShearItem;
import io.github.vampirestudios.raa.items.RAASimpleItem;
import io.github.vampirestudios.raa.items.material.RAAAxeItem;
import io.github.vampirestudios.raa.items.material.RAAHoeItem;
import io.github.vampirestudios.raa.items.material.RAAPickaxeItem;
import io.github.vampirestudios.raa.items.material.RAAShovelItem;
import io.github.vampirestudios.raa.items.material.RAASwordItem;
import io.github.vampirestudios.raa.registries.CustomTargets;
import io.github.vampirestudios.raa.registries.Dimensions;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.RegistryUtils;
import io.github.vampirestudios.raa.utils.Utils;
import io.github.vampirestudios.raa.utils.debug.ConsolePrinting;
import io.github.vampirestudios.raa.world.gen.feature.OreFeatureConfig;
import io.github.vampirestudios.vampirelib.utils.Color;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.tools.FabricToolTags;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2717;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_4174;

public class Materials {
    public static final Set<class_2960> MATERIAL_IDS = new HashSet<class_2960>();
    public static final class_2378<Material> MATERIALS = new class_2348("materials");
    public static final Set<class_2960> DIMENSION_MATERIAL_IDS = new HashSet<class_2960>();
    public static final class_2378<DimensionMaterial> DIMENSION_MATERIALS = new class_2348("dimension_materials");
    public static final int[] BASE_DURABILITY = new int[]{13, 15, 16, 11};
    public static boolean ready = false;
    public static boolean dimensionReady = false;

    public static void generate() {
        for (int a = 0; a < RandomlyAddingAnything.CONFIG.materialGenAmount; ++a) {
            String name;
            class_2960 id;
            Color RGB = Rands.randColor();
            Random random = Rands.getRandom();
            INameGenerator nameGenerator = RandomlyAddingAnything.CONFIG.namingLanguage.getMaterialNameGenerator();
            while (MATERIAL_IDS.contains(id = new class_2960("raa", nameGenerator.asId(name = nameGenerator.generate())))) {
            }
            MATERIAL_IDS.add(id);
            MaterialFoodData materialFoodData = MaterialFoodData.Builder.create().alwaysEdible(Rands.chance(10)).hunger(Rands.randIntRange(4, 30)).meat(Rands.chance(5)).saturationModifier(Rands.randFloatRange(1.0f, 4.0f)).snack(Rands.chance(10)).build();
            Material material = Material.Builder.create(id, name).oreType(Rands.values(OreType.values())).color(RGB.getColor()).foodData(materialFoodData).target(((OreFeatureConfig.Target)Objects.requireNonNull(RAARegisteries.TARGET_REGISTRY.method_10240(Rands.getRandom()))).getId()).armor(Rands.chance(2)).tools(!Rands.chance(3)).oreFlower(Rands.chance(4)).weapons(!Rands.chance(3)).glowing(Rands.chance(4)).minXPAmount(0).maxXPAmount(Rands.randIntRange(0, 4)).oreClusterSize(Rands.randIntRange(2, 9)).food(Rands.chance(4)).compostbleAmount(Rands.randFloatRange(0.1f, 1.0f)).compostable(Rands.chance(10)).build();
            class_2378.method_10230(MATERIALS, (class_2960)id, (Object)material);
            if (!RandomlyAddingAnything.CONFIG.debug) continue;
            ConsolePrinting.materialDebug(material, RGB);
        }
        ready = true;
    }

    public static void generateDimensionMaterials() {
        for (DimensionData dimensionData : Dimensions.DIMENSIONS) {
            for (int a = 0; a < Rands.randIntRange(0, RandomlyAddingAnything.CONFIG.dimensionalMaterialGenAmount); ++a) {
                String name;
                class_2960 id;
                Color RGB = Rands.randColor();
                Random random = Rands.getRandom();
                INameGenerator nameGenerator = RandomlyAddingAnything.CONFIG.namingLanguage.getMaterialNameGenerator();
                do {
                    name = dimensionData.getName() + " " + nameGenerator.generate();
                } while (DIMENSION_MATERIAL_IDS.contains(id = new class_2960("raa", nameGenerator.asId(dimensionData.getName() + "_" + nameGenerator.generate()))));
                DIMENSION_MATERIAL_IDS.add(id);
                MaterialFoodData materialFoodData = MaterialFoodData.Builder.create().alwaysEdible(Rands.chance(10)).hunger(Rands.randIntRange(4, 30)).meat(Rands.chance(5)).saturationModifier(Rands.randFloatRange(1.0f, 4.0f)).snack(Rands.chance(10)).build();
                class_2960 stoneName = Utils.appendToPath(dimensionData.getId(), "_stone");
                class_2248 block = (class_2248)class_2378.field_11146.method_10223(stoneName);
                RegistryUtils.registerOreTarget(stoneName, new OreFeatureConfig.Target(stoneName, (Predicate<class_2680>)new class_2717(block), block));
                DimensionMaterial material = DimensionMaterial.Builder.create(id, name).oreType(Rands.values(OreType.values())).color(RGB.getColor()).target(stoneName).foodData(materialFoodData).armor(Rands.chance(2)).tools(!Rands.chance(3)).oreFlower(Rands.chance(4)).weapons(!Rands.chance(3)).glowing(Rands.chance(4)).minXPAmount(0).maxXPAmount(Rands.randIntRange(0, 4)).oreClusterSize(Rands.randIntRange(2, 9)).food(Rands.chance(4)).dimensionData(dimensionData).compostbleAmount(Rands.randFloatRange(0.1f, 1.0f)).compostable(Rands.chance(10)).build();
                class_2378.method_10230(DIMENSION_MATERIALS, (class_2960)id, (Object)material);
                if (!RandomlyAddingAnything.CONFIG.debug) continue;
                ConsolePrinting.materialDebug(material, RGB);
            }
        }
        dimensionReady = true;
    }

    public static void createMaterialResources() {
        if (RandomlyAddingAnything.CONFIG.debug) {
            RegistryUtils.registerItem(new RAADebugItem(), new class_2960("raa", "debug_stick"));
        }
        MATERIALS.forEach(material -> {
            class_1792 item;
            RAASimpleItem repairItem;
            class_2960 identifier = material.getId();
            class_2248 idk = ((OreFeatureConfig.Target)Objects.requireNonNull(RAARegisteries.TARGET_REGISTRY.method_10223(material.getOreInformation().getTargetId()), "Invalid target! " + material.getOreInformation().getTargetId().toString())).getBlock();
            FabricBlockSettings blockSettings = material.getOreInformation().getTargetId() != CustomTargets.DOES_NOT_APPEAR.getId() ? FabricBlockSettings.copy((class_2248)(idk != null ? idk : class_2246.field_10340)) : FabricBlockSettings.copy((class_2248)class_2246.field_10340);
            class_2248 baseBlock = material.getOreInformation().getTargetId() != CustomTargets.DOES_NOT_APPEAR.getId() ? (idk != null ? idk : class_2246.field_10340) : class_2246.field_10340;
            class_3614 baseBlockMaterial = baseBlock.method_9597(baseBlock.method_9564());
            if (baseBlockMaterial == class_3614.field_15914) {
                blockSettings.breakByTool(FabricToolTags.PICKAXES, material.getMiningLevel());
            } else if (baseBlockMaterial == class_3614.field_15941) {
                blockSettings.breakByTool(FabricToolTags.SHOVELS, material.getMiningLevel());
            } else {
                blockSettings.breakByHand(true);
            }
            class_2248 block = RegistryUtils.register((class_2248)new RAABlock(), Utils.appendToPath(identifier, "_block"), RandomlyAddingAnything.RAA_RESOURCES, material.getName(), RAABlockItem.BlockType.BLOCK);
            if (material.isCompostable()) {
                CompostingChanceRegistry.INSTANCE.add((class_1935)class_2378.field_11142.method_10223(class_2378.field_11146.method_10221((Object)block)), (Object)Float.valueOf(material.getCompostableAmount()));
            }
            if (!material.getOreInformation().getTargetId().toString().equals(CustomTargets.DOES_NOT_APPEAR.getId().toString())) {
                RegistryUtils.register((class_2248)new LayeredOreBlock((Material)material, blockSettings.build()), Utils.appendToPath(identifier, "_ore"), RandomlyAddingAnything.RAA_ORES, material.getName(), RAABlockItem.BlockType.ORE);
            }
            if (material.getOreInformation().getOreType() == OreType.METAL) {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.INGOT);
                item = RegistryUtils.registerItem(repairItem, Utils.appendToPath(identifier, "_ingot"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount() - 1.0f));
                }
                item = RegistryUtils.registerItem(new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.NUGGET), Utils.appendToPath(identifier, "_nugget"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount() - 0.5f));
                }
            } else if (material.getOreInformation().getOreType() == OreType.GEM) {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.GEM);
                item = RegistryUtils.registerItem(repairItem, Utils.appendToPath(identifier, "_gem"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount() + 0.5f));
                }
            } else {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.CRYSTAL);
                item = RegistryUtils.registerItem(repairItem, Utils.appendToPath(identifier, "_crystal"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount() + 0.5f));
                }
            }
            if (material.hasArmor()) {
                item = RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6169, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_helmet"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6174, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_chestplate"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6172, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_leggings"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6166, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_boots"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAHorseArmorItem((Material)material), Utils.appendToPath(identifier, "_horse_armor"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
            }
            if (material.hasTools()) {
                item = RegistryUtils.registerItem((class_1792)new RAAPickaxeItem((Material)material, material.getToolMaterial(), 1, -2.8f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_pickaxe"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAAxeItem((Material)material, material.getToolMaterial(), 5.0f + material.getToolMaterial().getAxeAttackDamage(), -3.2f + material.getToolMaterial().getAxeAttackSpeed(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_axe"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAShovelItem((Material)material, material.getToolMaterial(), 1.5f, -3.0f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_shovel"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAHoeItem((Material)material, material.getToolMaterial(), -3.0f + material.getToolMaterial().getHoeAttackSpeed(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_hoe"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAShearItem((Material)material, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_shears"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
            }
            if (material.hasWeapons()) {
                item = RegistryUtils.registerItem((class_1792)new RAASwordItem((Material)material, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_WEAPONS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_sword"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
            }
            if (material.hasFood()) {
                class_4174.class_4175 foodComponent = new class_4174.class_4175();
                if (material.getFoodData().isAlwaysEdible()) {
                    foodComponent.method_19240();
                }
                if (material.getFoodData().isMeat()) {
                    foodComponent.method_19236();
                }
                if (material.getFoodData().isSnack()) {
                    foodComponent.method_19241();
                }
                foodComponent.method_19238(material.getFoodData().getHunger());
                foodComponent.method_19237(material.getFoodData().getSaturationModifier());
                class_1792 item2 = RegistryUtils.registerItem(new RAAFoodItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_FOOD).method_19265(foodComponent.method_19242())), Utils.appendToPath(identifier, "_fruit"));
                CompostingChanceRegistry.INSTANCE.add((class_1935)item2, (Object)Float.valueOf(material.getCompostableAmount()));
            }
        });
        RandomlyAddingAnything.MODCOMPAT.generateCompatItems();
    }

    public static void createDimensionMaterialResources() {
        if (RandomlyAddingAnything.CONFIG.debug) {
            RegistryUtils.registerItem(new RAADebugItem(), new class_2960("raa", "debug_stick"));
        }
        DIMENSION_MATERIALS.forEach(material -> {
            class_1792 item;
            RAASimpleItem repairItem;
            class_2960 dimensionId = new class_2960(material.getId().method_12836(), material.getId().method_12832().split("_")[0]);
            class_2960 stoneName = Utils.appendToPath(dimensionId, "_stone");
            class_2248 blockIn = (class_2248)class_2378.field_11146.method_10223(stoneName);
            RegistryUtils.registerOreTarget(stoneName, new OreFeatureConfig.Target(stoneName, (Predicate<class_2680>)new class_2717(blockIn), blockIn));
            class_2960 identifier = material.getId();
            FabricBlockSettings blockSettings = FabricBlockSettings.copy((class_2248)((OreFeatureConfig.Target)Objects.requireNonNull(RAARegisteries.TARGET_REGISTRY.method_10223(material.getOreInformation().getTargetId()))).getBlock());
            class_2248 baseBlock = ((OreFeatureConfig.Target)Objects.requireNonNull(RAARegisteries.TARGET_REGISTRY.method_10223(material.getOreInformation().getTargetId()))).getBlock();
            class_3614 baseBlockMaterial = baseBlock.method_9597(baseBlock.method_9564());
            if (baseBlockMaterial == class_3614.field_15914) {
                blockSettings.breakByTool(FabricToolTags.PICKAXES, material.getMiningLevel());
            } else if (baseBlockMaterial == class_3614.field_15941) {
                blockSettings.breakByTool(FabricToolTags.SHOVELS, material.getMiningLevel());
            } else {
                blockSettings.breakByHand(true);
            }
            class_2248 block = RegistryUtils.register((class_2248)new RAABlock(), Utils.appendToPath(identifier, "_block"), RandomlyAddingAnything.RAA_RESOURCES, material.getName(), RAABlockItem.BlockType.BLOCK);
            if (material.isCompostable()) {
                CompostingChanceRegistry.INSTANCE.add((class_1935)class_2378.field_11142.method_10223(class_2378.field_11146.method_10221((Object)block)), (Object)Float.valueOf(material.getCompostableAmount() + 0.5f));
            }
            if (material.getOreInformation().getTargetId() != CustomTargets.DOES_NOT_APPEAR.getId()) {
                class_2248 block2 = RegistryUtils.register((class_2248)new LayeredOreBlock((Material)material, blockSettings.build()), Utils.appendToPath(identifier, "_ore"), RandomlyAddingAnything.RAA_ORES, material.getName(), RAABlockItem.BlockType.ORE);
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)class_2378.field_11142.method_10223(class_2378.field_11146.method_10221((Object)block2)), (Object)Float.valueOf(material.getCompostableAmount()));
                }
            }
            if (material.getOreInformation().getOreType() == OreType.METAL) {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.INGOT);
                item = RegistryUtils.registerItem(repairItem, Utils.appendToPath(identifier, "_ingot"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount() - 1.0f));
                }
                item = RegistryUtils.registerItem(new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.NUGGET), Utils.appendToPath(identifier, "_nugget"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount() - 0.5f));
                }
            } else if (material.getOreInformation().getOreType() == OreType.GEM) {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.GEM);
                item = RegistryUtils.registerItem(repairItem, Utils.appendToPath(identifier, "_gem"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount() + 0.5f));
                }
            } else {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.CRYSTAL);
                item = RegistryUtils.registerItem(repairItem, Utils.appendToPath(identifier, "_crystal"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount() + 0.5f));
                }
            }
            if (material.hasArmor()) {
                item = RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6169, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_helmet"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6174, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_chestplate"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6172, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_leggings"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6166, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_boots"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAHorseArmorItem((Material)material), Utils.appendToPath(identifier, "_horse_armor"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
            }
            if (material.hasTools()) {
                item = RegistryUtils.registerItem((class_1792)new RAAPickaxeItem((Material)material, material.getToolMaterial(), 1, -2.8f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_pickaxe"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAAxeItem((Material)material, material.getToolMaterial(), 5.0f + material.getToolMaterial().getAxeAttackDamage(), -3.2f + material.getToolMaterial().getAxeAttackSpeed(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_axe"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAShovelItem((Material)material, material.getToolMaterial(), 1.5f, -3.0f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_shovel"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAHoeItem((Material)material, material.getToolMaterial(), -3.0f + material.getToolMaterial().getHoeAttackSpeed(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_hoe"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
                item = RegistryUtils.registerItem((class_1792)new RAAShearItem((Material)material, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_shears"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
            }
            if (material.hasWeapons()) {
                item = RegistryUtils.registerItem((class_1792)new RAASwordItem((Material)material, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_WEAPONS).method_7896((class_1792)repairItem)), Utils.appendToPath(identifier, "_sword"));
                if (material.isCompostable()) {
                    CompostingChanceRegistry.INSTANCE.add((class_1935)item, (Object)Float.valueOf(material.getCompostableAmount()));
                }
            }
            if (material.hasFood()) {
                class_4174.class_4175 foodComponent = new class_4174.class_4175();
                if (material.getFoodData().isAlwaysEdible()) {
                    foodComponent.method_19240();
                }
                if (material.getFoodData().isMeat()) {
                    foodComponent.method_19236();
                }
                if (material.getFoodData().isSnack()) {
                    foodComponent.method_19241();
                }
                foodComponent.method_19238(material.getFoodData().getHunger());
                foodComponent.method_19237(material.getFoodData().getSaturationModifier());
                class_1792 item2 = RegistryUtils.registerItem(new RAAFoodItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_FOOD).method_19265(foodComponent.method_19242())), Utils.appendToPath(identifier, "_fruit"));
                CompostingChanceRegistry.INSTANCE.add((class_1935)item2, (Object)Float.valueOf(material.getCompostableAmount()));
            }
        });
    }
}

