/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.utils;

import io.github.vampirestudios.raa.api.dimension.DimensionChunkGenerators;
import io.github.vampirestudios.raa.generation.dimensions.data.DimensionData;
import io.github.vampirestudios.raa.registries.SurfaceBuilders;
import io.github.vampirestudios.raa.utils.Rands;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Scanner;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3523;
import net.minecraft.class_3527;

public class Utils {
    public static final int CORRUPTED = 1;
    public static final int DEAD = 2;
    public static final int ABANDONED = 4;
    public static final int LUSH = 8;
    public static final int CIVILIZED = 16;
    public static final int MOLTEN = 32;
    public static final int DRY = 64;
    public static final int TECTONIC = 128;
    public static final int FROZEN = 256;
    public static final int POST_APOCALYPTIC = 199;

    public static String toTitleCase(String lowerCase) {
        return "" + Character.toUpperCase(lowerCase.charAt(0)) + lowerCase.substring(1);
    }

    public static String nameToId(String name, Map<String, String> specialCharMap) {
        for (Map.Entry<String, String> specialChar : specialCharMap.entrySet()) {
            name = name.replace(specialChar.getKey(), specialChar.getValue());
        }
        return name.toLowerCase(Locale.ENGLISH);
    }

    public static class_2960 appendToPath(class_2960 identifier, String suffix) {
        return new class_2960(identifier.method_12836(), identifier.method_12832() + suffix);
    }

    public static class_2960 prependToPath(class_2960 identifier, String prefix) {
        return new class_2960(identifier.method_12836(), prefix + identifier.method_12832());
    }

    public static class_2960 appendAndPrependToPath(class_2960 identifier, String prefix, String suffix) {
        return new class_2960(identifier.method_12836(), prefix + identifier.method_12832() + suffix);
    }

    public static class_3523<class_3527> randomSurfaceBuilder(int chance, DimensionData data) {
        if (data.getDimensionChunkGenerator() == DimensionChunkGenerators.OVERWORLD || data.getDimensionChunkGenerator() == DimensionChunkGenerators.CUSTOM_OVERWORLD) {
            if (chance < 20) {
                return class_3523.field_15701;
            }
            if (chance > 20 && chance <= 30) {
                return SurfaceBuilders.HYPER_FLAT;
            }
            if (chance > 30 && chance <= 40) {
                return SurfaceBuilders.PATCHY_DESERT;
            }
            if (chance > 40 && chance <= 50) {
                if (Rands.chance(4)) {
                    return SurfaceBuilders.DARK_PATCHY_BADLANDS;
                }
                return SurfaceBuilders.PATCHY_BADLANDS;
            }
            if (chance > 50 && chance <= 60) {
                return SurfaceBuilders.CLASSIC_CLIFFS;
            }
            if (chance > 60 && chance <= 70) {
                return SurfaceBuilders.STRATIFIED_CLIFFS;
            }
            if (chance > 70 && chance <= 80) {
                return SurfaceBuilders.FLOATING_ISLANDS;
            }
            if (chance > 80 && chance <= 90 && FabricLoader.getInstance().isModLoaded("simplexterrain")) {
                if (Rands.chance(10)) {
                    return SurfaceBuilders.SANDY_DUNES;
                }
                return SurfaceBuilders.DUNES;
            }
            if (chance > 90 && chance <= 100) {
                return SurfaceBuilders.LAZY_NOISE;
            }
        }
        return class_3523.field_15701;
    }

    public static DimensionChunkGenerators randomCG(int chance) {
        if (chance < 15) {
            if (chance <= 5) {
                return DimensionChunkGenerators.FLAT_CAVES;
            }
            if (chance <= 10) {
                return DimensionChunkGenerators.HIGH_CAVES;
            }
            return DimensionChunkGenerators.CAVE;
        }
        if (chance > 15 && chance < 30) {
            if (chance <= 20) {
                return DimensionChunkGenerators.LAYERED_FLOATING;
            }
            if (chance <= 25) {
                return DimensionChunkGenerators.PRE_CLASSIC_FLOATING;
            }
            return DimensionChunkGenerators.FLOATING;
        }
        if (chance <= 40) {
            return DimensionChunkGenerators.QUADRUPLE_AMPLIFIED;
        }
        if (chance <= 50) {
            return DimensionChunkGenerators.PILLAR_WORLD;
        }
        if (chance <= 60 && FabricLoader.getInstance().isModLoaded("simplexterrain")) {
            return DimensionChunkGenerators.CUSTOM_OVERWORLD;
        }
        return DimensionChunkGenerators.OVERWORLD;
    }

    public static boolean checkBitFlag(int toCheck, int flag) {
        return (toCheck & flag) == flag;
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public static String generateCivsName() throws IOException {
        Random rand = new Random();
        class_2960 surnames = new class_2960("raa", "names/civilizations.txt");
        InputStream stream = class_310.method_1551().method_1478().method_14486(surnames).method_14482();
        Scanner scanner = new Scanner(Objects.requireNonNull(stream));
        StringBuilder builder = new StringBuilder();
        while (scanner.hasNextLine()) {
            builder.append(scanner.nextLine());
            builder.append(",");
        }
        String[] strings = builder.toString().split(",");
        String civilizationName = strings[rand.nextInt(strings.length)];
        stream.close();
        scanner.close();
        return civilizationName;
    }

    public static void createSpawnsFile(String name, class_1936 world, class_2338 pos) {
        try {
            class_1937 world2 = world.method_8410();
            String path = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? "saves/" + ((class_3218)world2).method_17982().method_132().getName() + "/DIM_raa_" + world.method_8597().method_12460().method_12489().substring(4) + "/data/" + name + "_spawns.txt" : world.method_8401().method_150() + "/DIM_raa_" + world.method_8597().method_12460().method_12489().substring(4) + "/data/" + name + "_spawns.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(path, true));
            writer.append(pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

