/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.utils;

import com.google.common.collect.ImmutableList;
import io.github.vampirestudios.raa.registries.RAATags;
import io.github.vampirestudios.raa.utils.Rands;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3867;

public class WorldStructureManipulation {
    public static class_2382 circularSpawnCheck(class_1936 world, class_2338 pos, class_2382 size, float tolerance) {
        return WorldStructureManipulation.circularSpawnCheck(world, pos, size, tolerance, false);
    }

    public static class_2382 circularSpawnCheck(class_1936 world, class_2338 pos, class_2382 size, float tolerance, boolean isUnderground) {
        int xOrigin = pos.method_10263();
        int zOrigin = pos.method_10260();
        class_2382 newPos = class_2382.field_11176;
        ArrayList<List<Float>> flatnessList = new ArrayList<List<Float>>();
        for (float xOffset = (float)(xOrigin - size.method_10263()); xOffset < (float)(xOrigin + size.method_10263()); xOffset += 1.0f) {
            for (float zOffset = (float)(zOrigin - size.method_10260()); zOffset < (float)(zOrigin + size.method_10260()); zOffset += 1.0f) {
                boolean nonSpawnable;
                float yOffset = world.method_8598(class_2902.class_2903.field_13194, new class_2338((double)xOffset, 0.0, (double)zOffset)).method_10264();
                boolean bl = nonSpawnable = yOffset < 5.0f || !world.method_8320(new class_2338((double)xOffset, (double)(yOffset - 1.0f), (double)zOffset)).method_11619() && !world.method_8320(new class_2338((double)xOffset, (double)(yOffset - 2.0f), (double)zOffset)).method_11619() || world.method_8320(new class_2338((double)xOffset, (double)(yOffset - 1.0f), (double)zOffset)).equals(class_2246.field_9987.method_9564());
                if (xOffset < (float)(xOrigin + 3) && zOffset < (float)(zOrigin + 3)) {
                    flatnessList.add(Arrays.asList(Float.valueOf(xOffset), Float.valueOf(yOffset), Float.valueOf(zOffset), Float.valueOf(0.0f)));
                }
                for (List list : flatnessList) {
                    if (!(Math.pow(xOffset - ((Float)list.get(0)).floatValue() - (float)(size.method_10263() - 3) / 2.0f, 2.0) + Math.pow(zOffset - ((Float)list.get(2)).floatValue() - (float)(size.method_10263() - 3) / 2.0f, 2.0) < Math.pow((float)(size.method_10263() - 2) / 2.0f, 2.0))) continue;
                    if (yOffset > ((Float)list.get(1)).floatValue() - 3.0f && yOffset <= ((Float)list.get(1)).floatValue()) {
                        if (yOffset == ((Float)list.get(1)).floatValue()) {
                            list.set(3, Float.valueOf(((Float)list.get(3)).floatValue() + 1.0f));
                        } else if (yOffset == ((Float)list.get(1)).floatValue() - 1.0f) {
                            list.set(3, Float.valueOf(((Float)list.get(3)).floatValue() + 0.5f));
                        } else {
                            list.set(3, Float.valueOf(((Float)list.get(3)).floatValue() + 0.25f));
                        }
                    }
                    if (!nonSpawnable) continue;
                    list.set(3, Float.valueOf((float)(-Math.pow(size.method_10263(), 2.0))));
                }
            }
        }
        float maxFlatness = -1.0f;
        int chosen = -1;
        for (int i = 0; i < flatnessList.size(); ++i) {
            if (!(((Float)((List)flatnessList.get(i)).get(3)).floatValue() > maxFlatness)) continue;
            maxFlatness = ((Float)((List)flatnessList.get(i)).get(3)).floatValue();
            chosen = i;
        }
        if (chosen != -1) {
            int xChosen = ((Float)((List)flatnessList.get(chosen)).get(0)).intValue();
            int yChosen = ((Float)((List)flatnessList.get(chosen)).get(1)).intValue();
            int zChosen = ((Float)((List)flatnessList.get(chosen)).get(2)).intValue();
            newPos = WorldStructureManipulation.trySpawning(world, new class_2338(xChosen, yChosen, zChosen), size, tolerance, isUnderground);
        }
        if (newPos.method_10265(class_2382.field_11176) == 0 || newPos.method_10264() > 255 - size.method_10264()) {
            return class_2382.field_11176;
        }
        return newPos;
    }

    private static class_2382 trySpawning(class_1936 world, class_2338 pos, class_2382 size, float tolerance, boolean isUnderground) {
        if (!isUnderground ? world.method_8320(pos.method_10069(0, -1, 0)).method_11588() || world.method_8320(pos.method_10069(0, -1, 0)).equals(class_2246.field_9987.method_9564()) : !world.method_8320(pos.method_10069(0, -1, 0)).method_11614().method_9525(RAATags.UNDERGROUND_BLOCKS) || world.method_8320(pos.method_10069(0, -1, 0)).equals(class_2246.field_9987.method_9564())) {
            return class_2382.field_11176;
        }
        HashMap<Integer, Float> heights = new HashMap<Integer, Float>();
        for (int i = 0; i < 256; ++i) {
            heights.put(i, Float.valueOf(0.0f));
        }
        int totalHeight = 0;
        float maxFreq = 0.0f;
        int maxHeight = 0;
        int modeHeight = 0;
        int minHeight = 256;
        for (int xIndent = 0; xIndent < 12; ++xIndent) {
            for (int zIndent = 0; zIndent < 12; ++zIndent) {
                if (!(Math.pow((float)xIndent - (float)(size.method_10263() - 3) / 2.0f, 2.0) + Math.pow((float)zIndent - (float)(size.method_10263() - 3) / 2.0f, 2.0) < Math.pow((float)(size.method_10263() - 2) / 2.0f, 2.0))) continue;
                if (!world.method_8320(new class_2338((class_2382)pos.method_10069(xIndent, -1, zIndent))).method_11619() && !world.method_8320(new class_2338((class_2382)pos.method_10069(xIndent, -2, zIndent))).method_11619()) {
                    return class_2382.field_11176;
                }
                int tempHeight = world.method_8598(class_2902.class_2903.field_13194, pos.method_10069(xIndent, 0, zIndent)).method_10264();
                if (tempHeight < minHeight) {
                    minHeight = tempHeight;
                }
                if (tempHeight > maxHeight) {
                    maxHeight = tempHeight;
                }
                totalHeight += tempHeight;
                List<Integer> tempHeights = Arrays.asList(tempHeight, tempHeight - 1, tempHeight - 2);
                List<Float> tempFloats = Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.5f), Float.valueOf(0.25f));
                for (int i = 0; i < 3; ++i) {
                    if (tempHeights.get(i) < 0 || tempHeights.get(i) > 255) {
                        return class_2382.field_11176;
                    }
                    float tempFreqs = ((Float)heights.get(tempHeights.get(i))).floatValue() + tempFloats.get(i).floatValue();
                    heights.put(tempHeights.get(i), Float.valueOf(tempFreqs));
                    if (!(tempFreqs > maxFreq)) continue;
                    maxFreq = tempFreqs;
                    modeHeight = tempHeights.get(i);
                }
            }
        }
        int area = (int)(Math.PI * Math.pow((float)(size.method_10263() - 2) / 2.0f, 2.0));
        float f = tolerance = tolerance > 1.0f ? 1.0f : Math.max(tolerance, 0.0f);
        if (maxHeight - minHeight > 3 && (float)(maxHeight * area - totalHeight) > (float)area * ((float)(maxHeight - minHeight) / 2.0f * tolerance) && (float)(maxHeight * area - totalHeight) < (float)area * ((float)(maxHeight - minHeight) * (1.0f - tolerance / 2.0f))) {
            return class_2382.field_11176;
        }
        return pos.method_10069(0, modeHeight - pos.method_10264(), 0);
    }

    public static void placeBlock(class_1936 world, class_2338 pos, String block, Map<String, String> properties, int rotation) {
        world.method_8652(pos, ((class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)block))).method_9564(), 2);
        String facing = "NORTH";
        if (properties.get("facing") != null && !(facing = properties.get("facing")).equals("UP") && !facing.equals("DOWN")) {
            facing = WorldStructureManipulation.rotateDir(rotation, facing);
        }
        List<String> directions = Arrays.asList("FALSE", "FALSE", "FALSE", "FALSE");
        if (properties.get("north") != null || properties.get("west") != null || properties.get("south") != null || properties.get("east") != null) {
            directions = WorldStructureManipulation.rotateWall(rotation, Arrays.asList(properties.get("north"), properties.get("west"), properties.get("south"), properties.get("east")));
        }
        String axis = "x";
        if (properties.get("axis") != null) {
            axis = properties.get("axis");
            String string = rotation % 2 == 0 ? axis : (axis.equals("x") ? "z" : (axis = axis.equals("z") ? "x" : axis));
        }
        if (world.method_8320(pos) == ((class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)block))).method_9564()) {
            if (properties.get("waterlogged") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(properties.get("waterlogged").equals("TRUE"))), 2);
            }
            if (properties.get("type") != null) {
                if (block.equals("minecraft:chest")) {
                    world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12506, (Comparable)class_2745.valueOf((String)properties.get("type").toUpperCase(Locale.ENGLISH))), 2);
                } else {
                    world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12485, (Comparable)class_2771.valueOf((String)properties.get("type").toUpperCase(Locale.ENGLISH))), 2);
                }
            }
            if (properties.get("half") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.valueOf((String)properties.get("half").toUpperCase(Locale.ENGLISH))), 2);
            }
            if (properties.get("shape") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12503, (Comparable)class_2778.valueOf((String)properties.get("shape").toUpperCase(Locale.ENGLISH))), 2);
            }
            if (properties.get("facing") != null) {
                if (block.equals("minecraft:barrel")) {
                    world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.valueOf((String)facing.toUpperCase(Locale.ENGLISH))), 2);
                } else {
                    world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.valueOf((String)facing.toUpperCase(Locale.ENGLISH))), 2);
                }
            }
            if (properties.get("north") != null || properties.get("west") != null || properties.get("south") != null || properties.get("east") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(directions.get(0) != null && directions.get(0).equals("TRUE"))), 2);
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(directions.get(1) != null && directions.get(1).equals("TRUE"))), 2);
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(directions.get(2) != null && directions.get(2).equals("TRUE"))), 2);
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(directions.get(3) != null && directions.get(3).equals("TRUE"))), 2);
            }
            if (properties.get("up") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(properties.get("up").toUpperCase(Locale.ENGLISH).equals("TRUE"))), 2);
            }
            if (properties.get("open") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(properties.get("open").toUpperCase(Locale.ENGLISH).equals("TRUE"))), 2);
            }
            if (properties.get("snowy") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(properties.get("snowy").toUpperCase(Locale.ENGLISH).equals("TRUE"))), 2);
            }
            if (properties.get("lit") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(properties.get("lit").toUpperCase(Locale.ENGLISH).equals("TRUE"))), 2);
            }
            if (properties.get("bottom") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_16562, (Comparable)Boolean.valueOf(properties.get("bottom").toUpperCase(Locale.ENGLISH).equals("TRUE"))), 2);
            }
            if (properties.get("hanging") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(properties.get("hanging").toUpperCase(Locale.ENGLISH).equals("TRUE"))), 2);
            }
            if (properties.get("powered") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(properties.get("powered").toUpperCase(Locale.ENGLISH).equals("TRUE"))), 2);
            }
            if (properties.get("unstable") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12539, (Comparable)Boolean.valueOf(properties.get("unstable").toUpperCase(Locale.ENGLISH).equals("TRUE"))), 2);
            }
            if (properties.get("face") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12555, (Comparable)class_2738.valueOf((String)properties.get("face").toUpperCase(Locale.ENGLISH))), 2);
            }
            if (properties.get("distance") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_16503, (Comparable)Integer.valueOf(Integer.parseInt(properties.get("distance")))), 2);
            }
            if (properties.get("attachment") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_17104, (Comparable)class_3867.valueOf((String)properties.get("attachment").toUpperCase(Locale.ENGLISH))), 2);
            }
            if (properties.get("axis") != null) {
                world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.valueOf((String)axis.toUpperCase(Locale.ENGLISH))), 2);
            }
        }
    }

    public static void spawnEntity(class_1936 world, class_2338 pos, String entity, Map<String, String> properties, float rotation) {
        if (entity.equals("minecraft:armor_stand")) {
            class_1297 armorStand = class_1299.field_6131.method_5883(world.method_8410());
            ImmutableList helmets = ImmutableList.of((Object)new class_1799((class_1935)class_1802.field_8267), (Object)new class_1799((class_1935)class_1802.field_8283), (Object)new class_1799((class_1935)class_1802.field_8862), (Object)new class_1799((class_1935)class_1802.field_8743), (Object)new class_1799((class_1935)class_1802.field_8805));
            ImmutableList chestplates = ImmutableList.of((Object)new class_1799((class_1935)class_1802.field_8577), (Object)new class_1799((class_1935)class_1802.field_8873), (Object)new class_1799((class_1935)class_1802.field_8678), (Object)new class_1799((class_1935)class_1802.field_8523), (Object)new class_1799((class_1935)class_1802.field_8058));
            ImmutableList leggings = ImmutableList.of((Object)new class_1799((class_1935)class_1802.field_8570), (Object)new class_1799((class_1935)class_1802.field_8218), (Object)new class_1799((class_1935)class_1802.field_8416), (Object)new class_1799((class_1935)class_1802.field_8396), (Object)new class_1799((class_1935)class_1802.field_8348));
            ImmutableList boots = ImmutableList.of((Object)new class_1799((class_1935)class_1802.field_8370), (Object)new class_1799((class_1935)class_1802.field_8313), (Object)new class_1799((class_1935)class_1802.field_8753), (Object)new class_1799((class_1935)class_1802.field_8660), (Object)new class_1799((class_1935)class_1802.field_8285));
            ImmutableList weapons = ImmutableList.of((Object)new class_1799((class_1935)class_1802.field_8528), (Object)new class_1799((class_1935)class_1802.field_8845), (Object)new class_1799((class_1935)class_1802.field_8371), (Object)new class_1799((class_1935)class_1802.field_8802));
            Objects.requireNonNull(armorStand).method_5725(pos, rotation, 0.0f);
            if (properties.get("head") != null && !Rands.chance(4)) {
                armorStand.method_5673(class_1304.field_6169, (class_1799)helmets.get(Rands.randInt(Integer.parseInt(properties.get("head")))));
            }
            if (properties.get("chest") != null && !Rands.chance(4)) {
                armorStand.method_5673(class_1304.field_6174, (class_1799)chestplates.get(Rands.randInt(Integer.parseInt(properties.get("chest")))));
            }
            if (properties.get("legs") != null && !Rands.chance(4)) {
                armorStand.method_5673(class_1304.field_6172, (class_1799)leggings.get(Rands.randInt(Integer.parseInt(properties.get("legs")))));
            }
            if (properties.get("feet") != null && !Rands.chance(4)) {
                armorStand.method_5673(class_1304.field_6166, (class_1799)boots.get(Rands.randInt(Integer.parseInt(properties.get("feet")))));
            }
            if (properties.get("weapon") != null && !Rands.chance(3)) {
                armorStand.method_5673(class_1304.field_6173, (class_1799)weapons.get(Rands.randInt(Integer.parseInt(properties.get("weapon")))));
            }
            world.method_8649(armorStand);
        }
    }

    public static class_2382 rotatePos(int rotation, class_2382 pos, class_2382 size) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        if (rotation == 1) {
            int xTemp = pos.method_10263();
            x = size.method_10263() - 1 - z;
            z = xTemp;
        } else if (rotation == 2) {
            x = size.method_10263() - 1 - x;
            z = size.method_10260() - 1 - z;
        } else if (rotation == 3) {
            int xTemp = x;
            x = z;
            z = size.method_10260() - 1 - xTemp;
        }
        return new class_2382(x, pos.method_10264(), z);
    }

    private static String rotateDir(int rotation, String direction) {
        if (rotation > 0) {
            String dir = WorldStructureManipulation.rotateDir(rotation - 1, direction);
            return dir.equals("NORTH") ? "WEST" : (dir.equals("WEST") ? "SOUTH" : (dir.equals("SOUTH") ? "EAST" : "NORTH"));
        }
        return direction;
    }

    private static List<String> rotateWall(int rotation, List<String> directions) {
        if (rotation > 0) {
            List<String> dirs = WorldStructureManipulation.rotateWall(rotation - 1, directions);
            return Arrays.asList(dirs.get(3), dirs.get(0), dirs.get(1), dirs.get(2));
        }
        return directions;
    }
}

