/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.utils.noise.old;

import io.github.vampirestudios.raa.utils.noise.old.OpenSimplexNoise;
import java.util.Random;

public final class OctaveOpenSimplexNoise {
    protected OpenSimplexNoise[] samplers;
    private double clamp;
    private double frequency;
    private double amplitudeLow;
    private double amplitudeHigh;

    public OctaveOpenSimplexNoise(Random rand, int octaves, double frequency, double amplitudeHigh, double amplitudeLow) {
        this.samplers = new OpenSimplexNoise[octaves];
        this.clamp = 1.0 / (1.0 - 1.0 / Math.pow(2.0, octaves));
        for (int i = 0; i < octaves; ++i) {
            this.samplers[i] = new OpenSimplexNoise(rand.nextLong());
        }
        this.frequency = frequency;
        this.amplitudeLow = amplitudeLow;
        this.amplitudeHigh = amplitudeHigh;
    }

    public double sample(double x, double y) {
        double amplFreq = 0.5;
        double result = 0.0;
        for (OpenSimplexNoise sampler : this.samplers) {
            result += amplFreq * sampler.sample(x / (amplFreq * this.frequency), y / (amplFreq * this.frequency));
            amplFreq *= 0.5;
        }
        return (result *= this.clamp) > 0.0 ? result * this.amplitudeHigh : result * this.amplitudeLow;
    }
}

