/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.world.player;

import io.github.vampirestudios.raa.generation.materials.DimensionMaterial;
import io.github.vampirestudios.raa.generation.materials.Material;
import io.github.vampirestudios.raa.registries.Materials;
import io.github.vampirestudios.raa.world.player.OreDiscoverState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class PlayerDiscoveryState {
    private List<OreDiscoverState> materialDiscoveryState = new ArrayList<OreDiscoverState>(Materials.MATERIALS.method_10235().size() + 1);
    private List<OreDiscoverState> dimensionMaterialDiscoveryState;
    private boolean firstConnect;

    public PlayerDiscoveryState() {
        for (Material material : Materials.MATERIALS) {
            Objects.requireNonNull(this.materialDiscoveryState).add(new OreDiscoverState(material));
        }
        this.dimensionMaterialDiscoveryState = new ArrayList<OreDiscoverState>(Materials.DIMENSION_MATERIALS.method_10235().size() + 1);
        for (Material material : Materials.DIMENSION_MATERIALS) {
            Objects.requireNonNull(this.dimensionMaterialDiscoveryState).add(new OreDiscoverState(material));
        }
    }

    public void fromTag(class_2487 compoundTag) {
        ArrayList<OreDiscoverState> oreDiscoverStates = new ArrayList<OreDiscoverState>(Materials.MATERIALS.method_10235().size() + 1);
        class_2487 discoverList = compoundTag.method_10562("materialDiscoverList");
        if (discoverList.isEmpty()) {
            return;
        }
        for (String string_1 : discoverList.method_10541()) {
            class_2487 compoundTag1 = discoverList.method_10562(string_1);
            Material material = (Material)Materials.MATERIALS.method_10223(class_2960.method_12829((String)compoundTag1.method_10558("id")));
            if (material == null) continue;
            int discoveredTimes = compoundTag1.method_10550("discoverTimes");
            boolean discovered = compoundTag1.method_10577("discovered");
            oreDiscoverStates.add(new OreDiscoverState(material, discoveredTimes, discovered));
        }
        this.materialDiscoveryState = oreDiscoverStates;
        ArrayList<OreDiscoverState> dimensionOreDiscoverStates = new ArrayList<OreDiscoverState>(Materials.DIMENSION_MATERIALS.method_10235().size() + 1);
        class_2487 dimensionDiscoverList = compoundTag.method_10562("dimensionMaterialDiscoverList");
        if (dimensionDiscoverList.isEmpty()) {
            return;
        }
        for (String string_1 : dimensionDiscoverList.method_10541()) {
            class_2487 compoundTag1 = dimensionDiscoverList.method_10562(string_1);
            DimensionMaterial material = (DimensionMaterial)Materials.DIMENSION_MATERIALS.method_10223(class_2960.method_12829((String)compoundTag1.method_10558("id")));
            if (material == null) continue;
            int discoveredTimes = compoundTag1.method_10550("discoverTimes");
            boolean discovered = compoundTag1.method_10577("discovered");
            dimensionOreDiscoverStates.add(new OreDiscoverState(material, discoveredTimes, discovered));
        }
        this.dimensionMaterialDiscoveryState = dimensionOreDiscoverStates;
    }

    public class_2487 toTag(class_2487 compoundTag) {
        class_2487 discoverListCompound = new class_2487();
        for (int c = 0; c < this.materialDiscoveryState.size(); ++c) {
            if (this.materialDiscoveryState.get(c) == null) continue;
            class_2487 discoverListInformation = new class_2487();
            discoverListInformation.method_10582("id", this.materialDiscoveryState.get(c).getMaterial().getId().toString());
            discoverListInformation.method_10569("discoverTimes", this.materialDiscoveryState.get(c).getDiscoverTimes());
            discoverListInformation.method_10556("discovered", this.materialDiscoveryState.get(c).isDiscovered());
            discoverListCompound.method_10566("" + c + "", (class_2520)discoverListInformation.method_10553());
        }
        compoundTag.method_10566("materialDiscoverList", (class_2520)discoverListCompound);
        class_2487 dimensionDiscoverListCompound = new class_2487();
        for (int c = 0; c < this.dimensionMaterialDiscoveryState.size(); ++c) {
            if (this.dimensionMaterialDiscoveryState.get(c) == null) continue;
            class_2487 dimensionDiscoverListInformation = new class_2487();
            dimensionDiscoverListInformation.method_10582("id", this.dimensionMaterialDiscoveryState.get(c).getMaterial().getId().toString());
            dimensionDiscoverListInformation.method_10569("discoverTimes", this.dimensionMaterialDiscoveryState.get(c).getDiscoverTimes());
            dimensionDiscoverListInformation.method_10556("discovered", this.dimensionMaterialDiscoveryState.get(c).isDiscovered());
            dimensionDiscoverListCompound.method_10566("" + c + "", (class_2520)dimensionDiscoverListInformation.method_10553());
        }
        compoundTag.method_10566("dimensionMaterialDiscoverList", (class_2520)dimensionDiscoverListCompound);
        return compoundTag;
    }

    public List<OreDiscoverState> getMaterialDiscoveryState() {
        return this.materialDiscoveryState;
    }

    public List<OreDiscoverState> getDimensionMaterialDiscoveryState() {
        return this.dimensionMaterialDiscoveryState;
    }

    public boolean isFirstConnect() {
        return this.firstConnect;
    }

    public void setFirstConnect(boolean firstConnect) {
        this.firstConnect = firstConnect;
    }
}

