/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.impl.SyntaxError;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.vampirestudios.raa.RandomlyAddingAnything;
import io.github.vampirestudios.raa.api.enums.GeneratesIn;
import io.github.vampirestudios.raa.api.enums.OreTypes;
import io.github.vampirestudios.raa.materials.CustomArmorMaterial;
import io.github.vampirestudios.raa.materials.CustomToolMaterial;
import io.github.vampirestudios.raa.materials.Material;
import io.github.vampirestudios.raa.materials.MaterialBuilder;
import io.github.vampirestudios.raa.registries.Materials;
import io.github.vampirestudios.raa.utils.Rands;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class SavingSystem {
    private static File CONFIG_PATH = FabricLoader.getInstance().getConfigDirectory();
    private static final Gson DEFAULT_GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static Jankson jackson;
    private static File configFile;
    private static File configPath;
    private static String configFilename;
    private static Gson gson;
    private static int fileNumber;

    public static boolean init() {
        jackson = Jankson.builder().build();
        configPath = new File(new File(CONFIG_PATH, "raa"), "materials");
        if (!configPath.exists()) {
            configPath.mkdirs();
            return true;
        }
        configFile = new File(configPath, configFilename + "_" + fileNumber + ".json");
        return !configFile.exists();
    }

    public static void createFile() {
        configFile = new File(configPath, configFilename + "_" + fileNumber + ".json");
        try {
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(configFile));
            Material[] materialJSONS = SavingSystem.toJSON();
            fileWriter.write("{\"configVersion\":1,");
            fileWriter.newLine();
            fileWriter.flush();
            fileWriter.write("\"materials\": [");
            fileWriter.newLine();
            fileWriter.flush();
            for (int a = 0; a < materialJSONS.length; ++a) {
                if (a == materialJSONS.length - 1) {
                    fileWriter.write(gson.toJson((Object)materialJSONS[a]));
                    fileWriter.newLine();
                    fileWriter.flush();
                    continue;
                }
                fileWriter.write(gson.toJson((Object)materialJSONS[a]) + ",");
                fileWriter.newLine();
                fileWriter.flush();
            }
            fileWriter.write("]}");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readFile() {
        block13: {
            configFile = new File(configPath, configFilename + "_" + fileNumber + ".json");
            try {
                JsonObject jsonObject1 = jackson.load(configFile);
                if (jsonObject1.containsKey((Object)"configVersion")) {
                    int configVersion = (Integer)jsonObject1.get(Integer.TYPE, "configVersion");
                    if (configVersion != 1) {
                        return;
                    }
                    if (!jsonObject1.containsKey((Object)"materials")) {
                        Materials.init();
                        SavingSystem.createFile();
                        return;
                    }
                    JsonArray jsonArray = (JsonArray)jsonObject1.get(JsonArray.class, "materials");
                    if (jsonArray.size() == 0) {
                        Materials.init();
                        SavingSystem.createFile();
                        return;
                    }
                    for (int s = 0; s < jsonArray.size(); ++s) {
                        CustomToolMaterial toolMaterial;
                        float swordAttackDamage;
                        float axeAttackSpeed;
                        float attackDamage;
                        int durability;
                        JsonObject toolObject;
                        JsonObject jsonObject = (JsonObject)jsonArray.get(s);
                        String name = (String)jsonObject.get(String.class, "name");
                        int miningLevel = (Integer)jsonObject.get(Integer.TYPE, "miningLevel");
                        MaterialBuilder materialBuilder = MaterialBuilder.create();
                        materialBuilder.name(name).color((Integer)jsonObject.get(Integer.TYPE, "color")).storageBlockTexture(SavingSystem.idFromJson(jsonObject, "storageBlockTexture")).resourceItemTexture(SavingSystem.idFromJson(jsonObject, "resourceItemTexture")).armor((Boolean)jsonObject.get(Boolean.TYPE, "armor")).tools((Boolean)jsonObject.get(Boolean.TYPE, "tools")).weapons((Boolean)jsonObject.get(Boolean.TYPE, "weapons")).glowing((Boolean)jsonObject.get(Boolean.TYPE, "glowing")).oreFlower((Boolean)jsonObject.get(Boolean.TYPE, "oreFlower")).miningLevel(miningLevel).food((Boolean)jsonObject.get(Boolean.TYPE, "food"));
                        JsonObject oreInfo = jsonObject.getObject("oreInformation");
                        OreTypes oreTypes = (OreTypes)((Object)oreInfo.get(OreTypes.class, "oreType"));
                        materialBuilder.oreType(oreTypes).generatesIn((GeneratesIn)((Object)oreInfo.get(GeneratesIn.class, "generateIn"))).overlayTexture(SavingSystem.idFromJson(oreInfo, "overlayTexture")).minXPAmount(0).maxXPAmount((Integer)oreInfo.get(Integer.TYPE, "maxXPAmount")).oreClusterSize((Integer)oreInfo.get(Integer.TYPE, "oreClusterSize"));
                        if (!jsonObject.containsKey((Object)"nuggetTexture")) {
                            materialBuilder.nuggetTexture(null);
                        } else {
                            materialBuilder.nuggetTexture(SavingSystem.idFromJson(jsonObject, "nuggetTexture"));
                        }
                        if (((Boolean)jsonObject.get(Boolean.TYPE, "armor")).booleanValue()) {
                            JsonObject armorObject = jsonObject.getObject("armorMaterial");
                            int durabilityMultiplier = (Integer)armorObject.get(Integer.TYPE, "durabilityMultiplier");
                            int[] protectionAmounts = (int[])armorObject.get(int[].class, "protectionAmounts");
                            int enchantability = (Integer)armorObject.get(Integer.TYPE, "enchantability");
                            float toughness = ((Float)armorObject.get(Float.TYPE, "toughness")).floatValue();
                            int horseArmorBonus = (Integer)armorObject.get(Integer.TYPE, "horseArmorBonus");
                            CustomArmorMaterial armorMaterial = new CustomArmorMaterial(name, oreTypes, durabilityMultiplier, protectionAmounts, enchantability, toughness, horseArmorBonus);
                            materialBuilder.armor(armorMaterial);
                        }
                        if (((Boolean)jsonObject.get(Boolean.TYPE, "tools")).booleanValue()) {
                            toolObject = jsonObject.getObject("toolMaterial");
                            durability = (Integer)toolObject.get(Integer.TYPE, "durability");
                            int enchantability = (Integer)toolObject.get(Integer.TYPE, "enchantability");
                            float miningSpeed = ((Float)toolObject.get(Float.TYPE, "miningSpeed")).floatValue();
                            attackDamage = ((Float)toolObject.get(Float.TYPE, "attackDamage")).floatValue();
                            float hoeAttackSpeed = ((Float)toolObject.get(Float.TYPE, "hoeAttackSpeed")).floatValue();
                            float axeAttackDamage = ((Float)toolObject.get(Float.TYPE, "axeAttackDamage")).floatValue();
                            axeAttackSpeed = ((Float)toolObject.get(Float.TYPE, "axeAttackSpeed")).floatValue();
                            swordAttackDamage = ((Float)toolObject.get(Float.TYPE, "swordAttackDamage")).floatValue();
                            toolMaterial = new CustomToolMaterial(name, oreTypes, durability, miningSpeed, attackDamage, miningLevel, enchantability, hoeAttackSpeed, axeAttackDamage, axeAttackSpeed, swordAttackDamage);
                            materialBuilder.tools(toolMaterial);
                        }
                        if (((Boolean)jsonObject.get(Boolean.TYPE, "weapons")).booleanValue()) {
                            toolObject = jsonObject.getObject("toolMaterial");
                            durability = (Integer)toolObject.get(Integer.TYPE, "durability");
                            int enchantability = (Integer)toolObject.get(Integer.TYPE, "enchantability");
                            float miningSpeed = ((Float)toolObject.get(Float.TYPE, "miningSpeed")).floatValue();
                            attackDamage = ((Float)toolObject.get(Float.TYPE, "attackDamage")).floatValue();
                            float hoeAttackSpeed = ((Float)toolObject.get(Float.TYPE, "hoeAttackSpeed")).floatValue();
                            float axeAttackDamage = ((Float)toolObject.get(Float.TYPE, "axeAttackDamage")).floatValue();
                            axeAttackSpeed = ((Float)toolObject.get(Float.TYPE, "axeAttackSpeed")).floatValue();
                            swordAttackDamage = ((Float)toolObject.get(Float.TYPE, "swordAttackDamage")).floatValue();
                            toolMaterial = new CustomToolMaterial(name, oreTypes, durability, miningSpeed, attackDamage, miningLevel, enchantability, hoeAttackSpeed, axeAttackDamage, axeAttackSpeed, swordAttackDamage);
                            materialBuilder.weapons(toolMaterial);
                        }
                        Material material = materialBuilder.buildFromJSON();
                        String id = material.getName().toLowerCase();
                        for (Map.Entry<String, String> entry : RandomlyAddingAnything.CONFIG.namingLanguage.getCharMap().entrySet()) {
                            id = id.replace(entry.getKey(), entry.getValue());
                        }
                        class_2378.method_10230(Materials.MATERIALS, (class_2960)new class_2960("raa", id), (Object)material);
                    }
                    break block13;
                }
                Materials.init();
                SavingSystem.createFile();
                return;
            }
            catch (SyntaxError | IOException e) {
                SavingSystem.fromOldFile(configFile);
            }
        }
    }

    private static class_2960 idFromJson(JsonObject jsonObject, String name) {
        JsonObject jsonObject1 = jsonObject.getObject(name);
        if (jsonObject1.containsKey((Object)"namespace")) {
            return new class_2960((String)jsonObject1.get(String.class, "namespace"), (String)jsonObject1.get(String.class, "path"));
        }
        return new class_2960((String)jsonObject1.get(String.class, "field_13353"), (String)jsonObject1.get(String.class, "field_13355"));
    }

    private static void fromOldFile(File file) {
        try {
            Object[] objects;
            for (Object object : objects = (Object[])gson.fromJson((Reader)new FileReader(file), Object[].class)) {
                class_2960 resourceItem;
                JsonObject jsonObject = jackson.load(gson.toJson(object));
                MaterialBuilder materialBuilder = MaterialBuilder.create();
                materialBuilder.name((String)jsonObject.get(String.class, "name")).color((Integer)jsonObject.get(Integer.TYPE, "rgb")).armor((Boolean)jsonObject.get(Boolean.TYPE, "armor")).tools((Boolean)jsonObject.get(Boolean.TYPE, "tools")).weapons((Boolean)jsonObject.get(Boolean.TYPE, "weapons")).glowing((Boolean)jsonObject.get(Boolean.TYPE, "glowing")).oreFlower((Boolean)jsonObject.get(Boolean.TYPE, "oreFlower"));
                if (!jsonObject.containsKey((Object)"miningLevel")) {
                    materialBuilder.miningLevel(Rands.randInt(4));
                } else {
                    materialBuilder.miningLevel((Integer)jsonObject.get(Integer.TYPE, "miningLevel"));
                }
                if (((String)jsonObject.get(String.class, "nuggetTexture")).equals("null")) {
                    materialBuilder.nuggetTexture(null);
                } else {
                    materialBuilder.nuggetTexture(new class_2960((String)jsonObject.get(String.class, "nuggetTexture")));
                }
                if (!jsonObject.containsKey((Object)"food")) {
                    materialBuilder.food(Rands.chance(4));
                } else {
                    materialBuilder.food((Boolean)jsonObject.get(Boolean.TYPE, "food"));
                }
                if (((Boolean)jsonObject.get(Boolean.TYPE, "armor")).booleanValue()) {
                    materialBuilder.armor();
                }
                if (((Boolean)jsonObject.get(Boolean.TYPE, "tools")).booleanValue()) {
                    materialBuilder.tools();
                }
                if (((Boolean)jsonObject.get(Boolean.TYPE, "weapons")).booleanValue()) {
                    materialBuilder.weapons();
                }
                if (jsonObject.containsKey((Object)"oreInformationJSON")) {
                    JsonObject oreInfo = jsonObject.getObject("oreInformationJSON");
                    materialBuilder.oreType((OreTypes)((Object)oreInfo.get(OreTypes.class, "oreTypes"))).generatesIn((GeneratesIn)((Object)oreInfo.get(GeneratesIn.class, "generatesIn"))).overlayTexture(new class_2960((String)oreInfo.get(String.class, "overlayTexture"))).minXPAmount(0).maxXPAmount(Rands.randIntRange(0, 4)).oreClusterSize(Rands.randIntRange(2, 6));
                }
                if (OreTypes.METAL_ITEM_TEXTURES.contains(resourceItem = new class_2960((String)jsonObject.get(String.class, "resourceItemTexture"))) || OreTypes.CRYSTAL_ITEM_TEXTURES.contains(resourceItem) || OreTypes.GEM_ITEM_TEXTURES.contains(resourceItem)) {
                    materialBuilder.resourceItemTexture(resourceItem);
                } else {
                    materialBuilder.resourceItemTexture();
                }
                class_2960 storageBlock = new class_2960((String)jsonObject.get(String.class, "storageBlockTexture"));
                if (OreTypes.METAL_BLOCK_TEXTURES.contains(storageBlock) || OreTypes.CRYSTAL_BLOCK_TEXTURES.contains(storageBlock) || OreTypes.GEM_BLOCK_TEXTURES.contains(storageBlock)) {
                    materialBuilder.storageBlockTexture(storageBlock);
                } else {
                    materialBuilder.storageBlockTexture();
                }
                Material material = materialBuilder.buildFromJSON();
                String id = material.getName().toLowerCase();
                for (Map.Entry<String, String> entry : RandomlyAddingAnything.CONFIG.namingLanguage.getCharMap().entrySet()) {
                    id = id.replace(entry.getKey(), entry.getValue());
                }
                class_2378.method_10230(Materials.MATERIALS, (class_2960)new class_2960("raa", id), (Object)material);
            }
            SavingSystem.createFile();
        }
        catch (SyntaxError | FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static Material[] toJSON() {
        ArrayList materials = new ArrayList();
        Materials.MATERIALS.forEach(materials::add);
        return materials.toArray(new Material[0]);
    }

    static {
        configFilename = "materials";
        gson = DEFAULT_GSON;
        fileNumber = 0;
    }
}

