/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.materials;

import io.github.vampirestudios.raa.api.enums.GeneratesIn;
import io.github.vampirestudios.raa.api.enums.OreTypes;
import io.github.vampirestudios.raa.materials.CustomArmorMaterial;
import io.github.vampirestudios.raa.materials.CustomToolMaterial;
import io.github.vampirestudios.raa.materials.Material;
import io.github.vampirestudios.raa.materials.OreInformation;
import io.github.vampirestudios.raa.utils.Rands;
import net.minecraft.class_2960;

public class MaterialBuilder {
    private OreTypes oreType;
    private String name;
    private int RGB;
    private GeneratesIn generateIn;
    private int oreCount;
    private class_2960 overlayTexture;
    private class_2960 resourceItemTexture;
    private class_2960 storageBlockTexture;
    private class_2960 nuggetTexture;
    private CustomArmorMaterial armorMaterial;
    private CustomToolMaterial toolMaterial;
    private boolean armor;
    private boolean tools;
    private boolean weapons;
    private boolean glowing;
    private boolean oreFlower;
    private boolean food;
    private int minXPAmount = 0;
    private int maxXPAmount = 10;
    private int oreClusterSize = 9;
    private int miningLevel;

    public static MaterialBuilder create() {
        MaterialBuilder materialBuilder = new MaterialBuilder();
        materialBuilder.oreCount = Rands.randInt(19) + 1;
        materialBuilder.miningLevel = Rands.randInt(4);
        return materialBuilder;
    }

    public MaterialBuilder oreCount(int oreCount) {
        this.oreCount = oreCount;
        return this;
    }

    public MaterialBuilder miningLevel(int miningLevel) {
        this.miningLevel = miningLevel;
        return this;
    }

    public MaterialBuilder oreType(OreTypes oreType) {
        this.oreType = oreType;
        return this;
    }

    public MaterialBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MaterialBuilder color(int RGB) {
        this.RGB = RGB;
        return this;
    }

    public MaterialBuilder generatesIn(GeneratesIn generateIn) {
        this.generateIn = generateIn;
        return this;
    }

    public MaterialBuilder overlayTexture() {
        this.overlayTexture = this.oreType == OreTypes.METAL ? Rands.list(OreTypes.METAL_ORE_TEXTURES) : (this.oreType == OreTypes.GEM ? Rands.list(OreTypes.GEM_ORE_TEXTURES) : Rands.list(OreTypes.CRYSTAL_ORE_TEXTURES));
        return this;
    }

    public MaterialBuilder overlayTexture(class_2960 identifier) {
        this.overlayTexture = identifier;
        return this;
    }

    public MaterialBuilder nuggetTexture(class_2960 identifier) {
        this.nuggetTexture = identifier;
        return this;
    }

    public MaterialBuilder storageBlockTexture() {
        this.storageBlockTexture = this.oreType == OreTypes.METAL ? Rands.list(OreTypes.METAL_BLOCK_TEXTURES) : (this.oreType == OreTypes.GEM ? Rands.list(OreTypes.GEM_BLOCK_TEXTURES) : Rands.list(OreTypes.CRYSTAL_BLOCK_TEXTURES));
        return this;
    }

    public MaterialBuilder storageBlockTexture(class_2960 identifier) {
        this.storageBlockTexture = identifier;
        return this;
    }

    public MaterialBuilder resourceItemTexture() {
        this.resourceItemTexture = this.oreType == OreTypes.METAL ? Rands.list(OreTypes.METAL_ITEM_TEXTURES) : (this.oreType == OreTypes.GEM ? Rands.list(OreTypes.GEM_ITEM_TEXTURES) : Rands.list(OreTypes.CRYSTAL_ITEM_TEXTURES));
        return this;
    }

    public MaterialBuilder resourceItemTexture(class_2960 identifier) {
        this.resourceItemTexture = identifier;
        return this;
    }

    public MaterialBuilder armor(boolean armor) {
        this.armor = armor;
        return this;
    }

    public MaterialBuilder armor(CustomArmorMaterial armorMaterial) {
        this.armor = true;
        this.armorMaterial = armorMaterial;
        return this;
    }

    public MaterialBuilder armor() {
        this.armor = true;
        this.armorMaterial = new CustomArmorMaterial(this.name, this.oreType, Rands.randIntRange(2, 50), new int[]{Rands.randIntRange(1, 6), Rands.randIntRange(1, 10), Rands.randIntRange(2, 12), Rands.randIntRange(1, 6)}, Rands.randIntRange(7, 30), Rands.chance(4) ? Rands.randFloat(4.0f) : 0.0f, Rands.randInt(30));
        return this;
    }

    public MaterialBuilder tools(boolean tools) {
        this.tools = tools;
        return this;
    }

    public MaterialBuilder tools(CustomToolMaterial toolMaterial) {
        this.tools = true;
        this.toolMaterial = toolMaterial;
        return this;
    }

    public MaterialBuilder tools() {
        this.tools = true;
        this.toolMaterial = new CustomToolMaterial(this.name, this.oreType, Rands.randIntRange(15, 2000), Rands.randFloat(4.0f) + 1.5f, Rands.randFloat(3.0f), this.miningLevel, Rands.randIntRange(2, 10), Rands.randFloat(4.0f), Rands.randFloat(3.0f), Rands.randFloat(0.8f), Rands.randFloat(5.0f));
        return this;
    }

    public MaterialBuilder weapons(boolean weapons) {
        this.weapons = weapons;
        return this;
    }

    public MaterialBuilder weapons(CustomToolMaterial toolMaterial) {
        this.weapons = true;
        this.toolMaterial = toolMaterial;
        return this;
    }

    public MaterialBuilder weapons() {
        this.weapons = true;
        this.toolMaterial = new CustomToolMaterial(this.name, this.oreType, Rands.randIntRange(15, 2000), Rands.randFloat(4.0f) + 1.5f, Rands.randFloat(3.0f), this.miningLevel, Rands.randIntRange(2, 10), Rands.randFloat(4.0f), Rands.randFloat(3.0f), Rands.randFloat(0.8f), Rands.randFloat(5.0f));
        return this;
    }

    public MaterialBuilder glowing(boolean glowing) {
        this.glowing = glowing;
        return this;
    }

    public MaterialBuilder oreFlower(boolean oreFlower) {
        this.oreFlower = oreFlower;
        return this;
    }

    public MaterialBuilder food(boolean food) {
        this.food = food;
        return this;
    }

    public MaterialBuilder minXPAmount(int minXPAmount) {
        this.minXPAmount = minXPAmount;
        return this;
    }

    public MaterialBuilder maxXPAmount(int maxXPAmount) {
        this.maxXPAmount = maxXPAmount;
        return this;
    }

    public MaterialBuilder oreClusterSize(int oreClusterSize) {
        this.oreClusterSize = oreClusterSize;
        return this;
    }

    public Material build() {
        return this.oreType == OreTypes.METAL ? new Material(new OreInformation(this.oreType, this.generateIn, this.overlayTexture, this.oreCount, this.minXPAmount, this.maxXPAmount, this.oreClusterSize), this.name, this.RGB, this.miningLevel, this.storageBlockTexture, this.resourceItemTexture, Rands.list(OreTypes.METAL_NUGGET_TEXTURES), this.armor, this.tools, this.weapons, this.glowing, this.oreFlower, this.food) : new Material(new OreInformation(this.oreType, this.generateIn, this.overlayTexture, this.oreCount, this.minXPAmount, this.maxXPAmount, this.oreClusterSize), this.name, this.RGB, this.miningLevel, this.storageBlockTexture, this.resourceItemTexture, this.armor, this.tools, this.weapons, this.glowing, this.oreFlower, this.food);
    }

    public Material buildFromJSON() {
        return this.oreType == OreTypes.METAL ? new Material(new OreInformation(this.oreType, this.generateIn, this.overlayTexture, this.oreCount, this.minXPAmount, this.maxXPAmount, this.oreClusterSize), this.name, this.RGB, this.miningLevel, this.storageBlockTexture, this.resourceItemTexture, this.nuggetTexture, this.armor, this.armorMaterial, this.tools, this.weapons, this.toolMaterial, this.glowing, this.oreFlower, this.food) : new Material(new OreInformation(this.oreType, this.generateIn, this.overlayTexture, this.oreCount, this.minXPAmount, this.maxXPAmount, this.oreClusterSize), this.name, this.RGB, this.miningLevel, this.storageBlockTexture, this.resourceItemTexture, this.armor, this.armorMaterial, this.tools, this.weapons, this.toolMaterial, this.glowing, this.oreFlower, this.food);
    }
}

