/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.registries;

import io.github.vampirestudios.raa.RandomlyAddingAnything;
import io.github.vampirestudios.raa.api.enums.GeneratesIn;
import io.github.vampirestudios.raa.api.enums.OreTypes;
import io.github.vampirestudios.raa.blocks.LayeredOreBlock;
import io.github.vampirestudios.raa.client.Color;
import io.github.vampirestudios.raa.items.RAAArmorItem;
import io.github.vampirestudios.raa.items.RAAAxeItem;
import io.github.vampirestudios.raa.items.RAABlockItem;
import io.github.vampirestudios.raa.items.RAADebugItem;
import io.github.vampirestudios.raa.items.RAAFoodItem;
import io.github.vampirestudios.raa.items.RAAHoeItem;
import io.github.vampirestudios.raa.items.RAAHorseArmorItem;
import io.github.vampirestudios.raa.items.RAAPickaxeItem;
import io.github.vampirestudios.raa.items.RAAShovelItem;
import io.github.vampirestudios.raa.items.RAASimpleItem;
import io.github.vampirestudios.raa.items.RAASwordItem;
import io.github.vampirestudios.raa.materials.Material;
import io.github.vampirestudios.raa.materials.MaterialBuilder;
import io.github.vampirestudios.raa.utils.Rands;
import io.github.vampirestudios.raa.utils.RegistryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.block.FabricBlockSettings;
import net.fabricmc.fabric.api.tools.FabricToolTags;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4176;

public class Materials {
    public static final List<class_2960> MATERIAL_NAME_LIST = new ArrayList<class_2960>();
    public static final class_2378<Material> MATERIALS = new class_2348("materials");
    public static boolean isReady = false;
    public static final int[] BASE_DURABILITY = new int[]{13, 15, 16, 11};

    public static void init() {
        for (int a = 0; a < RandomlyAddingAnything.CONFIG.materialNumber; ++a) {
            Color RGB = new Color(Rands.randIntRange(0, 255), Rands.randIntRange(0, 255), Rands.randIntRange(0, 255));
            Random random = new Random();
            Material material = MaterialBuilder.create().oreType(Rands.values(OreTypes.values())).name(RandomlyAddingAnything.CONFIG.namingLanguage.generate()).color(RGB.getColor()).generatesIn(Rands.values(GeneratesIn.values())).overlayTexture().resourceItemTexture().storageBlockTexture().armor(random.nextBoolean()).tools(random.nextBoolean()).oreFlower(Rands.chance(4)).weapons(random.nextBoolean()).glowing(Rands.chance(4)).minXPAmount(0).maxXPAmount(Rands.randIntRange(0, 4)).oreClusterSize(Rands.randIntRange(2, 6)).food(Rands.chance(4)).build();
            String id = material.getName().toLowerCase();
            for (Map.Entry<String, String> entry : RandomlyAddingAnything.CONFIG.namingLanguage.getCharMap().entrySet()) {
                id = id.replace(entry.getKey(), entry.getValue());
            }
            if (!MATERIAL_NAME_LIST.contains(new class_2960("raa", id))) {
                class_2378.method_10230(MATERIALS, (class_2960)new class_2960("raa", id), (Object)material);
            }
            MATERIAL_NAME_LIST.add(new class_2960("raa", id));
            if (!RandomlyAddingAnything.CONFIG.debug) continue;
            System.out.println("\nName : " + material.getName() + "\nOre Type : " + material.getOreInformation().getOreType().name().toLowerCase() + "\nRGB color : " + RGB.getRed() + "," + RGB.getGreen() + "," + RGB.getBlue() + "\nGenerate in : " + material.getOreInformation().getGenerateIn().name().toLowerCase() + "\nOverlay Texture : " + material.getOreInformation().getOverlayTexture().toString() + "\nResource Item Texture : " + material.getResourceItemTexture().toString() + "\nHas Armor : " + material.hasArmor() + "\nHas Weapons : " + material.hasWeapons() + "\nHas Tools : " + material.hasTools() + "\nIs Glowing : " + material.isGlowing() + "\nHas Ore Flower : " + material.hasOreFlower() + "\nHas Food : " + material.hasFood());
        }
        isReady = true;
    }

    public static boolean isIsReady() {
        return isReady;
    }

    public static void createMaterialResources() {
        if (RandomlyAddingAnything.CONFIG.debug) {
            RegistryUtils.registerItem(new RAADebugItem(), new class_2960("raa", "debug_stick"));
        }
        MATERIALS.forEach(material -> {
            RAASimpleItem repairItem;
            String id = material.getName().toLowerCase();
            for (Map.Entry<String, String> entry : RandomlyAddingAnything.CONFIG.namingLanguage.getCharMap().entrySet()) {
                id = id.replace(entry.getKey(), entry.getValue());
            }
            FabricBlockSettings blockSettings = material.getOreInformation().getGenerateIn() == GeneratesIn.DOES_NOT_APPEAR ? FabricBlockSettings.copy((class_2248)class_2246.field_10340) : FabricBlockSettings.copy((class_2248)material.getOreInformation().getGenerateIn().getBlock());
            if (material.getOreInformation().getGenerateIn() == GeneratesIn.ANDESITE || material.getOreInformation().getGenerateIn() == GeneratesIn.DIORITE || material.getOreInformation().getGenerateIn() == GeneratesIn.END_STONE || material.getOreInformation().getGenerateIn() == GeneratesIn.GRANITE || material.getOreInformation().getGenerateIn() == GeneratesIn.NETHERRACK || material.getOreInformation().getGenerateIn() == GeneratesIn.STONE) {
                blockSettings.breakByTool(FabricToolTags.PICKAXES, material.getMiningLevel());
            } else {
                blockSettings.breakByTool(FabricToolTags.SHOVELS, material.getMiningLevel());
            }
            blockSettings.breakByHand(false);
            RegistryUtils.register(new class_2248(class_2248.class_2251.method_9630((class_2248)class_2246.field_10085)), new class_2960("raa", id + "_block"), RandomlyAddingAnything.RAA_RESOURCES, material.getName(), RAABlockItem.BlockType.BLOCK);
            RegistryUtils.register((class_2248)new LayeredOreBlock((Material)material, blockSettings.build()), new class_2960("raa", id + "_ore"), RandomlyAddingAnything.RAA_ORES, material.getName(), RAABlockItem.BlockType.ORE);
            if (material.getOreInformation().getOreType() == OreTypes.METAL) {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.INGOT);
                RegistryUtils.registerItem(repairItem, new class_2960("raa", id + "_ingot"));
                RegistryUtils.registerItem(new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.NUGGET), new class_2960("raa", id + "_nugget"));
            } else if (material.getOreInformation().getOreType() == OreTypes.GEM) {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.GEM);
                RegistryUtils.registerItem(repairItem, new class_2960("raa", id + "_gem"));
            } else {
                repairItem = new RAASimpleItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_RESOURCES), RAASimpleItem.SimpleItemType.CRYSTAL);
                RegistryUtils.registerItem(repairItem, new class_2960("raa", id + "_crystal"));
            }
            if (material.hasArmor()) {
                RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6169, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_helmet"));
                RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6174, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_chestplate"));
                RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6172, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_leggings"));
                RegistryUtils.registerItem((class_1792)new RAAArmorItem((Material)material, class_1304.field_6166, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_ARMOR).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_boots"));
                RegistryUtils.registerItem((class_1792)new RAAHorseArmorItem((Material)material), new class_2960("raa", id + "_horse_armor"));
            }
            if (material.hasTools()) {
                RegistryUtils.registerItem((class_1792)new RAAPickaxeItem((Material)material, material.getToolMaterial(), 1, -2.8f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_pickaxe"));
                RegistryUtils.registerItem((class_1792)new RAAAxeItem((Material)material, material.getToolMaterial(), 5.0f + material.getToolMaterial().getAxeAttackDamage(), -3.2f + material.getToolMaterial().getAxeAttackSpeed(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_axe"));
                RegistryUtils.registerItem((class_1792)new RAAShovelItem((Material)material, material.getToolMaterial(), 1.5f, -3.0f, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_shovel"));
                RegistryUtils.registerItem((class_1792)new RAAHoeItem((Material)material, material.getToolMaterial(), -3.0f + material.getToolMaterial().getHoeAttackSpeed(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_TOOLS).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_hoe"));
            }
            if (material.hasWeapons()) {
                RegistryUtils.registerItem((class_1792)new RAASwordItem((Material)material, new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_WEAPONS).method_7896((class_1792)repairItem)), new class_2960("raa", id + "_sword"));
            }
            if (material.hasFood()) {
                RegistryUtils.registerItem(new RAAFoodItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_FOOD).method_19265(class_4176.field_18658), RAAFoodItem.SimpleItemType.APPLE), new class_2960("raa", id + "_apple"));
                RegistryUtils.registerItem(new RAAFoodItem(material.getName(), new class_1792.class_1793().method_7892(RandomlyAddingAnything.RAA_FOOD).method_19265(class_4176.field_18659), RAAFoodItem.SimpleItemType.CARROT), new class_2960("raa", id + "_carrot"));
            }
        });
    }
}

