/*
 * Decompiled with CFR 0.152.
 */
package io.github.vampirestudios.raa.utils;

import io.github.vampirestudios.raa.utils.RegistryUtils;
import io.github.vampirestudios.vampirelib.blocks.ButtonBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.CustomLadderBlock;
import io.github.vampirestudios.vampirelib.blocks.DoorBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.FenceBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.FenceGateBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.LeavesBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.PressurePlateBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.SaplingBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.SlabBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.StairsBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.TrapdoorBaseBlock;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.block.FabricBlockSettings;
import net.fabricmc.fabric.api.client.render.ColorProviderRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2498;
import net.minecraft.class_2647;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3614;
import net.minecraft.class_3620;

public class WoodRegistry {
    public class_2960 name;
    private class_2248 log;
    private class_2248 wood;
    private class_2248 strippedLog;
    private class_2248 strippedWood;
    private class_2248 stairs;
    private class_2248 slab;
    private class_2248 planks;
    private class_2248 leaves;
    private class_2248 sapling;
    private class_2248 fence;
    private class_2248 fenceGate;
    private class_2248 bookshelf;
    private class_2248 door;
    private class_2248 trapdoor;
    private class_2248 button;
    private class_2248 pressurePlate;
    private class_2248 ladder;
    private class_2647 saplingGenerator;

    private WoodRegistry(class_2960 name, class_2647 saplingGenerator) {
        this.name = name;
        this.saplingGenerator = saplingGenerator;
    }

    private WoodRegistry(class_2960 name) {
        this.name = name;
        this.saplingGenerator = null;
    }

    public static Builder of(class_2960 name) {
        return new Builder().of(name);
    }

    public static Builder of(class_2960 name, class_2248 planks) {
        return new Builder().of(name, planks);
    }

    public static Builder of(class_2960 name, class_2647 saplingGenerator) {
        return new Builder().of(name, saplingGenerator);
    }

    public class_2248 getLog() {
        return this.log;
    }

    public class_2248 getWood() {
        return this.wood;
    }

    public class_2248 getStrippedLog() {
        return this.strippedLog;
    }

    public class_2248 getStrippedWood() {
        return this.strippedWood;
    }

    public class_2248 getStairs() {
        return this.stairs;
    }

    public class_2248 getSlab() {
        return this.slab;
    }

    public class_2248 getPlanks() {
        return this.planks;
    }

    public class_2248 getLeaves() {
        return this.leaves;
    }

    public class_2248 getSapling() {
        return this.sapling;
    }

    public class_2248 getFence() {
        return this.fence;
    }

    public class_2248 getFenceGate() {
        return this.fenceGate;
    }

    public class_2248 getBookshelf() {
        return this.bookshelf;
    }

    public class_2248 getDoor() {
        return this.door;
    }

    public class_2248 getTrapdoor() {
        return this.trapdoor;
    }

    public class_2248 getButton() {
        return this.button;
    }

    public class_2248 getPressurePlate() {
        return this.pressurePlate;
    }

    public class_2248 getLadder() {
        return this.ladder;
    }

    public static class Builder {
        public class_2960 name;
        private WoodRegistry woodRegistry;

        public Builder of(class_2960 name) {
            this.name = name;
            this.woodRegistry = new WoodRegistry(name);
            return this;
        }

        public Builder of(class_2960 name, class_2248 planks) {
            this.name = name;
            this.woodRegistry = new WoodRegistry(name);
            this.woodRegistry.planks = planks;
            return this;
        }

        public Builder of(class_2960 name, class_2647 saplingGenerator) {
            this.name = name;
            this.woodRegistry = new WoodRegistry(name, saplingGenerator);
            return this;
        }

        public Builder log() {
            this.woodRegistry.log = RegistryUtils.register((class_2248)new class_2465(FabricBlockSettings.of((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16017).hardness(2.0f).sounds(class_2498.field_11547).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_log"), class_1761.field_7931);
            return this;
        }

        public Builder wood() {
            this.woodRegistry.wood = RegistryUtils.register(new class_2248(FabricBlockSettings.of((class_3614)class_3614.field_15932, (class_3620)class_3620.field_15996).hardness(2.0f).sounds(class_2498.field_11547).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_wood"), class_1761.field_7931);
            return this;
        }

        public Builder strippedLog() {
            this.woodRegistry.strippedLog = RegistryUtils.register((class_2248)new class_2465(FabricBlockSettings.of((class_3614)class_3614.field_15932, (class_3620)class_3620.field_16017).hardness(2.0f).sounds(class_2498.field_11547).build()), new class_2960(this.name.method_12836(), "stripped_" + this.name.method_12832() + "_log"), class_1761.field_7931);
            return this;
        }

        public Builder strippedWood() {
            this.woodRegistry.strippedWood = RegistryUtils.register(new class_2248(FabricBlockSettings.of((class_3614)class_3614.field_15932, (class_3620)class_3620.field_15996).hardness(2.0f).sounds(class_2498.field_11547).build()), new class_2960(this.name.method_12836(), "stripped_" + this.name.method_12832() + "_wood"), class_1761.field_7931);
            return this;
        }

        public Builder stairs() {
            this.woodRegistry.stairs = RegistryUtils.register((class_2248)new StairsBaseBlock(this.woodRegistry.planks.method_9564()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_stairs"), class_1761.field_7931);
            return this;
        }

        public Builder slab() {
            this.woodRegistry.slab = RegistryUtils.register((class_2248)new SlabBaseBlock(FabricBlockSettings.copy((class_2248)this.woodRegistry.planks).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_slab"), class_1761.field_7931);
            return this;
        }

        public Builder planks() {
            this.woodRegistry.planks = RegistryUtils.register(new class_2248(FabricBlockSettings.of((class_3614)class_3614.field_15932, (class_3620)class_3620.field_15996).strength(2.0f, 3.0f).sounds(class_2498.field_11547).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_planks"), class_1761.field_7931);
            return this;
        }

        public Builder leaves() {
            this.woodRegistry.leaves = RegistryUtils.register((class_2248)new LeavesBaseBlock(), new class_2960(this.name.method_12836(), this.name.method_12832() + "_leaves"), class_1761.field_7928);
            return this;
        }

        public Builder leaves(String nameIn) {
            this.woodRegistry.leaves = RegistryUtils.register((class_2248)new LeavesBaseBlock(), new class_2960(this.name.method_12836(), nameIn + "_leaves"), class_1761.field_7928);
            return this;
        }

        public Builder coloredLeaves() {
            this.woodRegistry.leaves = RegistryUtils.register((class_2248)new LeavesBaseBlock(), new class_2960(this.name.method_12836(), this.name.method_12832() + "_leaves"), class_1761.field_7928);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ColorProviderRegistry.BLOCK.register((block, world, pos, layer) -> {
                    class_322 provider = (class_322)ColorProviderRegistry.BLOCK.get((Object)class_2246.field_10503);
                    return provider == null ? -1 : provider.getColor(block, world, pos, layer);
                }, (Object[])new class_2248[]{this.woodRegistry.leaves});
                ColorProviderRegistry.ITEM.register((item, layer) -> {
                    class_326 provider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10503);
                    return provider == null ? -1 : provider.getColor(item, layer);
                }, (Object[])new class_1935[]{this.woodRegistry.leaves});
            }
            return this;
        }

        public Builder sapling() {
            this.woodRegistry.sapling = RegistryUtils.register((class_2248)new SaplingBaseBlock(this.woodRegistry.saplingGenerator), new class_2960(this.name.method_12836(), this.name.method_12832() + "_sapling"), class_1761.field_7928);
            return this;
        }

        public Builder fence() {
            this.woodRegistry.fence = RegistryUtils.register((class_2248)new FenceBaseBlock(FabricBlockSettings.copy((class_2248)this.woodRegistry.planks).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_fence"), class_1761.field_7928);
            return this;
        }

        public Builder fenceGate() {
            this.woodRegistry.fenceGate = RegistryUtils.register((class_2248)new FenceGateBaseBlock(FabricBlockSettings.copy((class_2248)this.woodRegistry.planks).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_fence_gate"), class_1761.field_7914);
            return this;
        }

        public Builder bookshelf() {
            this.woodRegistry.bookshelf = RegistryUtils.register(new class_2248(class_2248.class_2251.method_9630((class_2248)this.woodRegistry.planks)), new class_2960(this.name.method_12836(), this.name.method_12832() + "_bookshelf"), class_1761.field_7931);
            return this;
        }

        public Builder door() {
            this.woodRegistry.door = RegistryUtils.register((class_2248)new DoorBaseBlock(FabricBlockSettings.copy((class_2248)this.woodRegistry.planks).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_door"), class_1761.field_7914);
            return this;
        }

        public Builder trapdoor() {
            this.woodRegistry.trapdoor = RegistryUtils.register((class_2248)new TrapdoorBaseBlock(FabricBlockSettings.copy((class_2248)this.woodRegistry.planks).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_trapdoor"), class_1761.field_7914);
            return this;
        }

        public Builder button() {
            this.woodRegistry.button = RegistryUtils.register((class_2248)new ButtonBaseBlock(true, FabricBlockSettings.copy((class_2248)this.woodRegistry.planks).build()), new class_2960(this.name.method_12836(), this.name.method_12832() + "_button"), class_1761.field_7914);
            return this;
        }

        public Builder pressurePlate(class_2440.class_2441 type) {
            this.woodRegistry.pressurePlate = RegistryUtils.register((class_2248)new PressurePlateBaseBlock(FabricBlockSettings.copy((class_2248)this.woodRegistry.planks).build(), type), new class_2960(this.name.method_12836(), this.name.method_12832() + "_pressure_plate"), class_1761.field_7914);
            return this;
        }

        public Builder ladder() {
            this.woodRegistry.ladder = RegistryUtils.register((class_2248)new CustomLadderBlock(), new class_2960(this.name.method_12836(), this.name.method_12832() + "_ladder"), class_1761.field_7928);
            return this;
        }

        public WoodRegistry build() {
            return this.woodRegistry;
        }
    }
}

