/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonReaderKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\fH\u0002J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\fJ\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0006\u0010%\u001a\u00020\u0014J.\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030(H\u0080\b\u00a2\u0006\u0002\b)J*\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00112\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030-H\u0080\b\u00a2\u0006\u0002\b.J\u0006\u0010/\u001a\u00020\u0014J\u0006\u00100\u001a\u00020\u0003J\b\u00101\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lkotlinx/serialization/json/internal/JsonReader;", "", "source", "", "(Ljava/lang/String;)V", "buf", "", "canBeginValue", "", "getCanBeginValue", "()Z", "currentPosition", "", "isDone", "length", "offset", "tokenClass", "", "tokenPosition", "append", "", "ch", "", "appendEsc", "startPosition", "appendHex", "startPos", "appendRange", "fromIndex", "toIndex", "fail", "", "message", "position", "fromHexChar", "nextLiteral", "nextString", "nextToken", "require", "condition", "Lkotlin/Function0;", "require$kotlinx_serialization_runtime", "requireTokenClass", "expected", "errorMessage", "Lkotlin/Function1;", "requireTokenClass$kotlinx_serialization_runtime", "skipElement", "takeString", "toString", "kotlinx-serialization-runtime"})
public final class JsonReader {
    @JvmField
    public int currentPosition;
    @JvmField
    public byte tokenClass;
    private int tokenPosition;
    private int offset;
    private int length;
    private char[] buf;
    private final String source;

    public final boolean isDone() {
        return this.tokenClass == 12;
    }

    public final boolean getCanBeginValue() {
        boolean bl;
        switch (this.tokenClass) {
            case 0: 
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final void requireTokenClass$kotlinx_serialization_runtime(byte expected, @NotNull Function1<? super Character, String> errorMessage) {
        int $i$f$requireTokenClass$kotlinx_serialization_runtime = 0;
        Intrinsics.checkParameterIsNotNull(errorMessage, "errorMessage");
        if (this.tokenClass != expected) {
            Void void_ = this.fail(errorMessage.invoke(Character.valueOf((char)this.tokenClass)), this.tokenPosition);
            throw null;
        }
    }

    @NotNull
    public final String takeString() {
        String string;
        boolean bl;
        int n;
        int n2;
        Object object;
        if (this.tokenClass != 0 && this.tokenClass != 1) {
            Void void_ = this.fail("Expected string or non-null literal", this.tokenPosition);
            throw null;
        }
        if (this.offset < 0) {
            object = this.buf;
            n2 = 0;
            n = this.length;
            bl = false;
            string = new String((char[])object, n2, n);
        } else {
            object = this.source;
            n2 = this.offset;
            n = this.offset + this.length;
            bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object2).substring(n2, n);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        String prevStr = string;
        this.nextToken();
        return prevStr;
    }

    private final void append(char ch) {
        if (this.length >= this.buf.length) {
            char[] cArray = this.buf;
            int n = 2 * this.buf.length;
            JsonReader jsonReader = this;
            boolean bl = false;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkExpressionValueIsNotNull(cArray2, "java.util.Arrays.copyOf(this, newSize)");
            char[] cArray3 = cArray2;
            jsonReader.buf = cArray3;
        }
        int n = this.length;
        this.length = n + 1;
        this.buf[n] = ch;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendRange(String source, int fromIndex, int toIndex) {
        int n;
        int oldLen = this.length;
        int addLen = toIndex - fromIndex;
        int newLen = oldLen + addLen;
        if (newLen > this.buf.length) {
            char[] cArray = this.buf;
            n = RangesKt.coerceAtLeast(newLen, 2 * this.buf.length);
            JsonReader jsonReader = this;
            boolean bl = false;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkExpressionValueIsNotNull(cArray2, "java.util.Arrays.copyOf(this, newSize)");
            char[] cArray3 = cArray2;
            jsonReader.buf = cArray3;
        }
        int n2 = 0;
        n = addLen;
        while (n2 < n) {
            void i2;
            this.buf[oldLen + i2] = source.charAt(fromIndex + i2);
            ++i2;
        }
        this.length += addLen;
    }

    public final void nextToken() {
        int currentPosition;
        String source = this.source;
        for (currentPosition = this.currentPosition; currentPosition < source.length(); ++currentPosition) {
            char ch = source.charAt(currentPosition);
            byte tc = JsonReaderKt.charToTokenClass(ch);
            if (tc == 3) {
                continue;
            }
            if (tc == 0) {
                this.nextLiteral(source, currentPosition);
                return;
            }
            if (tc == 1) {
                this.nextString(source, currentPosition);
                return;
            }
            this.tokenPosition = currentPosition;
            this.tokenClass = tc;
            this.currentPosition = currentPosition + 1;
            return;
        }
        this.tokenPosition = currentPosition;
        this.tokenClass = (byte)12;
    }

    private final void nextLiteral(String source, int startPos) {
        int currentPosition;
        this.tokenPosition = startPos;
        this.offset = startPos;
        for (currentPosition = startPos; currentPosition < source.length() && JsonReaderKt.charToTokenClass(source.charAt(currentPosition)) == 0; ++currentPosition) {
        }
        this.currentPosition = currentPosition;
        this.length = currentPosition - this.offset;
        this.tokenClass = (byte)(JsonReaderKt.access$rangeEquals(source, this.offset, this.length, "null") ? 10 : 0);
    }

    private final void nextString(String source, int startPosition) {
        int currentPosition;
        this.tokenPosition = startPosition;
        this.length = 0;
        int lastPosition = currentPosition = startPosition + 1;
        int length = source.length();
        while (source.charAt(currentPosition) != '\"') {
            if (currentPosition >= length) {
                Void void_ = this.fail("Unexpected EOF", currentPosition);
                throw null;
            }
            if (source.charAt(currentPosition) == '\\') {
                int newPosition;
                this.appendRange(source, lastPosition, currentPosition);
                currentPosition = newPosition = this.appendEsc(source, currentPosition + 1);
                lastPosition = newPosition;
                continue;
            }
            ++currentPosition;
        }
        if (lastPosition == startPosition + 1) {
            this.offset = lastPosition;
            this.length = currentPosition - lastPosition;
        } else {
            this.appendRange(source, lastPosition, currentPosition);
            this.offset = -1;
        }
        this.currentPosition = currentPosition + 1;
        this.tokenClass = 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int appendEsc(String source, int startPosition) {
        char currentChar;
        int currentPosition = startPosition;
        JsonReader jsonReader = this;
        boolean condition$iv = currentPosition < source.length();
        boolean $i$f$require$kotlinx_serialization_runtime22 = false;
        if (!condition$iv) {
            void this_$iv;
            void var10_9 = this_$iv;
            boolean bl = false;
            String string = "Unexpected EOF after escape character";
            Void void_ = var10_9.fail(string, currentPosition);
            throw null;
        }
        if ((currentChar = source.charAt(currentPosition++)) == 'u') {
            return this.appendHex(source, currentPosition);
        }
        char c = JsonReaderKt.escapeToChar(currentChar);
        JsonReader $i$f$require$kotlinx_serialization_runtime22 = this;
        boolean condition$iv2 = c != '\u0000';
        boolean $i$f$require$kotlinx_serialization_runtime = false;
        if (!condition$iv2) {
            void this_$iv;
            void var10_10 = this_$iv;
            boolean bl = false;
            String string = "Invalid escaped char '" + currentChar + '\'';
            Void void_ = var10_10.fail(string, currentPosition);
            throw null;
        }
        this.append(c);
        return currentPosition;
    }

    private final int appendHex(String source, int startPos) {
        int curPos = startPos;
        this.append((char)((this.fromHexChar(source, curPos++) << 12) + (this.fromHexChar(source, curPos++) << 8) + (this.fromHexChar(source, curPos++) << 4) + this.fromHexChar(source, curPos++)));
        return curPos;
    }

    public final void skipElement() {
        Collection collection;
        if (this.tokenClass != 6 && this.tokenClass != 8) {
            this.nextToken();
            return;
        }
        boolean bl = false;
        List tokenStack = new ArrayList();
        do {
            switch (this.tokenClass) {
                case 6: 
                case 8: {
                    tokenStack.add(this.tokenClass);
                    break;
                }
                case 9: {
                    if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 8) {
                        throw (Throwable)new JsonDecodingException(this.currentPosition, "found ] instead of }");
                    }
                    tokenStack.remove(tokenStack.size() - 1);
                    break;
                }
                case 7: {
                    if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 6) {
                        throw (Throwable)new JsonDecodingException(this.currentPosition, "found } instead of ]");
                    }
                    tokenStack.remove(tokenStack.size() - 1);
                }
            }
            this.nextToken();
            collection = tokenStack;
            boolean bl2 = false;
        } while (!collection.isEmpty());
    }

    @NotNull
    public String toString() {
        return "JsonReader(source='" + this.source + "', currentPosition=" + this.currentPosition + ", tokenClass=" + this.tokenClass + ", tokenPosition=" + this.tokenPosition + ", offset=" + this.offset + ')';
    }

    @NotNull
    public final Void fail(@NotNull String message, int position) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        throw (Throwable)new JsonDecodingException(position, message);
    }

    public static /* synthetic */ Void fail$default(JsonReader jsonReader, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = jsonReader.currentPosition;
        }
        return jsonReader.fail(string, n);
    }

    public final void require$kotlinx_serialization_runtime(boolean condition, int position, @NotNull Function0<String> message) {
        int $i$f$require$kotlinx_serialization_runtime = 0;
        Intrinsics.checkParameterIsNotNull(message, "message");
        if (!condition) {
            Void void_ = this.fail(message.invoke(), position);
            throw null;
        }
    }

    public static /* synthetic */ void require$kotlinx_serialization_runtime$default(JsonReader this_, boolean condition, int position, Function0 message, int n, Object object) {
        if ((n & 2) != 0) {
            position = this_.currentPosition;
        }
        boolean $i$f$require$kotlinx_serialization_runtime = false;
        Intrinsics.checkParameterIsNotNull(message, "message");
        if (!condition) {
            Void void_ = this_.fail((String)message.invoke(), position);
            throw null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int fromHexChar(String source, int currentPosition) {
        int n;
        JsonReader jsonReader = this;
        boolean condition$iv = currentPosition < source.length();
        boolean $i$f$require$kotlinx_serialization_runtime = false;
        if (!condition$iv) {
            void this_$iv;
            void var7_7 = this_$iv;
            boolean bl = false;
            String string = "Unexpected EOF during unicode escape";
            Void void_ = var7_7.fail(string, currentPosition);
            throw null;
        }
        char curChar = source.charAt(currentPosition);
        char c = curChar;
        if ('0' <= c && '9' >= c) {
            n = curChar - 48;
        } else {
            c = curChar;
            if ('a' <= c && 'f' >= c) {
                n = curChar - 97 + 10;
            } else {
                c = curChar;
                if ('A' <= c && 'F' >= c) {
                    n = curChar - 65 + 10;
                } else {
                    Void void_ = JsonReader.fail$default(this, "Invalid toHexChar char '" + curChar + "' in unicode escape", 0, 2, null);
                    throw null;
                }
            }
        }
        return n;
    }

    public JsonReader(@NotNull String source) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        this.source = source;
        this.tokenClass = (byte)12;
        this.offset = -1;
        this.buf = new char[16];
        this.nextToken();
    }

    public static final /* synthetic */ void access$setTokenPosition$p(JsonReader $this, int n) {
        $this.tokenPosition = n;
    }
}

