/*
 * Decompiled with CFR 0.152.
 */
package com.mairwunnx.randomteleport;

import com.mairwunnx.projectessentials.permissions.permissions.PermissionsAPI;
import com.mairwunnx.randomteleport.commands.BadLocationCommand;
import com.mairwunnx.randomteleport.commands.RandomTeleportCommand;
import com.mairwunnx.randomteleport.managers.ConfigurationManager;
import com.mojang.brigadier.CommandDispatcher;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="random_teleport")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\fH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/mairwunnx/randomteleport/EntryPoint;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "loadAdditionalModules", "", "onServerStarting", "it", "Lnet/minecraftforge/fml/event/server/FMLServerStartingEvent;", "onServerStopping", "Lnet/minecraftforge/fml/event/server/FMLServerStoppingEvent;", "Companion", "Random Teleport-Forge"})
public final class EntryPoint {
    private final Logger logger = LogManager.getLogger();
    private static final String permissionAPIClassPath = "com.mairwunnx.projectessentials.permissions.permissions.PermissionsAPI";
    private static final String cooldownAPIClassPath = "com.mairwunnx.projectessentials.cooldown.essentials.CooldownAPI";
    private static boolean permissionsInstalled;
    private static boolean cooldownInstalled;
    public static final Companion Companion;

    private final void loadAdditionalModules() {
        if (ConfigurationManager.INSTANCE.get().getInteractWithEssentials()) {
            try {
                Class.forName(permissionAPIClassPath);
                permissionsInstalled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                Class.forName(cooldownAPIClassPath);
                cooldownInstalled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public final void onServerStarting(@NotNull FMLServerStartingEvent it) {
        Intrinsics.checkParameterIsNotNull(it, "it");
        this.logger.info("Commands registering starting for Random Teleport");
        CommandDispatcher commandDispatcher = it.getCommandDispatcher();
        Intrinsics.checkExpressionValueIsNotNull(commandDispatcher, "it.commandDispatcher");
        RandomTeleportCommand.INSTANCE.register((CommandDispatcher<CommandSource>)commandDispatcher);
        CommandDispatcher commandDispatcher2 = it.getCommandDispatcher();
        Intrinsics.checkExpressionValueIsNotNull(commandDispatcher2, "it.commandDispatcher");
        BadLocationCommand.INSTANCE.register((CommandDispatcher<CommandSource>)commandDispatcher2);
    }

    @SubscribeEvent
    public final void onServerStopping(@NotNull FMLServerStoppingEvent it) {
        Intrinsics.checkParameterIsNotNull(it, "it");
        ConfigurationManager.INSTANCE.save();
    }

    public EntryPoint() {
        this.logger.info("Random Teleport mod initializing");
        ConfigurationManager.INSTANCE.load();
        this.loadAdditionalModules();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$setPermissionsInstalled$cp(boolean bl) {
        permissionsInstalled = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/mairwunnx/randomteleport/EntryPoint$Companion;", "", "()V", "cooldownAPIClassPath", "", "cooldownInstalled", "", "getCooldownInstalled", "()Z", "setCooldownInstalled", "(Z)V", "permissionAPIClassPath", "permissionsInstalled", "hasPermission", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "node", "opLevel", "", "hasPermission$Random_Teleport_Forge", "Random Teleport-Forge"})
    public static final class Companion {
        public final boolean getCooldownInstalled() {
            return cooldownInstalled;
        }

        public final void setCooldownInstalled(boolean bl) {
            cooldownInstalled = bl;
        }

        public final boolean hasPermission$Random_Teleport_Forge(@NotNull ServerPlayerEntity player, @NotNull String node, int opLevel) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(player, "player");
            Intrinsics.checkParameterIsNotNull(node, "node");
            if (permissionsInstalled) {
                ITextComponent iTextComponent = player.func_200200_C_();
                Intrinsics.checkExpressionValueIsNotNull(iTextComponent, "player.name");
                String string = iTextComponent.getString();
                Intrinsics.checkExpressionValueIsNotNull(string, "player.name.string");
                bl = PermissionsAPI.hasPermission$default((PermissionsAPI)PermissionsAPI.INSTANCE, (String)string, (String)node, (boolean)false, (int)4, null);
            } else {
                MinecraftServer minecraftServer = player.field_71133_b;
                Intrinsics.checkExpressionValueIsNotNull(minecraftServer, "player.server");
                bl = minecraftServer.func_110455_j() >= opLevel;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

