/*
 * Decompiled with CFR 0.152.
 */
package com.mairwunnx.randomteleport.managers;

import com.mairwunnx.randomteleport.configuration.ConfigurationModel;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/mairwunnx/randomteleport/managers/ConfigurationManager;", "", "()V", "configuration", "Lcom/mairwunnx/randomteleport/configuration/ConfigurationModel;", "configurationDir", "", "configurationPath", "jsonInstance", "Lkotlinx/serialization/json/Json;", "jsonInstance$annotations", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "get", "load", "", "save", "Random Teleport-Forge"})
public final class ConfigurationManager {
    private static final String configurationDir;
    private static final String configurationPath;
    private static ConfigurationModel configuration;
    private static final Logger logger;
    private static final Json jsonInstance;
    public static final ConfigurationManager INSTANCE;

    private static /* synthetic */ void jsonInstance$annotations() {
    }

    public final void load() {
        logger.info("Loading random teleport configuration");
        if (!new File(configurationPath).exists()) {
            logger.warn("Random teleport config not exist! creating it now!");
            new File(configurationDir).mkdirs();
            String defaultConfig = jsonInstance.stringify((SerializationStrategy)ConfigurationModel.Companion.serializer(), configuration);
            FilesKt.writeText$default(new File(configurationPath), defaultConfig, null, 2, null);
        }
        configuration = (ConfigurationModel)jsonInstance.parse(ConfigurationModel.Companion.serializer(), FilesKt.readText$default(new File(configurationPath), null, 1, null));
    }

    public final void save() {
        logger.info("Saving random teleport configuration");
        new File(configurationDir).mkdirs();
        String configurationRaw = jsonInstance.stringify((SerializationStrategy)ConfigurationModel.Companion.serializer(), configuration);
        FilesKt.writeText$default(new File(configurationPath), configurationRaw, null, 2, null);
    }

    @NotNull
    public final ConfigurationModel get() {
        return configuration;
    }

    private ConfigurationManager() {
    }

    static {
        ConfigurationManager configurationManager;
        INSTANCE = configurationManager = new ConfigurationManager();
        configurationDir = new File(".").getAbsolutePath() + File.separator + "config";
        configurationPath = configurationDir + File.separator + "random-teleport.json";
        configuration = new ConfigurationModel(false, 0, 0, null, false, false, 0, 0, 255, null);
        logger = LogManager.getLogger();
        jsonInstance = new Json(new JsonConfiguration(true, true, false, false, true, true, false, null, false, null, null, 1664, null), null, 2, null);
    }
}

