/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import kotlinx.serialization.Serializer;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializerKt;
import kotlinx.serialization.json.JsonExceptionsKt;
import kotlinx.serialization.json.JsonLiteral;
import org.jetbrains.annotations.NotNull;

@Serializer(forClass=JsonLiteral.class)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/json/JsonLiteralSerializer;", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/json/JsonLiteral;", "()V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "kotlinx-serialization-runtime"})
public final class JsonLiteralSerializer
implements KSerializer<JsonLiteral> {
    @NotNull
    private static final SerialDescriptor descriptor;
    public static final JsonLiteralSerializer INSTANCE;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull JsonLiteral value) {
        Intrinsics.checkParameterIsNotNull(encoder2, "encoder");
        Intrinsics.checkParameterIsNotNull(value, "value");
        JsonElementSerializerKt.access$verify(encoder2);
        if (value.isString()) {
            encoder2.encodeString(value.getContent());
            return;
        }
        Long l = value.getLongOrNull();
        if (l != null) {
            encoder2.encodeLong(l);
            return;
        }
        Double d = value.getDoubleOrNull();
        if (d != null) {
            encoder2.encodeDouble(d);
            return;
        }
        Boolean bl = value.getBooleanOrNull();
        if (bl != null) {
            encoder2.encodeBoolean(bl);
            return;
        }
        encoder2.encodeString(value.getContent());
    }

    @Override
    @NotNull
    public JsonLiteral deserialize(@NotNull Decoder decoder2) {
        Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
        JsonElement result = JsonElementSerializerKt.asJsonInput(decoder2).decodeJson();
        if (!(result instanceof JsonLiteral)) {
            throw (Throwable)JsonExceptionsKt.JsonDecodingException(-1, "Unexpected JSON element, expected JsonLiteral, had " + Reflection.getOrCreateKotlinClass(result.getClass()), result.toString());
        }
        return (JsonLiteral)result;
    }

    private JsonLiteralSerializer() {
    }

    static {
        JsonLiteralSerializer jsonLiteralSerializer;
        INSTANCE = jsonLiteralSerializer = new JsonLiteralSerializer();
        descriptor = SerialDescriptorBuilderKt.PrimitiveDescriptor("kotlinx.serialization.json.JsonLiteral", PrimitiveKind.STRING.INSTANCE);
    }

    @Override
    @NotNull
    public JsonLiteral patch(@NotNull Decoder decoder2, @NotNull JsonLiteral old) {
        Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
        Intrinsics.checkParameterIsNotNull(old, "old");
        return KSerializer.DefaultImpls.patch(this, decoder2, old);
    }
}

