/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PlatformUtilsKt;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.internal.AbstractPolymorphicSerializerKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializerKt;
import kotlinx.serialization.json.JsonInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00032\u0006\u0010\u0010\u001a\u00020\u0011H$J\u001b\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lkotlinx/serialization/json/JsonParametricSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "baseClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Ljava/lang/Object;", "selectSerializer", "element", "Lkotlinx/serialization/json/JsonElement;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "(Lkotlinx/serialization/Encoder;Ljava/lang/Object;)V", "kotlinx-serialization-runtime"})
public abstract class JsonParametricSerializer<T>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    private final KClass<T> baseClass;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        KSerializer<T> actualSerializer;
        Intrinsics.checkParameterIsNotNull(encoder2, "encoder");
        Intrinsics.checkParameterIsNotNull(value, "value");
        KSerializer<T> kSerializer = encoder2.getContext().getPolymorphic(this.baseClass, value);
        if (kSerializer == null) {
            kSerializer = PlatformUtilsKt.serializerOrNull(Reflection.getOrCreateKotlinClass(value.getClass()));
        }
        if (kSerializer == null) {
            Void void_ = AbstractPolymorphicSerializerKt.throwSubtypeNotRegistered(Reflection.getOrCreateKotlinClass(value.getClass()), this.baseClass);
            throw null;
        }
        KSerializer<T> kSerializer2 = actualSerializer = kSerializer;
        if (kSerializer2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        kSerializer2.serialize(encoder2, value);
    }

    @Override
    @NotNull
    public final T deserialize(@NotNull Decoder decoder2) {
        Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
        JsonInput input = JsonElementSerializerKt.asJsonInput(decoder2);
        JsonElement tree = input.decodeJson();
        KSerializer<T> kSerializer = this.selectSerializer(tree);
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        KSerializer<T> actualSerializer = kSerializer;
        return input.getJson().fromJson(actualSerializer, tree);
    }

    @NotNull
    protected abstract KSerializer<? extends T> selectSerializer(@NotNull JsonElement var1);

    public JsonParametricSerializer(@NotNull KClass<T> baseClass) {
        Intrinsics.checkParameterIsNotNull(baseClass, "baseClass");
        this.baseClass = baseClass;
        this.descriptor = SerialDescriptorBuilderKt.SerialDescriptor$default("JsonParametricSerializer<" + SerializationKt.simpleName(this.baseClass) + '>', PolymorphicKind.OPEN.INSTANCE, null, 4, null);
    }

    @Override
    @NotNull
    public T patch(@NotNull Decoder decoder2, @NotNull T old) {
        Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
        Intrinsics.checkParameterIsNotNull(old, "old");
        return KSerializer.DefaultImpls.patch(this, decoder2, old);
    }
}

