/*
 * Decompiled with CFR 0.152.
 */
package io.github.jdiemke.triangulation;

import java.util.Objects;

public class Vector2D {
    public double x;
    public double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D sub(Vector2D vector) {
        return new Vector2D(this.x - vector.x, this.y - vector.y);
    }

    public Vector2D add(Vector2D vector) {
        return new Vector2D(this.x + vector.x, this.y + vector.y);
    }

    public Vector2D mult(double scalar) {
        return new Vector2D(this.x * scalar, this.y * scalar);
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double dot(Vector2D vector) {
        return this.x * vector.x + this.y * vector.y;
    }

    public double cross(Vector2D vector) {
        return this.y * vector.x - this.x * vector.y;
    }

    public String toString() {
        return "Vector2D[" + this.x + ", " + this.y + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector2D vector2D = (Vector2D)o;
        return Double.compare(vector2D.x, this.x) == 0 && Double.compare(vector2D.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

