/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.capabilities.iteminventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import piman.recievermod.inventory.AmmoContainerInventory;

public class ItemInventory
implements ICapabilitySerializable<INBT> {
    private AmmoContainerInventory inventory;
    private LazyOptional<IItemHandler> optional = LazyOptional.of(() -> new InvWrapper((IInventory)this.inventory));

    public ItemInventory(int size) {
        this.inventory = new AmmoContainerInventory(size);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.optional.cast() : LazyOptional.empty();
    }

    public INBT serializeNBT() {
        return this.inventory.serialize();
    }

    public void deserializeNBT(INBT nbt) {
        this.inventory.deserialize((CompoundNBT)nbt);
    }

    public static CompoundNBT saveAllItems(CompoundNBT tag, NonNullList<ItemStack> list, boolean saveEmpty) {
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = (ItemStack)list.get(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            ItemInventory.writeItemStack(compoundnbt, itemstack);
            listnbt.add((Object)compoundnbt);
        }
        if (!listnbt.isEmpty() || saveEmpty) {
            tag.func_218657_a("Items", (INBT)listnbt);
        }
        return tag;
    }

    public static void loadAllItems(CompoundNBT tag, NonNullList<ItemStack> list) {
        ListNBT listnbt = tag.func_150295_c("Items", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= list.size()) continue;
            list.set(j, (Object)ItemInventory.readItemStack(compoundnbt));
        }
    }

    public static CompoundNBT writeItemStack(CompoundNBT nbt, ItemStack stack) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b());
        nbt.func_74778_a("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        nbt.func_74768_a("Count", stack.func_190916_E());
        if (stack.func_77978_p() != null) {
            nbt.func_218657_a("tag", (INBT)stack.func_77978_p());
        }
        return nbt;
    }

    private static ItemStack readItemStack(CompoundNBT compound) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i("id")));
        int count = compound.func_74762_e("Count");
        ItemStack stack = new ItemStack((IItemProvider)item, count);
        if (compound.func_150297_b("tag", 10)) {
            CompoundNBT tag = compound.func_74775_l("tag");
            item.func_179215_a(compound);
            stack.func_77982_d(tag);
        }
        if (item.func_77645_m()) {
            stack.func_196085_b(stack.func_77952_i());
        }
        return stack;
    }
}

