/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedGunModel
implements IBakedModel {
    private final IUnbakedModel parent;
    private final List<IBakedModel> models;
    private List<BakedQuad> quads = new ArrayList<BakedQuad>();
    private Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private List<TRSRTransformation> subTransforms = new ArrayList<TRSRTransformation>();
    private final TextureAtlasSprite particle;
    private final ItemOverrideList overrides;
    private final List<IBakedModel> accessoryModels = new ArrayList<IBakedModel>();

    public BakedGunModel(IUnbakedModel parent, List<IBakedModel> models, Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, TextureAtlasSprite particle, VertexFormat format, ItemOverrideList overrides, Map<String, IBakedModel> cache) {
        this.parent = parent;
        this.models = models;
        this.transforms = transforms;
        this.particle = particle;
        this.overrides = overrides;
    }

    public void setSubTransforms(List<TRSRTransformation> subTransformations) {
        this.subTransforms = new ArrayList<TRSRTransformation>();
        this.subTransforms.add(TRSRTransformation.identity());
        this.subTransforms.addAll(subTransformations);
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(BlockState state, Direction side, @Nonnull Random rand) {
        this.quads.clear();
        if (this.subTransforms == null) {
            return this.quads;
        }
        if (this.subTransforms.size() <= this.models.size()) {
            for (int i = 0; i < this.subTransforms.size(); ++i) {
                for (BakedQuad quad : this.models.get(i).func_200117_a(state, side, rand)) {
                    Matrix4f transformation = this.subTransforms.get(i).getMatrixVec();
                    if (transformation.equals(TRSRTransformation.identity().getMatrixVec())) {
                        this.quads.add(quad);
                        continue;
                    }
                    int[] data = (int[])quad.func_178209_a().clone();
                    Matrix4f points = new Matrix4f();
                    points.m00 = Float.intBitsToFloat(data[0]);
                    points.m10 = Float.intBitsToFloat(data[1]);
                    points.m20 = Float.intBitsToFloat(data[2]);
                    points.m30 = 1.0f;
                    points.m01 = Float.intBitsToFloat(data[7]);
                    points.m11 = Float.intBitsToFloat(data[8]);
                    points.m21 = Float.intBitsToFloat(data[9]);
                    points.m31 = 1.0f;
                    points.m02 = Float.intBitsToFloat(data[14]);
                    points.m12 = Float.intBitsToFloat(data[15]);
                    points.m22 = Float.intBitsToFloat(data[16]);
                    points.m32 = 1.0f;
                    points.m03 = Float.intBitsToFloat(data[21]);
                    points.m13 = Float.intBitsToFloat(data[22]);
                    points.m23 = Float.intBitsToFloat(data[23]);
                    points.m33 = 1.0f;
                    points.mul(transformation, points);
                    data[0] = Float.floatToRawIntBits(points.m00);
                    data[1] = Float.floatToRawIntBits(points.m10);
                    data[2] = Float.floatToRawIntBits(points.m20);
                    data[7] = Float.floatToRawIntBits(points.m01);
                    data[8] = Float.floatToRawIntBits(points.m11);
                    data[9] = Float.floatToRawIntBits(points.m21);
                    data[14] = Float.floatToRawIntBits(points.m02);
                    data[15] = Float.floatToRawIntBits(points.m12);
                    data[16] = Float.floatToRawIntBits(points.m22);
                    data[21] = Float.floatToRawIntBits(points.m03);
                    data[22] = Float.floatToRawIntBits(points.m13);
                    data[23] = Float.floatToRawIntBits(points.m23);
                    ForgeHooksClient.fillNormal((int[])data, null);
                    BakedQuad newQuad = new BakedQuad(data, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
                    this.quads.add(newQuad);
                }
            }
        }
        if (this.quads.size() > 0) {
            // empty if block
        }
        return this.quads;
    }

    private int calculateNormal(Matrix4f points) {
        float xp = points.m03 - points.m01;
        float yp = points.m13 - points.m11;
        float zp = points.m23 - points.m21;
        float xq = points.m02 - points.m00;
        float yq = points.m12 - points.m10;
        float zq = points.m22 - points.m20;
        float xn = yq * zp - zq * yp;
        float yn = zq * xp - xq * zp;
        float zn = xq * yp - yq * xp;
        float norm = (float)Math.sqrt(xn * xn + yn * yn + zn * zn);
        float SMALL_LENGTH = 1.0E-4f;
        if (norm < 1.0E-4f) {
            norm = 1.0f;
        }
        norm = 1.0f / norm;
        int x = (byte)((xn *= norm) * 127.0f) & 0xFF;
        int y = (byte)((yn *= norm) * 127.0f) & 0xFF;
        int z = (byte)((zn *= norm) * 127.0f) & 0xFF;
        return x | y << 8 | z << 16;
    }

    public IUnbakedModel getParent() {
        return this.parent;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.models.get(0).func_177552_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)ImmutableMap.copyOf(this.transforms), (ItemCameraTransforms.TransformType)type);
    }

    public void setCameraTransforms(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        this.transforms = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>((Map<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms);
    }
}

