/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.item.Item;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.AnimationStateMachine;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import piman.recievermod.client.renderer.model.NormalModelLoader;

public class ModelLoaderRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ICustomModelLoader> loaders = Sets.newHashSet();
    private static final Map<ResourceLocation, IUnbakedModel> cache = Maps.newHashMap();
    private static final Deque<ResourceLocation> loadingModels = Queues.newArrayDeque();
    private static final Map<Item, ResourceLocation> registeredItems = new HashMap<Item, ResourceLocation>();
    private static ModelBakery bakery;
    private static IResourceManager manager;

    public static void registerLoader(ICustomModelLoader loader) {
        loaders.add(loader);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)loader);
        loader.func_195410_a(Minecraft.func_71410_x().func_195551_G());
    }

    public static void registerItems(Map<Item, ResourceLocation> map) {
        registeredItems.putAll(map);
    }

    public static boolean loaded(ResourceLocation location) {
        return cache.containsKey(location);
    }

    public static IUnbakedModel getLoaded(ResourceLocation location) {
        return cache.get(location);
    }

    public static Map<ResourceLocation, IUnbakedModel> getUnbakedModels() {
        return ImmutableMap.copyOf(cache);
    }

    public static ResourceLocation getActualLocation(ResourceLocation location) {
        if (location instanceof ModelResourceLocation) {
            return location;
        }
        if (location.func_110623_a().startsWith("builtin/")) {
            return location;
        }
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUnbakedModel getModel(Map.Entry<ResourceLocation, Item> entry) throws Exception {
        IUnbakedModel model;
        block16: {
            IUnbakedModel cached = cache.get(new ModelResourceLocation(entry.getKey(), "inventory"));
            if (cached != null) {
                return cached;
            }
            ModelResourceLocation location = entry.getValue() == null ? new ModelResourceLocation(entry.getKey(), "inventory") : registeredItems.get(entry.getValue());
            for (ResourceLocation loading : loadingModels) {
                if (location.getClass() != loading.getClass() || !location.equals((Object)loading)) continue;
                throw new LoaderException("circular model dependencies, stack: [" + Joiner.on((String)", ").join(loadingModels) + "]");
            }
            loadingModels.addLast((ResourceLocation)location);
            try {
                ResourceLocation actual = ModelLoaderRegistry.getActualLocation((ResourceLocation)location);
                ICustomModelLoader accepted = null;
                for (ICustomModelLoader loader : loaders) {
                    try {
                        if (!loader.accepts(actual)) continue;
                        if (accepted != null) {
                            throw new LoaderException(String.format("2 loaders (%s and %s) want to load the same model %s", accepted, loader, location));
                        }
                        accepted = loader;
                    }
                    catch (Exception e) {
                        throw new LoaderException(String.format("Exception checking if model %s can be loaded with loader %s, skipping", location, loader), e);
                    }
                }
                if (accepted == null) {
                    if (bakery == null) {
                        bakery = new ModelLoader(manager, new AtlasTexture("textures"), Minecraft.func_71410_x().func_184125_al(), Minecraft.func_71410_x().func_213239_aq());
                    }
                    model = bakery.func_209597_a(actual);
                    break block16;
                }
                try {
                    model = accepted.loadModel(actual);
                }
                catch (Exception e) {
                    throw new LoaderException(String.format("Exception loading model %s with loader %s, skipping", location, accepted), e);
                }
                if (model == ModelLoaderRegistry.getMissingModel()) {
                    throw new LoaderException(String.format("Loader %s returned missing model while loading model %s", accepted, location));
                }
                if (model == null) {
                    throw new LoaderException(String.format("Loader %s returned null while loading model %s", accepted, location));
                }
            }
            finally {
                ResourceLocation popLoc = loadingModels.removeLast();
                if (popLoc != location) {
                    throw new IllegalStateException("Corrupted loading model stack: " + popLoc + " != " + location);
                }
            }
        }
        cache.put((ResourceLocation)new ModelResourceLocation(entry.getKey(), "inventory"), model);
        return model;
    }

    public static IUnbakedModel getModelOrMissing(Map.Entry<ResourceLocation, Item> entry) {
        if (entry.getValue() == null || registeredItems.containsKey(entry.getValue())) {
            try {
                return ModelLoaderRegistry.getModel(entry);
            }
            catch (Exception e) {
                return ModelLoaderRegistry.getMissingModel((ResourceLocation)new ModelResourceLocation(entry.getKey(), "inventory"), e);
            }
        }
        return null;
    }

    public static IUnbakedModel getModelOrLogError(Map.Entry<ResourceLocation, Item> entry, String error) {
        if (registeredItems.containsKey(entry.getValue())) {
            try {
                return ModelLoaderRegistry.getModel(entry);
            }
            catch (Exception e) {
                LOGGER.error(error, (Throwable)e);
                return ModelLoaderRegistry.getMissingModel((ResourceLocation)new ModelResourceLocation(entry.getKey(), "inventory"), e);
            }
        }
        return null;
    }

    public static IUnbakedModel getMissingModel() {
        return net.minecraftforge.client.model.ModelLoaderRegistry.getMissingModel();
    }

    static IUnbakedModel getMissingModel(ResourceLocation location, Throwable cause) {
        return ModelLoaderRegistry.getMissingModel();
    }

    public static void clearModelCache(IResourceManager manager) {
        ModelLoaderRegistry.manager = manager;
        bakery = new NormalModelLoader(manager, Minecraft.func_71410_x().func_147117_R(), Minecraft.func_71410_x().func_184125_al(), true);
        loaders.clear();
        cache.clear();
        cache.put(new ResourceLocation("minecraft:builtin/generated"), (IUnbakedModel)ItemLayerModel.INSTANCE);
        cache.put(new ResourceLocation("minecraft:block/builtin/generated"), (IUnbakedModel)ItemLayerModel.INSTANCE);
        cache.put(new ResourceLocation("minecraft:item/builtin/generated"), (IUnbakedModel)ItemLayerModel.INSTANCE);
    }

    public static IAnimationStateMachine loadASM(ResourceLocation location, ImmutableMap<String, ITimeValue> customParameters) {
        return AnimationStateMachine.load((IResourceManager)manager, (ResourceLocation)location, customParameters);
    }

    public static class LoaderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoaderException(String message) {
            super(message);
        }

        public LoaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

