/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model.animator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import piman.recievermod.client.renderer.model.animator.Predicate;
import piman.recievermod.client.renderer.model.animator.Transformation;
import piman.recievermod.util.clientUtils.TransformationBuilder;

public class Animator {
    private static final Gson SERIALIZER = new GsonBuilder().registerTypeAdapter(Animator.class, (Object)new Deserializer()).registerTypeAdapter(Predicate.class, (Object)new Predicate.Deserializer()).registerTypeAdapter(Transformation.class, (Object)new Transformation.Deserializer()).create();
    private final List<ResourceLocation> dependencies;
    private final List<Pair<ResourceLocation, List<Pair<ResourceLocation, Predicate>>>> predicates;
    private final Map<ResourceLocation, Map<ItemCameraTransforms.TransformType, Predicate>> baseTransforms;
    private final Map<ResourceLocation, Animator> subAnimators = new HashMap<ResourceLocation, Animator>();

    public Animator() {
        this(new ArrayList<ResourceLocation>(), new ArrayList<Pair<ResourceLocation, List<Pair<ResourceLocation, Predicate>>>>(), new HashMap<ResourceLocation, Map<ItemCameraTransforms.TransformType, Predicate>>());
    }

    public Animator(List<ResourceLocation> dependencies, List<Pair<ResourceLocation, List<Pair<ResourceLocation, Predicate>>>> predicates, Map<ResourceLocation, Map<ItemCameraTransforms.TransformType, Predicate>> baseTransforms) {
        this.dependencies = dependencies;
        this.predicates = predicates;
        this.baseTransforms = baseTransforms;
    }

    public void addSubAnimator(ResourceLocation location, Animator animator) {
        this.subAnimators.put(location, animator);
        this.dependencies.addAll(animator.dependencies);
    }

    public static Animator deserialize(Reader reader) {
        return (Animator)JSONUtils.func_193839_a((Gson)SERIALIZER, (Reader)reader, Animator.class);
    }

    public Set<ResourceLocation> getDependencies() {
        return ImmutableSet.copyOf(this.dependencies);
    }

    public List<ResourceLocation> getDependenciesForMap() {
        return ImmutableList.copyOf(this.dependencies);
    }

    public List<TRSRTransformation> getSubTransforms(ItemStack stack, World world, LivingEntity entity) {
        LinkedHashMap<Object, TRSRTransformation> map = new LinkedHashMap<Object, TRSRTransformation>();
        ArrayList<TRSRTransformation> list = new ArrayList<TRSRTransformation>();
        for (Pair<ResourceLocation, List<Pair<ResourceLocation, Predicate>>> pair : this.predicates) {
            TransformationBuilder builder = new TransformationBuilder();
            for (Pair entry2 : (List)pair.getSecond()) {
                ResourceLocation predicateName = (ResourceLocation)entry2.getFirst();
                IItemPropertyGetter propertyGetter = stack.func_77973_b().func_185045_a(predicateName);
                if (propertyGetter == null) continue;
                float value = propertyGetter.call(stack, world, entity);
                Predicate predicate = (Predicate)entry2.getSecond();
                for (Transformation transformation : predicate.getTransformations()) {
                    this.addTransformation(builder, transformation, value);
                }
            }
            TRSRTransformation transformation = builder.build();
            map.put(pair.getFirst(), transformation);
            list.add(transformation);
        }
        for (Map.Entry entry : this.subAnimators.entrySet()) {
            list.addAll(((Animator)entry.getValue()).getSubTransforms(stack, world, entity, (TRSRTransformation)map.get(entry.getKey())));
        }
        return list;
    }

    public List<TRSRTransformation> getSubTransforms(ItemStack stack, World world, LivingEntity entity, TRSRTransformation baseTransformation) {
        HashMap<Object, TRSRTransformation> map = new HashMap<Object, TRSRTransformation>();
        ArrayList<TRSRTransformation> list = new ArrayList<TRSRTransformation>();
        for (Pair<ResourceLocation, List<Pair<ResourceLocation, Predicate>>> pair : this.predicates) {
            TransformationBuilder builder = new TransformationBuilder();
            for (Pair entry2 : (List)pair.getSecond()) {
                ResourceLocation predicateName = (ResourceLocation)entry2.getFirst();
                IItemPropertyGetter propertyGetter = stack.func_77973_b().func_185045_a(predicateName);
                if (propertyGetter == null && !predicateName.func_110623_a().equals("none")) continue;
                float value = propertyGetter == null ? 0.0f : propertyGetter.call(stack, world, entity);
                Predicate predicate = (Predicate)entry2.getSecond();
                for (Transformation transformation : predicate.getTransformations()) {
                    this.addTransformation(builder, transformation, value);
                }
            }
            TRSRTransformation transformation = baseTransformation.compose(builder.build());
            map.put(pair.getFirst(), transformation);
            list.add(transformation);
        }
        for (Map.Entry entry : this.subAnimators.entrySet()) {
            list.addAll(((Animator)entry.getValue()).getSubTransforms(stack, world, entity, (TRSRTransformation)map.get(entry.getKey())));
        }
        return list;
    }

    public Map<ItemCameraTransforms.TransformType, TRSRTransformation> getBaseTransforms(ItemStack stack, World world, LivingEntity entity) {
        EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> baseTransforms = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
        EnumMap<ItemCameraTransforms.TransformType, TransformationBuilder> builders = new EnumMap<ItemCameraTransforms.TransformType, TransformationBuilder>(ItemCameraTransforms.TransformType.class);
        for (ItemCameraTransforms.TransformType type2 : ItemCameraTransforms.TransformType.values()) {
            builders.put(type2, new TransformationBuilder());
        }
        for (Map.Entry entry : this.baseTransforms.entrySet()) {
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                IItemPropertyGetter getter = stack.func_77973_b().func_185045_a((ResourceLocation)entry.getKey());
                if (getter == null) continue;
                float value = getter.call(stack, world, entity);
                for (Transformation transformation : ((Predicate)entry1.getValue()).getTransformations()) {
                    this.addTransformation((TransformationBuilder)builders.get(entry1.getKey()), transformation, value);
                }
            }
        }
        builders.forEach((type, builder) -> baseTransforms.put((ItemCameraTransforms.TransformType)type, builder.build()));
        return baseTransforms;
    }

    private void addTransformation(TransformationBuilder builder, Transformation transformation, float value) {
        try {
            float scaleFactor = transformation.getValue().eval(value);
            Vector3f translation = transformation.getTranslation();
            Vector3f scale = transformation.getScale();
            Vector3f rotation = transformation.getRotation();
            Vector3f center = transformation.getCenter();
            if (translation != null) {
                translation.scale(scaleFactor);
            }
            if (scale != null) {
                scale.scale(scaleFactor);
            }
            if (rotation != null) {
                rotation.scale(scaleFactor);
            }
            builder.add(translation, rotation, center, scale, transformation.getOrder());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Animator> {
        public Animator deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<ResourceLocation> dependencies = new ArrayList<ResourceLocation>();
            ArrayList<Pair<ResourceLocation, List<Pair<ResourceLocation, Predicate>>>> predicates = new ArrayList<Pair<ResourceLocation, List<Pair<ResourceLocation, Predicate>>>>();
            JsonArray submodels = json.getAsJsonObject().getAsJsonArray("submodels");
            if (submodels != null) {
                for (JsonElement submodelElement : submodels) {
                    JsonObject submodelObject = submodelElement.getAsJsonObject();
                    ResourceLocation model = new ResourceLocation(submodelObject.get("model").getAsString());
                    dependencies.add(model);
                    JsonObject predicatesObject = submodelObject.getAsJsonObject("predicates");
                    ArrayList<Pair> map = new ArrayList<Pair>();
                    for (Map.Entry entry : predicatesObject.entrySet()) {
                        ResourceLocation predicateName = new ResourceLocation((String)entry.getKey());
                        Predicate predicate = (Predicate)context.deserialize((JsonElement)entry.getValue(), Predicate.class);
                        map.add(new Pair((Object)predicateName, (Object)predicate));
                    }
                    predicates.add((Pair<ResourceLocation, List<Pair<ResourceLocation, Predicate>>>)new Pair((Object)model, map));
                }
            }
            JsonObject transformsObject = json.getAsJsonObject().getAsJsonObject("basetransformation");
            HashMap<ResourceLocation, Map<ItemCameraTransforms.TransformType, Predicate>> baseTransforms = new HashMap<ResourceLocation, Map<ItemCameraTransforms.TransformType, Predicate>>();
            if (transformsObject != null) {
                if (transformsObject.has("predicates")) {
                    transformsObject = transformsObject.getAsJsonObject("predicates");
                }
                for (Map.Entry entry : transformsObject.entrySet()) {
                    ResourceLocation location = new ResourceLocation((String)entry.getKey());
                    JsonObject transformTypeObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                    EnumMap<ItemCameraTransforms.TransformType, Object> transformationListMap = new EnumMap<ItemCameraTransforms.TransformType, Object>(ItemCameraTransforms.TransformType.class);
                    for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                        if (!transformTypeObject.has(type.name())) continue;
                        transformationListMap.put(type, context.deserialize((JsonElement)transformTypeObject.getAsJsonArray(type.name()), Predicate.class));
                    }
                    baseTransforms.put(location, transformationListMap);
                }
            }
            return new Animator(dependencies, predicates, baseTransforms);
        }
    }
}

