/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model.animator;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import javax.vecmath.Vector3f;
import net.minecraft.util.JSONUtils;

public class Transformation {
    private final Value value;
    private final int order;
    private final Vector3f translation;
    private final Vector3f scale;
    private final Vector3f rotation;
    private final Vector3f center;

    public Transformation(Value value, int order, Vector3f translation, Vector3f scale, Vector3f rotation, Vector3f center) {
        this.value = value;
        this.order = order;
        this.translation = translation;
        this.scale = scale;
        this.rotation = rotation;
        this.center = center;
    }

    public Value getValue() {
        return this.value;
    }

    public int getOrder() {
        return this.order;
    }

    public Vector3f getTranslation() {
        return this.translation == null ? null : new Vector3f(this.translation);
    }

    public Vector3f getScale() {
        return this.scale == null ? null : new Vector3f(this.scale);
    }

    public Vector3f getRotation() {
        return this.rotation == null ? null : new Vector3f(this.rotation);
    }

    public Vector3f getCenter() {
        return this.center == null ? null : new Vector3f(this.center);
    }

    public static class Value {
        private float start;
        private float end;
        private boolean scale;
        private boolean local;

        public Value(float start, float end, boolean scale, boolean local) {
            this.start = start;
            this.end = end;
            this.scale = scale;
            this.local = local;
        }

        public Value(float start, float end) {
            this(start, end, false, false);
        }

        public Value(float value) {
            this(value - 0.001f, value + 0.001f);
        }

        public Value(boolean scale) {
            this(-3.4028235E38f, Float.MAX_VALUE, scale, false);
        }

        public Value() {
            this(-3.4028235E38f, Float.MAX_VALUE);
        }

        public float eval(float value) {
            if (value >= this.start && value <= this.end) {
                return this.scale ? (this.local ? value - this.start : value) : 1.0f;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Transformation> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Transformation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Value value;
            int order = -1;
            JsonObject jsonObject = (JsonObject)json;
            JsonElement valueElement = jsonObject.get("value");
            if (valueElement.isJsonPrimitive()) {
                if (valueElement.getAsJsonPrimitive().isString()) {
                    String valueString = valueElement.getAsString();
                    if (valueString.equals("default")) {
                        value = new Value();
                        order = 0;
                    } else {
                        if (!valueString.equals("variable")) throw new JsonParseException("Unknown Value String: " + valueString);
                        value = new Value(true);
                    }
                } else {
                    if (!valueElement.getAsJsonPrimitive().isNumber()) throw new JsonParseException("Unknown Value Primitive: " + valueElement.getAsJsonPrimitive());
                    float valueFloat = valueElement.getAsFloat();
                    value = new Value(valueFloat);
                }
            } else {
                if (!valueElement.isJsonObject()) throw new JsonParseException("Unknown Value Element: " + valueElement);
                JsonObject valueObject = valueElement.getAsJsonObject();
                float start = JSONUtils.func_151221_a((JsonObject)valueObject, (String)"min", (float)-3.4028235E38f);
                float end = JSONUtils.func_151221_a((JsonObject)valueObject, (String)"max", (float)Float.MAX_VALUE);
                boolean scale = JSONUtils.func_151209_a((JsonObject)valueObject, (String)"scale", (boolean)false);
                boolean local = JSONUtils.func_151209_a((JsonObject)valueObject, (String)"local", (boolean)false);
                value = new Value(start, end, scale, local);
            }
            if (order == -1) {
                order = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"order", (int)-1);
            }
            JsonObject transformationObject = jsonObject.getAsJsonObject("transformation");
            Vector3f translation = this.getVector3f(transformationObject, "translation", (float[])null);
            Vector3f scale = this.getVector3f(transformationObject, "scale", (float[])null);
            Vector3f rotation = this.getVector3f(transformationObject, "rotation", (float[])null);
            Vector3f center = this.getVector3f(transformationObject, "center", (float[])null);
            return new Transformation(value, order, translation, scale, rotation, center);
        }

        private Vector3f getVector3f(JsonObject jsonObject, String memberName, float ... fallback) {
            float[] floats = new float[3];
            if (jsonObject.has(memberName)) {
                JsonArray jsonArray = jsonObject.getAsJsonArray(memberName);
                for (int i = 0; i < 3; ++i) {
                    floats[i] = jsonArray.get(i).getAsFloat();
                }
            } else {
                floats = fallback;
            }
            return floats == null ? null : new Vector3f(floats);
        }
    }
}

