/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model.bbgunmodel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import piman.recievermod.client.renderer.model.bbgunmodel.ElementFace;
import piman.recievermod.client.renderer.model.bbgunmodel.ModelElement;
import piman.recievermod.client.renderer.model.bbgunmodel.ModelGroup;

@OnlyIn(value=Dist.CLIENT)
public class ModelBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static final Gson SERIALIZER = new GsonBuilder().registerTypeAdapter(ModelBlock.class, (Object)new Deserializer()).registerTypeAdapter(ModelElement.class, (Object)new ModelElement.Deserializer()).registerTypeAdapter(ElementFace.class, (Object)new ElementFace.Deserializer()).registerTypeAdapter(ModelGroup.class, (Object)new ModelGroup.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3fDeserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverrideDeserializer()).create();
    private final Map<UUID, ModelElement> elements;
    private final List<ModelGroup> groups;
    public Vector3f rotation = new Vector3f();
    public Vector3f origin = new Vector3f();
    private final boolean gui3d;
    public final boolean ambientOcclusion;
    private final ItemCameraTransforms cameraTransforms;
    private final List<ItemOverride> overrides;
    public String name = "";
    @VisibleForTesting
    public final Map<String, String> textures;

    public static ModelBlock deserialize(Reader readerIn) {
        return (ModelBlock)JSONUtils.func_188173_a((Gson)SERIALIZER, (Reader)readerIn, ModelBlock.class, (boolean)false);
    }

    public static ModelBlock deserialize(String jsonString) {
        return ModelBlock.deserialize(new StringReader(jsonString));
    }

    public ModelBlock(Map<UUID, ModelElement> elementsIn, List<ModelGroup> groups, Map<String, String> texturesIn, boolean ambientOcclusionIn, boolean gui3dIn, ItemCameraTransforms cameraTransformsIn, List<ItemOverride> overridesIn) {
        this.elements = elementsIn;
        this.groups = groups;
        this.ambientOcclusion = ambientOcclusionIn;
        this.gui3d = gui3dIn;
        this.textures = texturesIn;
        this.cameraTransforms = cameraTransformsIn;
        this.overrides = overridesIn;
    }

    public ModelBlock getGroupAsModel(List<ModelGroup> groupList, String name) {
        ModelBlock model = null;
        ModelGroup removeGroup = null;
        for (ModelGroup group : groupList) {
            if (group.name.equals(name)) {
                removeGroup = group;
                Map<UUID, ModelElement> elements = this.getAllGroupElements(group);
                model = new ModelBlock(elements, group.subGroups, this.textures, this.ambientOcclusion, this.gui3d, this.cameraTransforms, this.overrides);
                model.rotation = group.rotation;
                model.origin = group.origin;
                for (UUID uuid : elements.keySet()) {
                    this.elements.remove(uuid);
                }
                break;
            }
            model = this.getGroupAsModel(group.subGroups, name);
            if (model == null) continue;
            break;
        }
        if (removeGroup != null) {
            groupList.remove(removeGroup);
        }
        return model;
    }

    public Map<UUID, ModelElement> getAllGroupElements(ModelGroup group) {
        ArrayList<ModelGroup> stack = new ArrayList<ModelGroup>();
        stack.add(group);
        return this.getAllGroupElements(stack);
    }

    private Map<UUID, ModelElement> getAllGroupElements(List<ModelGroup> groupStack) {
        HashMap<UUID, ModelElement> map = new HashMap<UUID, ModelElement>();
        for (UUID uuid : groupStack.get((int)0).elements) {
            map.put(uuid, this.elements.get(uuid));
        }
        for (ModelGroup group : groupStack.get((int)0).subGroups) {
            groupStack.add(0, group);
            map.putAll(this.getAllGroupElements(groupStack));
            groupStack.remove(0);
        }
        return map;
    }

    public Map<UUID, ModelElement> getElements() {
        return this.elements;
    }

    public List<ModelGroup> getGroups() {
        return this.groups;
    }

    public boolean isAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    public boolean isGui3d() {
        return this.gui3d;
    }

    public Collection<ResourceLocation> getOverrideLocations() {
        HashSet set = Sets.newHashSet();
        for (ItemOverride itemoverride : this.overrides) {
            set.add(itemoverride.func_188026_a());
        }
        return set;
    }

    public List<ItemOverride> getOverrides() {
        return this.overrides;
    }

    public boolean isTexturePresent(String textureName) {
        return !"missingno".equals(this.resolveTextureName(textureName));
    }

    public String resolveTextureName(String textureName) {
        if (!this.startsWithHash(textureName)) {
            textureName = '#' + textureName;
        }
        return this.resolveTextureName(textureName, new Bookkeep(this));
    }

    private String resolveTextureName(String textureName, Bookkeep p_178302_2_) {
        if (this.startsWithHash(textureName)) {
            if (this == p_178302_2_.modelExt) {
                LOGGER.warn("Unable to resolve texture due to upward reference: {} in {}", (Object)textureName, (Object)this.name);
                return "missingno";
            }
            String s = this.textures.get(textureName.substring(1));
            p_178302_2_.modelExt = this;
            if (s != null && this.startsWithHash(s)) {
                s = p_178302_2_.model.resolveTextureName(s, p_178302_2_);
            }
            return s != null && !this.startsWithHash(s) ? s : "missingno";
        }
        return textureName;
    }

    private boolean startsWithHash(String hash) {
        return hash.charAt(0) == '#';
    }

    public ItemCameraTransforms getAllTransforms() {
        ItemTransformVec3f itemtransformvec3f = this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ItemTransformVec3f itemtransformvec3f1 = this.getTransform(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ItemTransformVec3f itemtransformvec3f2 = this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ItemTransformVec3f itemtransformvec3f3 = this.getTransform(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ItemTransformVec3f itemtransformvec3f4 = this.getTransform(ItemCameraTransforms.TransformType.HEAD);
        ItemTransformVec3f itemtransformvec3f5 = this.getTransform(ItemCameraTransforms.TransformType.GUI);
        ItemTransformVec3f itemtransformvec3f6 = this.getTransform(ItemCameraTransforms.TransformType.GROUND);
        ItemTransformVec3f itemtransformvec3f7 = this.getTransform(ItemCameraTransforms.TransformType.FIXED);
        return new ItemCameraTransforms(itemtransformvec3f, itemtransformvec3f1, itemtransformvec3f2, itemtransformvec3f3, itemtransformvec3f4, itemtransformvec3f5, itemtransformvec3f6, itemtransformvec3f7);
    }

    private ItemTransformVec3f getTransform(ItemCameraTransforms.TransformType type) {
        return this.cameraTransforms.func_181688_b(type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemTransformVec3fDeserializer
    implements JsonDeserializer<ItemTransformVec3f> {
        public static final net.minecraft.client.renderer.Vector3f ROTATION_DEFAULT = new net.minecraft.client.renderer.Vector3f(0.0f, 0.0f, 0.0f);
        public static final net.minecraft.client.renderer.Vector3f TRANSLATION_DEFAULT = new net.minecraft.client.renderer.Vector3f(0.0f, 0.0f, 0.0f);
        public static final net.minecraft.client.renderer.Vector3f SCALE_DEFAULT = new net.minecraft.client.renderer.Vector3f(1.0f, 1.0f, 1.0f);

        public ItemTransformVec3f deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            net.minecraft.client.renderer.Vector3f vector3f = this.parseVector(jsonobject, "rotation", ROTATION_DEFAULT);
            net.minecraft.client.renderer.Vector3f vector3f1 = this.parseVector(jsonobject, "translation", TRANSLATION_DEFAULT);
            vector3f1.func_195898_a(0.0625f);
            net.minecraft.client.renderer.Vector3f vector3f2 = this.parseVector(jsonobject, "scale", SCALE_DEFAULT);
            return new ItemTransformVec3f(vector3f, vector3f1, vector3f2);
        }

        private net.minecraft.client.renderer.Vector3f parseVector(JsonObject json, String key, net.minecraft.client.renderer.Vector3f fallback) {
            if (!json.has(key)) {
                return fallback;
            }
            JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)key);
            if (jsonarray.size() != 3) {
                throw new JsonParseException("Expected 3 " + key + " values, found: " + jsonarray.size());
            }
            float[] afloat = new float[3];
            for (int i = 0; i < afloat.length; ++i) {
                afloat[i] = JSONUtils.func_151220_d((JsonElement)jsonarray.get(i), (String)(key + "[" + i + "]"));
            }
            return new net.minecraft.client.renderer.Vector3f(afloat[0], afloat[1], afloat[2]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ItemOverrideDeserializer
    implements JsonDeserializer<ItemOverride> {
        ItemOverrideDeserializer() {
        }

        public ItemOverride deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"model"));
            Map<ResourceLocation, Float> map = this.makeMapResourceValues(jsonobject);
            return new ItemOverride(resourcelocation, map);
        }

        protected Map<ResourceLocation, Float> makeMapResourceValues(JsonObject p_188025_1_) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            JsonObject jsonobject = JSONUtils.func_152754_s((JsonObject)p_188025_1_, (String)"predicate");
            for (Map.Entry entry : jsonobject.entrySet()) {
                map.put(new ResourceLocation((String)entry.getKey()), Float.valueOf(JSONUtils.func_151220_d((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))));
            }
            return map;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ModelBlock> {
        public ModelBlock deserialize(JsonElement baseElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject baseObject = (JsonObject)baseElement;
            this.checkVersion(baseElement);
            Map<UUID, ModelElement> elements = this.getElements(baseObject, context);
            List<ModelGroup> groups = this.getGroups(baseObject, context);
            Map<String, String> textures = this.getTextures(baseObject);
            ItemCameraTransforms itemcameratransforms = ItemCameraTransforms.field_178357_a;
            if (baseObject.has("display")) {
                JsonObject jsonobject1 = JSONUtils.func_152754_s((JsonObject)baseObject, (String)"display");
                itemcameratransforms = (ItemCameraTransforms)context.deserialize((JsonElement)jsonobject1, ItemCameraTransforms.class);
            }
            boolean ambientOclusion = this.getAmbientOcclusionEnabled(baseObject);
            List<ItemOverride> overrides = this.getItemOverrides(context, baseObject);
            return new ModelBlock(elements, groups, textures, true, true, itemcameratransforms, overrides);
        }

        private void checkVersion(JsonElement element) {
            JsonObject object = element.getAsJsonObject();
            JsonObject meta = object.getAsJsonObject("meta");
            if (!JSONUtils.func_151219_a((JsonObject)meta, (String)"format_version", (String)"").startsWith("3")) {
                throw new JsonParseException("Version must be at least 3.0");
            }
            if (!JSONUtils.func_151219_a((JsonObject)meta, (String)"model_format", (String)"").equals("free")) {
                throw new JsonParseException("Model must be free Model");
            }
            if (JSONUtils.func_151209_a((JsonObject)meta, (String)"box_uv", (boolean)true)) {
                throw new JsonParseException("Box UV not supported");
            }
        }

        protected List<ItemOverride> getItemOverrides(JsonDeserializationContext deserializationContext, JsonObject object) {
            ArrayList list = Lists.newArrayList();
            if (object.has("overrides")) {
                for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)object, (String)"overrides")) {
                    list.add((ItemOverride)deserializationContext.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, String> getTextures(JsonObject object) {
            HashMap map = Maps.newHashMap();
            if (object.has("textures")) {
                JsonArray texturesArray = object.getAsJsonArray("textures");
                for (JsonElement textureElement : texturesArray) {
                    JsonObject textureObject = (JsonObject)textureElement;
                    map.put(textureObject.get("id").getAsString(), new ResourceLocation(textureObject.get("namespace").getAsString(), textureObject.get("folder").getAsString() + "/" + textureObject.get("name").getAsString().replace(".png", "")).toString());
                }
            }
            return map;
        }

        protected boolean getAmbientOcclusionEnabled(JsonObject object) {
            return JSONUtils.func_151209_a((JsonObject)object, (String)"ambientocclusion", (boolean)true);
        }

        private Map<UUID, ModelElement> getElements(JsonObject jsonObject, JsonDeserializationContext context) {
            JsonArray elementsArray = jsonObject.getAsJsonArray("elements");
            HashMap<UUID, ModelElement> map = new HashMap<UUID, ModelElement>();
            for (JsonElement jsonElement : elementsArray) {
                ModelElement modelElement = (ModelElement)context.deserialize(jsonElement, ModelElement.class);
                map.put(modelElement.uuid, modelElement);
            }
            return map;
        }

        private List<ModelGroup> getGroups(JsonObject baseObject, JsonDeserializationContext context) {
            JsonArray groupsArray = baseObject.getAsJsonArray("outliner");
            ArrayList<ModelGroup> list = new ArrayList<ModelGroup>();
            for (JsonElement jsonElement : groupsArray) {
                if (!jsonElement.isJsonObject()) continue;
                ModelGroup group = (ModelGroup)context.deserialize(jsonElement, ModelGroup.class);
                list.add(group);
            }
            return list;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class Bookkeep {
        public final ModelBlock model;
        public ModelBlock modelExt;

        private Bookkeep(ModelBlock modelIn) {
            this.model = modelIn;
        }
    }
}

