/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model.bbgunmodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.vecmath.Vector3f;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import piman.recievermod.client.renderer.model.bbgunmodel.ElementFace;

@OnlyIn(value=Dist.CLIENT)
public class ModelElement {
    public final String name;
    public final Vector3f start;
    public final Vector3f end;
    public final Vector3f rotation;
    public final Vector3f origin;
    public final Map<Direction, ElementFace> faces;
    public final UUID uuid;

    public ModelElement(String name, Vector3f start, Vector3f end, Vector3f rotation, Vector3f origin, Map<Direction, ElementFace> faces, UUID uuid) {
        this.name = name;
        this.start = start;
        this.end = end;
        this.rotation = rotation;
        this.origin = origin;
        this.faces = faces;
        this.uuid = uuid;
    }

    public static class Deserializer
    implements JsonDeserializer<ModelElement> {
        public ModelElement deserialize(JsonElement baseElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = (JsonObject)baseElement;
            String name = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"name", (String)"");
            Vector3f start = this.getVector3f(jsonObject, "from", 0.0f, 0.0f, 0.0f);
            Vector3f end = this.getVector3f(jsonObject, "to", 0.0f, 0.0f, 0.0f);
            Vector3f rotation = this.getVector3f(jsonObject, "rotation", 0.0f, 0.0f, 0.0f);
            Vector3f origin = this.getVector3f(jsonObject, "origin", 8.0f, 8.0f, 8.0f);
            start.scale(0.0625f);
            end.scale(0.0625f);
            origin.scale(0.0625f);
            rotation.y *= -1.0f;
            rotation.z *= -1.0f;
            JsonObject facesObject = jsonObject.getAsJsonObject("faces");
            HashMap<Direction, ElementFace> faces = new HashMap<Direction, ElementFace>();
            for (Map.Entry entry : facesObject.entrySet()) {
                Direction facing = Direction.func_176739_a((String)((String)entry.getKey()));
                ElementFace face = (ElementFace)context.deserialize((JsonElement)entry.getValue(), ElementFace.class);
                if (face == null) continue;
                faces.put(facing, face);
            }
            UUID uuid = this.getUUID(jsonObject, "uuid");
            return new ModelElement(name, start, end, rotation, origin, faces, uuid);
        }

        private Vector3f getVector3f(JsonObject jsonObject, String memberName, float ... fallback) {
            float[] floats = fallback;
            if (jsonObject.has(memberName)) {
                JsonArray jsonArray = jsonObject.getAsJsonArray(memberName);
                for (int i = 0; i < 3; ++i) {
                    floats[i] = jsonArray.get(i).getAsFloat();
                }
            }
            return new Vector3f(floats);
        }

        private UUID getUUID(JsonObject jsonObject, String memberName) {
            String uuid = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)memberName, (String)"");
            return UUID.fromString(uuid);
        }
    }
}

