/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model.bbgunmodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.vecmath.Vector3f;
import net.minecraft.util.JSONUtils;

public class ModelGroup {
    public final String name;
    public final UUID uuid;
    public final Vector3f rotation;
    public final Vector3f origin;
    public final List<ModelGroup> subGroups;
    public final List<UUID> elements;

    ModelGroup(String name, UUID uuid, Vector3f rotation, Vector3f origin, List<ModelGroup> subGroups, List<UUID> elements) {
        this.name = name;
        this.uuid = uuid;
        this.rotation = rotation;
        this.origin = origin;
        this.subGroups = subGroups;
        this.elements = elements;
    }

    public static class Deserializer
    implements JsonDeserializer<ModelGroup> {
        public ModelGroup deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            if (!JSONUtils.func_151209_a((JsonObject)jsonObject, (String)"visibility", (boolean)true)) {
                return null;
            }
            String name = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"name", (String)"");
            UUID uuid = UUID.fromString(JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"uuid", (String)""));
            Vector3f rotation = this.getVector3f(jsonObject, "rotation", 0.0f, 0.0f, 0.0f);
            Vector3f origin = this.getVector3f(jsonObject, "origin", 8.0f, 8.0f, 8.0f);
            rotation.z *= -1.0f;
            origin.scale(0.0625f);
            JsonArray childrenArray = jsonObject.getAsJsonArray("children");
            ArrayList<ModelGroup> groups = new ArrayList<ModelGroup>();
            ArrayList<UUID> elements = new ArrayList<UUID>();
            for (JsonElement childElement : childrenArray) {
                if (childElement.isJsonObject()) {
                    ModelGroup group = (ModelGroup)context.deserialize(childElement, ModelGroup.class);
                    if (group == null) continue;
                    groups.add(group);
                    continue;
                }
                if (!childElement.isJsonPrimitive() || !((JsonPrimitive)childElement).isString()) continue;
                elements.add(UUID.fromString(childElement.getAsString()));
            }
            return new ModelGroup(name, uuid, rotation, origin, groups, elements);
        }

        private Vector3f getVector3f(JsonObject jsonObject, String memberName, float ... fallback) {
            float[] floats = fallback;
            if (jsonObject.has(memberName)) {
                JsonArray jsonArray = jsonObject.getAsJsonArray(memberName);
                for (int i = 0; i < 3; ++i) {
                    floats[i] = jsonArray.get(i).getAsFloat();
                }
            }
            return new Vector3f(floats);
        }
    }
}

