/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model.bbgunmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.FaceDirection;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import piman.recievermod.client.renderer.model.bbgunmodel.ElementFace;
import piman.recievermod.client.renderer.model.bbgunmodel.ModelBlock;
import piman.recievermod.client.renderer.model.bbgunmodel.ModelElement;
import piman.recievermod.client.renderer.model.bbgunmodel.ModelGroup;
import piman.recievermod.util.clientUtils.BakedQuadBuilder;
import piman.recievermod.util.clientUtils.TransformationBuilder;

@OnlyIn(value=Dist.CLIENT)
public class SimpleBakedBBModel
implements IBakedModel {
    protected final List<BakedQuad> generalQuads;
    protected final Map<Direction, List<BakedQuad>> faceQuads;
    protected final boolean ambientOcclusion;
    protected final boolean gui3d;
    protected final TextureAtlasSprite texture;
    protected final ItemCameraTransforms cameraTransforms;
    protected final ItemOverrideList itemOverrideList;

    public SimpleBakedBBModel(List<BakedQuad> generalQuadsIn, Map<Direction, List<BakedQuad>> faceQuadsIn, boolean ambientOcclusionIn, boolean gui3dIn, TextureAtlasSprite textureIn, ItemCameraTransforms cameraTransformsIn, ItemOverrideList itemOverrideListIn) {
        this.generalQuads = generalQuadsIn;
        this.faceQuads = faceQuadsIn;
        this.ambientOcclusion = ambientOcclusionIn;
        this.gui3d = gui3dIn;
        this.texture = textureIn;
        this.cameraTransforms = cameraTransformsIn;
        this.itemOverrideList = itemOverrideListIn;
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return side == null ? this.generalQuads : new ArrayList<BakedQuad>();
    }

    public boolean func_177555_b() {
        return this.ambientOcclusion;
    }

    public boolean func_177556_c() {
        return this.gui3d;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.texture;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.cameraTransforms;
    }

    public ItemOverrideList func_188617_f() {
        return this.itemOverrideList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final ModelBlock model;
        private final ItemOverrideList overrides;
        private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
        private static final FaceBakery bakery = new FaceBakery();

        public Builder(ModelBlock model, ItemOverrideList overrides, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            this.model = model;
            this.overrides = overrides;
            this.bakedTextureGetter = bakedTextureGetter;
        }

        public IBakedModel build() {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            ArrayList<ModelGroup> groupStack = new ArrayList<ModelGroup>();
            HashMap<UUID, ModelElement> map = new HashMap<UUID, ModelElement>(this.model.getElements());
            for (ModelGroup modelGroup : this.model.getGroups()) {
                groupStack.add(0, modelGroup);
                this.buildFromGroup(groupStack, map, quads);
                groupStack.remove(0);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.buildFromElement(groupStack, (ModelElement)entry.getValue(), quads);
            }
            return new SimpleBakedBBModel(quads, null, this.model.ambientOcclusion, this.model.isGui3d(), this.bakedTextureGetter.apply(new ResourceLocation(this.model.textures.get("0"))), this.model.getAllTransforms(), this.overrides);
        }

        private void buildFromGroup(List<ModelGroup> groupStack, Map<UUID, ModelElement> elementMap, List<BakedQuad> quads) {
            ModelGroup group = groupStack.get(0);
            for (ModelGroup newGroup : group.subGroups) {
                groupStack.add(0, newGroup);
                this.buildFromGroup(groupStack, elementMap, quads);
                groupStack.remove(0);
            }
            for (UUID elementUUID : group.elements) {
                ModelElement element = elementMap.remove(elementUUID);
                this.buildFromElement(groupStack, element, quads);
            }
        }

        private void buildFromElement(List<ModelGroup> groupStack, ModelElement element, List<BakedQuad> quads) {
            Vector3f[] points = new Vector3f[8];
            float[] vertexinfo = new float[Direction.values().length];
            vertexinfo[FaceDirection.Constants.field_179176_f] = element.start.x;
            vertexinfo[FaceDirection.Constants.field_179178_e] = element.start.y;
            vertexinfo[FaceDirection.Constants.field_179177_d] = element.start.z;
            vertexinfo[FaceDirection.Constants.field_179180_c] = element.end.x;
            vertexinfo[FaceDirection.Constants.field_179179_b] = element.end.y;
            vertexinfo[FaceDirection.Constants.field_179181_a] = element.end.z;
            points[0] = new Vector3f(element.start.x, element.end.y, element.end.z);
            points[1] = new Vector3f(element.end.x, element.end.y, element.end.z);
            points[2] = new Vector3f(element.end.x, element.end.y, element.start.z);
            points[3] = new Vector3f(element.start.x, element.end.y, element.start.z);
            points[4] = new Vector3f(element.start.x, element.start.y, element.start.z);
            points[5] = new Vector3f(element.end.x, element.start.y, element.start.z);
            points[6] = new Vector3f(element.end.x, element.start.y, element.end.z);
            points[7] = new Vector3f(element.start.x, element.start.y, element.end.z);
            for (Direction facing : Direction.values()) {
                ElementFace face = element.faces.get(facing);
                if (face == null) continue;
                TransformationBuilder transformationBuilder = new TransformationBuilder();
                int[] ints = this.getPointIndexes(facing);
                Vector3f[] aVector3f = new Vector3f[4];
                for (int i = 0; i < 4; ++i) {
                    aVector3f[i] = new Vector3f(vertexinfo[FaceDirection.func_179027_a((Direction)facing).func_179025_a((int)i).field_179184_a], vertexinfo[FaceDirection.func_179027_a((Direction)facing).func_179025_a((int)i).field_179182_b], vertexinfo[FaceDirection.func_179027_a((Direction)facing).func_179025_a((int)i).field_179183_c]);
                }
                BakedQuadBuilder builder = new BakedQuadBuilder().setPosition(aVector3f[0], 0).setPosition(aVector3f[1], 1).setPosition(aVector3f[2], 2).setPosition(aVector3f[3], 3).applyRotation(element.rotation, element.origin).setColor(-1L).setTexture(this.bakedTextureGetter.apply(new ResourceLocation(this.model.resolveTextureName(face.texture)))).setUV(face.uv).setFace(facing);
                int i = 0;
                transformationBuilder.add(null, element.rotation, element.origin, null, i++);
                for (ModelGroup group : groupStack) {
                    builder.applyRotation(group.rotation, group.origin);
                    transformationBuilder.add(null, group.rotation, group.origin, null, i++);
                }
                transformationBuilder.add(null, this.model.rotation, this.model.origin, null, i);
                quads.add(builder.applyRotation(this.model.rotation, this.model.origin).build());
                float[] uvs = new float[4];
                face.uv.get(uvs);
            }
        }

        private int[] getPointIndexes(Direction facing) {
            switch (facing) {
                case DOWN: {
                    return new int[]{4, 5, 6, 7};
                }
                case UP: {
                    return new int[]{0, 1, 2, 3};
                }
                case NORTH: {
                    return new int[]{5, 4, 3, 2};
                }
                case SOUTH: {
                    return new int[]{7, 6, 1, 0};
                }
                case WEST: {
                    return new int[]{4, 7, 0, 3};
                }
                case EAST: {
                    return new int[]{6, 5, 2, 1};
                }
            }
            return new int[0];
        }
    }
}

