/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model.bbgunmodel;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.TRSRTransformation;
import piman.recievermod.Main;
import piman.recievermod.client.renderer.model.BakedGunModel;
import piman.recievermod.client.renderer.model.GunOverrideHandler;
import piman.recievermod.client.renderer.model.animator.Animator;
import piman.recievermod.client.renderer.model.bbgunmodel.ModelBlock;
import piman.recievermod.client.renderer.model.bbgunmodel.SimpleBakedBBModel;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class UnbakedBBGunModel
implements IUnbakedModel {
    private Animator animator;
    private ModelBlock model;
    private List<ModelBlock> submodels = new ArrayList<ModelBlock>();

    public UnbakedBBGunModel(ResourceLocation resourceLocation) {
        IResource resource;
        String basePath = "models/item/" + resourceLocation.func_110623_a().split("\\.")[0];
        ResourceLocation animationLocation = new ResourceLocation(resourceLocation.func_110624_b(), basePath + ".json");
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(animationLocation);
            this.animator = Animator.deserialize(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            this.animator = new Animator();
        }
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(resourceLocation.func_110624_b(), "models/item/" + resourceLocation.func_110623_a()));
            this.model = ModelBlock.deserialize(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.getDependenciesForMap().size(); ++i) {
            ResourceLocation location1 = this.getDependenciesForMap().get(i);
            if (location1.func_110624_b().equals("this")) {
                this.submodels.add(this.model.getGroupAsModel(this.model.getGroups(), location1.func_110623_a()));
                continue;
            }
            try {
                IResource iResource1 = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(location1.func_110624_b(), "models/item/" + location1.func_110623_a()));
                InputStreamReader reader1 = new InputStreamReader(iResource1.func_199027_b(), StandardCharsets.UTF_8);
                this.submodels.add(ModelBlock.deserialize(reader1));
            }
            catch (IOException e) {
                Main.LOGGER.warn("Could not load model: {}", (Object)location1);
                e.printStackTrace();
            }
            String animatorPath = location1.func_110623_a().split("\\.")[0] + ".json";
            try {
                IResource iResource1 = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(location1.func_110624_b(), "models/item/" + animatorPath));
                InputStreamReader reader1 = new InputStreamReader(iResource1.func_199027_b(), StandardCharsets.UTF_8);
                this.animator.addSubAnimator(location1, Animator.deserialize(reader1));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Collection<ResourceLocation> func_187965_e() {
        return this.animator.getDependencies();
    }

    public List<ResourceLocation> getDependenciesForMap() {
        return this.animator.getDependenciesForMap();
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (Map.Entry<String, String> entry : this.model.textures.entrySet()) {
            set.add(new ResourceLocation(entry.getValue()));
        }
        return set;
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        if (format != DefaultVertexFormats.field_176599_b) {
            throw new IllegalArgumentException("Vertex Format Must be ITEM");
        }
        ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
        models.add(this.bakePart(spriteGetter, sprite, this.model));
        for (ModelBlock model : this.submodels) {
            models.add(this.bakePart(spriteGetter, sprite, model));
        }
        return new BakedGunModel(this, models, new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>(), spriteGetter.apply(new ResourceLocation(this.model.textures.get("0"))), format, new GunOverrideHandler(this.animator), new HashMap<String, IBakedModel>());
    }

    public IBakedModel bakePart(Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, ModelBlock model) {
        return new SimpleBakedBBModel.Builder(model, ItemOverrideList.field_188022_a, spriteGetter).build();
    }
}

