/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.client.renderer.model.jsongunmodel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Matrix4f;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import piman.recievermod.Main;
import piman.recievermod.client.renderer.model.BakedGunModel;
import piman.recievermod.client.renderer.model.GunOverrideHandler;
import piman.recievermod.client.renderer.model.animator.Animator;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class UnbakedJsonGunModel
implements IUnbakedModel {
    private Animator animator;
    private BlockModel model;
    private List<BlockModel> submodels = new ArrayList<BlockModel>();

    public UnbakedJsonGunModel(ResourceLocation location) {
        InputStreamReader reader;
        IResource iResource;
        try {
            iResource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(location.func_110624_b(), "models/item/" + location.func_110623_a() + ".json"));
            reader = new InputStreamReader(iResource.func_199027_b(), StandardCharsets.UTF_8);
            this.animator = Animator.deserialize(reader);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            this.animator = new Animator();
        }
        try {
            iResource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(location.func_110624_b(), "models/item/" + location.func_110623_a() + ".json"));
            reader = new InputStreamReader(iResource.func_199027_b(), StandardCharsets.UTF_8);
            this.model = BlockModel.func_178307_a((Reader)reader);
            for (ResourceLocation location1 : this.getDependenciesForMap()) {
                IResource iResource1 = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(location1.func_110624_b(), "models/item/" + location1.func_110623_a() + ".json"));
                InputStreamReader reader1 = new InputStreamReader(iResource1.func_199027_b(), StandardCharsets.UTF_8);
                this.submodels.add(BlockModel.func_178307_a((Reader)reader1));
            }
        }
        catch (IOException e) {
            Main.LOGGER.error("Could Not Load Model: " + location, (Throwable)e);
            e.printStackTrace();
        }
    }

    public Collection<ResourceLocation> func_187965_e() {
        return this.animator.getDependencies();
    }

    public Collection<ResourceLocation> getDependenciesForMap() {
        return this.animator.getDependenciesForMap();
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        return this.model.func_209559_a(modelGetter, missingTextureErrors);
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        if (format != DefaultVertexFormats.field_176599_b) {
            throw new IllegalArgumentException("Vertex Format Must be ITEM");
        }
        ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
        ArrayList<TRSRTransformation> newTransforms = new ArrayList<TRSRTransformation>();
        for (BlockPart part : this.model.func_178298_a()) {
            newTransforms.add(TRSRTransformation.identity());
        }
        ItemCameraTransforms transforms = this.model.func_181682_g();
        EnumMap tMap = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
        tMap.putAll(PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)transforms));
        tMap.putAll(PerspectiveMapWrapper.getTransforms((IModelState)sprite.getState()));
        models.add(this.bakeNormal(bakery, this.model, sprite.getState(), sprite.getState(), newTransforms, format, spriteGetter, false));
        for (BlockModel model : this.submodels) {
            newTransforms.clear();
            for (BlockPart part : model.func_178298_a()) {
                newTransforms.add(TRSRTransformation.identity());
            }
            models.add(this.bakeNormal(bakery, model, sprite.getState(), sprite.getState(), newTransforms, format, spriteGetter, false));
        }
        return new BakedGunModel(this, models, tMap, spriteGetter.apply(new ResourceLocation(this.model.func_178308_c("particle"))), format, new GunOverrideHandler(this.animator), new HashMap<String, IBakedModel>());
    }

    private IBakedModel bakeNormal(ModelBakery bakery, BlockModel model, IModelState perState, IModelState modelState, List<TRSRTransformation> newTransforms, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, boolean uvLocked) {
        TRSRTransformation baseState = modelState.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite particle = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c("particle")));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, model.getOverrides(bakery, model, bakedTextureGetter, format)).func_177646_a(particle);
        for (int i = 0; i < model.func_178298_a().size(); ++i) {
            if (modelState.apply(Optional.of(Models.getHiddenModelPart((ImmutableList)ImmutableList.of((Object)Integer.toString(i))))).isPresent()) continue;
            BlockPart part = (BlockPart)model.func_178298_a().get(i);
            TRSRTransformation transformation = baseState;
            if (newTransforms.get(i) != null) {
                transformation = transformation.compose(newTransforms.get(i));
                BlockPartRotation rot = part.field_178237_d;
                if (rot == null) {
                    rot = new BlockPartRotation(new Vector3f(), Direction.Axis.Y, 0.0f, false);
                }
                part = new BlockPart(part.field_178241_a, part.field_178239_b, part.field_178240_c, rot, part.field_178238_e);
            }
            for (Map.Entry e : part.field_178240_c.entrySet()) {
                TextureAtlasSprite textureatlassprite1 = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c(((BlockPartFace)e.getValue()).field_178242_d)));
                if (((BlockPartFace)e.getValue()).field_178244_b == null || !TRSRTransformation.isInteger((Matrix4f)transformation.getMatrixVec())) {
                    builder.func_177648_a(BlockModel.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)textureatlassprite1, (Direction)((Direction)e.getKey()), (ISprite)new BasicState((IModelState)transformation, uvLocked)));
                    continue;
                }
                builder.func_177650_a(baseState.rotateTransform(((BlockPartFace)e.getValue()).field_178244_b), BlockModel.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)textureatlassprite1, (Direction)((Direction)e.getKey()), (ISprite)new BasicState((IModelState)transformation, uvLocked)));
            }
        }
        return builder.func_177645_b();
    }
}

