/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.entities;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import piman.recievermod.Main;
import piman.recievermod.init.ModEntities;

public class EntityBullet
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    protected static final DataParameter<Optional<UUID>> field_212362_a = EntityDataManager.func_187226_a(EntityBullet.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> PIERCE_LEVEL = EntityDataManager.func_187226_a(EntityBullet.class, (IDataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockState inBlockState;
    protected boolean inGround;
    protected int timeInGround;
    public UUID shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    private double damage = 2.0;
    private SoundEvent hitSound = this.getHitEntitySound();
    private IntOpenHashSet piercedEntities;
    private List<Entity> hitEntities;

    public EntityBullet(EntityType<? extends EntityBullet> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityBullet(double x, double y, double z, World worldIn) {
        this(ModEntities.ENTITYBULLET, worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityBullet(LivingEntity shooter, World worldIn) {
        this(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, worldIn);
        this.setShooter((Entity)shooter);
    }

    public void setHitSound(SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityBullet.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_212362_a, Optional.empty());
        this.field_70180_af.func_187214_a(PIERCE_LEVEL, (Object)0);
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.func_213317_d(this.func_213322_ci().func_72441_c(shooter.func_213322_ci().field_72450_a, shooter.field_70122_E ? 0.0 : shooter.func_213322_ci().field_72448_b, shooter.func_213322_ci().field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)EntityBullet.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.func_70071_h_();
        Vec3d vec3d = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)EntityBullet.func_213296_b((Vec3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        if (!(blockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))).isAir((IBlockReader)this.field_70170_p, blockpos) && !(voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (this.inGround) {
            if (this.inBlockState != blockstate && this.field_70170_p.func_217351_c(this.func_174813_aQ().func_186662_g(0.06))) {
                this.inGround = false;
                this.func_213317_d(vec3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.field_70170_p.field_72995_K) {
                this.tryDespawn();
            }
            ++this.timeInGround;
        } else {
            this.timeInGround = 0;
            ++this.ticksInAir;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d2 = vec3d1.func_178787_e(vec3d);
            BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d1, vec3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vec3d2 = raytraceresult.func_216347_e();
            }
            while (this.func_70089_S()) {
                EntityRayTraceResult entityraytraceresult = this.rayTraceEntities(vec3d1, vec3d2);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    Entity entity1 = this.getShooter();
                    EntityRayTraceResult locationRayTrace = Main.rayTraceEntity(vec3d1, vec3d2, entity);
                    if (locationRayTrace != null) {
                        raytraceresult = locationRayTrace;
                    }
                    if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.onHit((RayTraceResult)raytraceresult);
                    this.field_70160_al = true;
                }
                if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
                raytraceresult = null;
            }
            vec3d = this.func_213322_ci();
            double d1 = vec3d.field_72450_a;
            double d2 = vec3d.field_72448_b;
            double d0 = vec3d.field_72449_c;
            this.field_70165_t += d1;
            this.field_70163_u += d2;
            this.field_70161_v += d0;
            float f4 = MathHelper.func_76133_a((double)EntityBullet.func_213296_b((Vec3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)d2, (double)f4) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
            float f1 = 0.99f;
            float f2 = 0.05f;
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t - d1 * (double)f3, this.field_70163_u - d2 * (double)f3, this.field_70161_v - d0 * (double)f3, d1, d2, d0);
                }
                f1 = this.getWaterDrag();
            }
            this.func_213317_d(vec3d.func_186678_a((double)f1));
            if (!this.func_189652_ae()) {
                Vec3d vec3d3 = this.func_213322_ci();
                this.func_213293_j(vec3d3.field_72450_a, vec3d3.field_72448_b - (double)f2, vec3d3.field_72449_c);
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    protected void tryDespawn() {
        ++this.ticksInGround;
        if (this.ticksInGround >= 1200) {
            this.func_70106_y();
        }
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.onEntityHit((EntityRayTraceResult)raytraceResultIn);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockState blockstate;
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
            this.inBlockState = blockstate = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
            Vec3d vec3d = blockraytraceresult.func_216347_e().func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_213317_d(vec3d);
            Vec3d vec3d1 = vec3d.func_72432_b().func_186678_a((double)0.05f);
            this.field_70165_t -= vec3d1.field_72450_a;
            this.field_70163_u -= vec3d1.field_72448_b;
            this.field_70161_v -= vec3d1.field_72449_c;
            this.inGround = true;
            this.setPierceLevel((byte)0);
            this.setHitSound(SoundEvents.field_187731_t);
            this.func_213870_w();
            blockstate.func_215690_a(this.field_70170_p, blockstate, blockraytraceresult, (Entity)this);
        }
    }

    private void func_213870_w() {
        if (this.hitEntities != null) {
            this.hitEntities.clear();
        }
        if (this.piercedEntities != null) {
            this.piercedEntities.clear();
        }
    }

    protected void onEntityHit(EntityRayTraceResult entityRayTraceResult) {
        IndirectEntityDamageSource damagesource;
        Entity entity1;
        Entity entity = entityRayTraceResult.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        if (this.getPierceLevel() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.getPierceLevel() + 1) {
                this.func_70106_y();
                return;
            }
            this.piercedEntities.add(entity.func_145782_y());
        }
        if ((entity1 = this.getShooter()) == null) {
            damagesource = new IndirectEntityDamageSource("bullet", (Entity)this, (Entity)this);
        } else {
            damagesource = new IndirectEntityDamageSource("bullet", (Entity)this, entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        int j = entity.func_223314_ad();
        if (this.func_70027_ad() && !(entity instanceof EndermanEntity)) {
            entity.func_70015_d(5);
        }
        entity.field_70172_ad = 0;
        Vec3d entityMotion = entity.func_213322_ci();
        float f1 = (float)this.damage;
        if (entityRayTraceResult.func_216347_e().func_82617_b() > entity.field_70163_u - (double)entity.func_213302_cg() + (double)(2.0f * entity.func_70047_e())) {
            f1 *= 2.0326f;
        } else if (entity instanceof AbstractSkeletonEntity || entity instanceof SkeletonHorseEntity) {
            f1 /= 10.0f;
        }
        if (entity.func_70097_a((DamageSource)damagesource, f1)) {
            entity.func_213317_d(entityMotion);
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.field_70170_p.field_72995_K && this.getPierceLevel() <= 0) {
                    livingentity.func_85034_r(livingentity.func_85035_bI() + 1);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.arrowHit(livingentity);
                if (livingentity != entity1 && livingentity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                }
                if (!entity.func_70089_S() && this.hitEntities != null) {
                    this.hitEntities.add((Entity)livingentity);
                }
            }
            if (this.getPierceLevel() <= 0 && !(entity instanceof EndermanEntity)) {
                this.func_70106_y();
            }
        } else {
            entity.func_223308_g(j);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.ticksInAir = 0;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                this.func_70106_y();
            }
        }
    }

    protected SoundEvent getHitEntitySound() {
        return SoundEvents.field_187731_t;
    }

    protected final SoundEvent getHitGroundSound() {
        return this.hitSound;
    }

    protected void arrowHit(LivingEntity living) {
    }

    @Nullable
    protected EntityRayTraceResult rayTraceEntities(Vec3d startVec, Vec3d endVec) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)startVec, (Vec3d)endVec, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), p_213871_1_ -> !(p_213871_1_.func_175149_v() || !p_213871_1_.func_70089_S() || !p_213871_1_.func_70067_L() || p_213871_1_ == this.getShooter() && this.ticksInAir < 5 || this.piercedEntities != null && this.piercedEntities.contains(p_213871_1_.func_145782_y())));
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("life", (short)this.ticksInGround);
        if (this.inBlockState != null) {
            compound.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.inBlockState));
        }
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        compound.func_74780_a("damage", this.damage);
        compound.func_74774_a("PierceLevel", this.getPierceLevel());
        if (this.shootingEntity != null) {
            compound.func_186854_a("OwnerUUID", this.shootingEntity);
        }
        compound.func_74778_a("SoundEvent", Registry.field_212633_v.func_177774_c((Object)this.hitSound).toString());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.ticksInGround = compound.func_74765_d("life");
        if (compound.func_150297_b("inBlockState", 10)) {
            this.inBlockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("inBlockState"));
        }
        boolean bl = this.inGround = compound.func_74771_c("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        this.setPierceLevel(compound.func_74771_c("PierceLevel"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.shootingEntity = compound.func_186857_a("OwnerUUID");
        }
        if (compound.func_150297_b("SoundEvent", 8)) {
            this.hitSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(compound.func_74779_i("SoundEvent")));
        }
    }

    public void setShooter(@Nullable Entity entityIn) {
        this.shootingEntity = entityIn == null ? null : entityIn.func_110124_au();
    }

    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.field_70170_p instanceof ServerWorld ? ((ServerWorld)this.field_70170_p).func_217461_a(this.shootingEntity) : null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public double getDamage() {
        return this.damage;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    public void setPierceLevel(byte level) {
        this.field_70180_af.func_187227_b(PIERCE_LEVEL, (Object)level);
    }

    public byte getPierceLevel() {
        return (Byte)this.field_70180_af.func_187225_a(PIERCE_LEVEL);
    }

    public void setEnchantmentEffectsFromEntity(LivingEntity p_190547_1_, float p_190547_2_) {
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (LivingEntity)p_190547_1_);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (LivingEntity)p_190547_1_);
        this.setDamage((double)(p_190547_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.setDamage(this.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (LivingEntity)p_190547_1_) > 0) {
            this.func_70015_d(100);
        }
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        Entity entity = this.getShooter();
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        int id = this.getShooter() == null ? -1 : this.getShooter().func_145782_y();
        buffer.writeInt(id);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int id = additionalData.readInt();
        if (id != -1) {
            this.setShooter(Minecraft.func_71410_x().field_71441_e.func_73045_a(id));
        }
    }
}

