/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import piman.recievermod.capabilities.iteminventory.ItemInventory;

public class AmmoContainerInventory
implements IInventory,
IRecipeHelperPopulator {
    private final int slotsCount;
    private final NonNullList<ItemStack> inventoryContents;
    private List<IInventoryChangedListener> listeners;

    public AmmoContainerInventory(int numSlots) {
        this.slotsCount = numSlots;
        this.inventoryContents = NonNullList.func_191197_a((int)numSlots, (Object)ItemStack.field_190927_a);
    }

    public AmmoContainerInventory(ItemStack ... stacksIn) {
        this.slotsCount = stacksIn.length;
        this.inventoryContents = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])stacksIn);
    }

    public void addListener(IInventoryChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IInventoryChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventoryContents.size() ? (ItemStack)this.inventoryContents.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventoryContents, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_223374_a(Item p_223374_1_, int p_223374_2_) {
        ItemStack itemstack = new ItemStack((IItemProvider)p_223374_1_, 0);
        for (int i = this.slotsCount - 1; i >= 0; --i) {
            ItemStack itemstack1 = this.func_70301_a(i);
            if (!itemstack1.func_77973_b().equals(p_223374_1_)) continue;
            int j = p_223374_2_ - itemstack.func_190916_E();
            ItemStack itemstack2 = itemstack1.func_77979_a(j);
            itemstack.func_190917_f(itemstack2.func_190916_E());
            if (itemstack.func_190916_E() == p_223374_2_) break;
        }
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack addItem(ItemStack stack) {
        ItemStack itemstack = stack.func_77946_l();
        this.func_223372_c(itemstack);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_223375_b(itemstack);
        return itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventoryContents.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.slotsCount;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventoryContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_70296_d() {
        if (this.listeners != null) {
            for (IInventoryChangedListener iinventorychangedlistener : this.listeners) {
                iinventorychangedlistener.func_76316_a((IInventory)this);
            }
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        this.inventoryContents.clear();
        this.func_70296_d();
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.inventoryContents) {
            helper.func_194112_a(itemstack);
        }
    }

    public String toString() {
        return this.inventoryContents.stream().filter(p_223371_0_ -> !p_223371_0_.func_190926_b()).collect(Collectors.toList()).toString();
    }

    private void func_223375_b(ItemStack p_223375_1_) {
        for (int i = 0; i < this.slotsCount; ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (!itemstack.func_190926_b()) continue;
            this.func_70299_a(i, p_223375_1_.func_77946_l());
            p_223375_1_.func_190920_e(0);
            return;
        }
    }

    private void func_223372_c(ItemStack p_223372_1_) {
        for (int i = 0; i < this.slotsCount; ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)p_223372_1_)) continue;
            this.func_223373_a(p_223372_1_, itemstack);
            if (!p_223372_1_.func_190926_b()) continue;
            return;
        }
    }

    private void func_223373_a(ItemStack p_223373_1_, ItemStack p_223373_2_) {
        int i = this.func_70297_j_();
        int j = Math.min(p_223373_1_.func_190916_E(), i - p_223373_2_.func_190916_E());
        if (j > 0) {
            p_223373_2_.func_190917_f(j);
            p_223373_1_.func_190918_g(j);
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        ItemInventory.saveAllItems(nbt, this.inventoryContents, true);
        return nbt;
    }

    public void deserialize(CompoundNBT nbt) {
        ItemInventory.loadAllItems(nbt, this.inventoryContents);
    }
}

