/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.animations;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import piman.recievermod.Main;
import piman.recievermod.items.ItemPropertyWrapper;
import piman.recievermod.items.animations.AnimationControllerHammer;
import piman.recievermod.items.animations.AnimationControllerShoot;
import piman.recievermod.items.animations.IAnimationController;
import piman.recievermod.items.guns.ItemGun;
import piman.recievermod.keybinding.KeyInputHandler;
import piman.recievermod.network.NetworkHandler;
import piman.recievermod.network.messages.MessageAddToInventory;

public class AnimationControllerCylinder
implements IAnimationController {
    private final double friction;
    private final ItemGun itemGun;

    public AnimationControllerCylinder(ItemGun itemGun, double friction) {
        this.friction = friction;
        this.itemGun = itemGun;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onShootEvent(AnimationControllerShoot.ShootEvent event) {
        if (event.getGun() == this.itemGun) {
            int n;
            CompoundNBT nbt = event.getNbt();
            for (n = (int)(-Math.round(nbt.func_74769_h("theta"))) + 3; n < 1; n += 6) {
            }
            while (n > 6) {
                n -= 6;
            }
            if (event.getType() == AnimationControllerShoot.ShootEvent.Type.Pre) {
                if (this.getBullet(n, nbt) == 1) {
                    nbt.func_74778_a("BulletChambered", this.itemGun.ammo.get().getRegistryName().toString());
                } else {
                    nbt.func_74778_a("BulletChambered", "");
                }
            } else {
                this.setBullet(n, 2, nbt);
            }
        }
    }

    @SubscribeEvent
    public void onHammerDown(AnimationControllerHammer.HammerDownEvent event) {
        if (event.getGun() == this.itemGun) {
            event.getNbt().func_74780_a("theta", event.getNbt().func_74769_h("theta") + 1.0);
        }
    }

    @Override
    public List<ItemPropertyWrapper> getProperties() {
        ArrayList<ItemPropertyWrapper> list = new ArrayList<ItemPropertyWrapper>();
        list.add(IAnimationController.floatProperty("spin", true));
        list.add(IAnimationController.booleanProperty("open", true));
        list.add(IAnimationController.booleanProperty("eject", true));
        list.add(IAnimationController.integerProperty("bullet1", true));
        list.add(IAnimationController.integerProperty("bullet2", true));
        list.add(IAnimationController.integerProperty("bullet3", true));
        list.add(IAnimationController.integerProperty("bullet4", true));
        list.add(IAnimationController.integerProperty("bullet5", true));
        list.add(IAnimationController.integerProperty("bullet6", true));
        return list;
    }

    @Override
    public void update(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        double theta = nbt.func_74769_h("theta");
        double dtheta = nbt.func_74769_h("dtheta");
        double prevtheta = nbt.func_74775_l("prev").func_74769_h("theta");
        double prevdtheta = nbt.func_74775_l("prev").func_74769_h("dtheta");
        if (stack.equals(player.func_184614_ca())) {
            int k;
            if (KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.Shift)) {
                dtheta += (double)KeyInputHandler.getScroll();
            }
            KeyInputHandler.cancleScroll(KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.Shift));
            if (KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.RemoveMag)) {
                nbt.func_74757_a("open", !nbt.func_74767_n("open"));
            }
            if (KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.AddBullet) && nbt.func_74767_n("open") && (k = gun.findAmmo(player)) != -1) {
                int i;
                int n;
                for (n = (int)(-Math.round(theta)) + 2; n < 1; n += 6) {
                }
                while (n > 6) {
                    n -= 6;
                }
                for (i = 0; this.getBullet(n--, nbt) != 0 && i < 6; ++i) {
                    if (n >= 1) continue;
                    n += 6;
                }
                if (i < 6) {
                    this.setBullet(n + 1, 1, nbt);
                    ItemStack bullet = player.field_71071_by.func_70301_a(k);
                    NetworkHandler.sendToServer(new MessageAddToInventory(bullet, -1, k));
                }
            }
            if (KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.RemoveBullet) && nbt.func_74767_n("open")) {
                int i;
                int n;
                for (n = (int)(-Math.round(theta)) + 2; n < 1; n += 6) {
                }
                while (n > 6) {
                    n -= 6;
                }
                for (i = 0; this.getBullet(n--, nbt) == 0 && i < 6; ++i) {
                    if (n >= 1) continue;
                    n += 6;
                }
                if (i < 6) {
                    if (this.getBullet(n + 1, nbt) == 1) {
                        NetworkHandler.sendToServer(new MessageAddToInventory(gun.ammo.get(), 1));
                    } else {
                        NetworkHandler.sendToServer(new MessageAddToInventory(gun.ammo.get().getCasing(), 1));
                    }
                    this.setBullet(n + 1, 0, nbt);
                }
            }
        }
        double b = Math.sqrt(Math.abs(2.0 * this.friction * dtheta));
        double velocity = b - this.friction / 2.0;
        if (b / this.friction < 1.0) {
            dtheta = 0.0;
            theta -= prevdtheta;
            if (Math.abs(theta = (double)Math.round(theta)) >= 6.0) {
                prevtheta -= (double)(6 * Main.sign(theta));
                theta -= (double)(6 * Main.sign(theta));
            }
        } else {
            dtheta -= velocity * (double)Main.sign(dtheta);
            theta -= velocity * (double)Main.sign(dtheta);
        }
        nbt.func_74780_a("theta", theta);
        nbt.func_74780_a("dtheta", dtheta);
        nbt.func_74775_l("prev").func_74780_a("theta", prevtheta);
        nbt.func_74775_l("prev").func_74780_a("dtheta", prevdtheta);
        nbt.func_74776_a("spin", (float)theta - (nbt.func_74767_n("hammer") ? 0.5f : 1.0f));
        nbt.func_74775_l("prev").func_74776_a("spin", (float)prevtheta - (nbt.func_74775_l("prev").func_74767_n("hammer") ? 0.5f : 1.0f));
    }

    public int getBullet(int n, CompoundNBT nbt) {
        switch (n) {
            case 1: {
                return nbt.func_74762_e("bullet1");
            }
            case 2: {
                return nbt.func_74762_e("bullet2");
            }
            case 3: {
                return nbt.func_74762_e("bullet3");
            }
            case 4: {
                return nbt.func_74762_e("bullet4");
            }
            case 5: {
                return nbt.func_74762_e("bullet5");
            }
            case 6: {
                return nbt.func_74762_e("bullet6");
            }
        }
        return 0;
    }

    public void setBullet(int n, int flag, CompoundNBT nbt) {
        switch (n) {
            case 1: {
                nbt.func_74768_a("bullet1", flag);
                break;
            }
            case 2: {
                nbt.func_74768_a("bullet2", flag);
                break;
            }
            case 3: {
                nbt.func_74768_a("bullet3", flag);
                break;
            }
            case 4: {
                nbt.func_74768_a("bullet4", flag);
                break;
            }
            case 5: {
                nbt.func_74768_a("bullet5", flag);
                break;
            }
            case 6: {
                nbt.func_74768_a("bullet6", flag);
            }
        }
    }
}

