/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.animations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import piman.recievermod.items.ItemPropertyWrapper;
import piman.recievermod.items.animations.AnimationControllerHammer;
import piman.recievermod.items.animations.IAnimationController;
import piman.recievermod.items.guns.ItemGun;
import piman.recievermod.keybinding.KeyInputHandler;

public class AnimationControllerFireSelect
implements IAnimationController {
    private final LinkedHashSet<Modes> options;
    private final ItemGun itemgun;
    private final int maxBurstCount;

    public AnimationControllerFireSelect(ItemGun itemgun, Modes ... modes) {
        this.options = new LinkedHashSet<Modes>(Arrays.asList(modes));
        if (this.options.contains((Object)Modes.BURST)) {
            throw new IllegalArgumentException("Specified Burst Mode without specifying Burst Count");
        }
        this.itemgun = itemgun;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.maxBurstCount = 0;
    }

    public AnimationControllerFireSelect(ItemGun itemgun, int maxBurstCount, Modes ... modes) {
        this.options = new LinkedHashSet<Modes>(Arrays.asList(modes));
        if (!this.options.contains((Object)Modes.BURST)) {
            throw new IllegalArgumentException("Specified Burst Count without specifying Burst Mode");
        }
        this.itemgun = itemgun;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.maxBurstCount = maxBurstCount;
    }

    @Override
    public List<ItemPropertyWrapper> getProperties() {
        ArrayList<ItemPropertyWrapper> list = new ArrayList<ItemPropertyWrapper>();
        list.add(IAnimationController.integerProperty("mode", true));
        list.add(IAnimationController.integerProperty("modeindex", true));
        if (this.options.contains((Object)Modes.BURST)) {
            list.add(IAnimationController.integerProperty("burstcount", true));
        }
        return list;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onHammerDownEvent(AnimationControllerHammer.HammerDownEvent event) {
        if (event.getGun() == this.itemgun) {
            Modes mode = Modes.values()[event.getNbt().func_74762_e("mode")];
            if (mode == Modes.SAFETY) {
                event.setCanceled(true);
            } else if (mode == Modes.SEMI) {
                if (event.getNbt().func_74767_n("held")) {
                    event.setCanceled(true);
                }
            } else if (mode == Modes.BURST) {
                int burstCount = event.getNbt().func_74762_e("burstcount");
                if (event.getNbt().func_74767_n("held")) {
                    System.out.println("burst" + event.getNbt().func_74762_e("burstcount"));
                    if (burstCount >= this.maxBurstCount - 1) {
                        event.setCanceled(true);
                    } else {
                        event.getNbt().func_74768_a("burstcount", burstCount + 1);
                    }
                } else {
                    event.getNbt().func_74768_a("burstcount", 0);
                }
            }
        }
    }

    @Override
    public void update(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        boolean flag = player.func_184614_ca().equals(stack);
        if (flag && KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.Safety)) {
            nbt.func_74768_a("modeindex", (nbt.func_74762_e("modeindex") + 1) % this.options.size());
        }
        nbt.func_74768_a("mode", this.options.toArray(new Modes[0])[nbt.func_74762_e("modeindex")].ordinal());
    }

    public static enum Modes {
        SEMI,
        BURST,
        AUTO,
        SAFETY;

    }
}

