/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.animations;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import piman.recievermod.capabilities.itemdata.IItemData;
import piman.recievermod.capabilities.itemdata.ItemDataProvider;
import piman.recievermod.items.ItemPropertyWrapper;
import piman.recievermod.items.animations.AnimationControllerMag;
import piman.recievermod.items.animations.AnimationControllerShoot;
import piman.recievermod.items.animations.IAnimationController;
import piman.recievermod.items.guns.ItemGun;
import piman.recievermod.keybinding.KeyInputHandler;
import piman.recievermod.network.NetworkHandler;
import piman.recievermod.network.messages.MessageAddToInventory;
import piman.recievermod.network.messages.MessageEject;
import piman.recievermod.network.messages.MessagePlaySound;
import piman.recievermod.util.SoundsHandler;

public class AnimationControllerGarandAction
implements IAnimationController {
    private final ItemGun itemgun;
    private final Random rand = new Random();

    public AnimationControllerGarandAction(ItemGun itemgun) {
        this.itemgun = itemgun;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMagAdd(AnimationControllerMag.MagAddEvent event) {
        if (event.getGun() == this.itemgun) {
            if (event.getNbt().func_74762_e("slide") != 4) {
                event.setCanceled(true);
            } else if (!KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.RemoveBullet)) {
                event.getNbt().func_74757_a("AutoSlideLock", false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMagRemove(AnimationControllerMag.MagRemoveEvent event) {
        if (event.getGun() == this.itemgun && event.getNbt().func_74762_e("slide") != 4) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onShootEvent(AnimationControllerShoot.ShootEvent.Post event) {
        if (event.getGun() == this.itemgun) {
            event.getNbt().func_74768_a("slide", 4);
            event.getNbt().func_74775_l("prev").func_74768_a("slide", 0);
            NetworkHandler.sendToServer(new MessagePlaySound(SoundsHandler.ITEM_M1GARAND_ACTIONBACK));
        }
    }

    @Override
    public List<ItemPropertyWrapper> getProperties() {
        ArrayList<ItemPropertyWrapper> list = new ArrayList<ItemPropertyWrapper>();
        list.add(IAnimationController.integerProperty("slide", true));
        list.add(IAnimationController.integerProperty("check", false));
        return list;
    }

    @Override
    public void update(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        boolean flag = player.func_184614_ca().equals(stack);
        CompoundNBT baseTag = (CompoundNBT)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).map(IItemData::getItemData).orElse((Object)new CompoundNBT());
        if (nbt.func_74762_e("slide") < 4 && flag && KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.SlideLock) && KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.RemoveBullet)) {
            if (nbt.func_74762_e("check") < 4) {
                nbt.func_74768_a("check", nbt.func_74762_e("check") + 1);
            }
        } else if (nbt.func_74762_e("check") > 0) {
            nbt.func_74768_a("check", 0);
        }
        if (flag && KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.RemoveBullet)) {
            if (nbt.func_74762_e("slide") == 0) {
                NetworkHandler.sendToServer(new MessagePlaySound(SoundsHandler.ITEM_M1GARAND_ACTIONBACK));
            }
            if (nbt.func_74762_e("slide") < 4 && nbt.func_74762_e("check") < 4) {
                nbt.func_74768_a("slide", nbt.func_74762_e("slide") + 1);
            }
        }
        if (flag && KeyInputHandler.isKeyUnpressed(KeyInputHandler.KeyPresses.RemoveBullet) && nbt.func_74762_e("slide") == 4 && nbt.func_150295_c("bullets", 8).size() > 0 && (nbt.func_150295_c("bullets", 8).size() != 8 || this.rand.nextInt(3) != 0)) {
            nbt.func_74757_a("AutoSlideLock", false);
        }
        if (nbt.func_74762_e("slide") == 4) {
            ItemStack ammo;
            nbt.func_74757_a("hammer", true);
            if (nbt.func_74775_l("prev").func_74762_e("slide") < 4 && !nbt.func_74779_i("BulletChambered").isEmpty()) {
                NetworkHandler.sendToServer(new MessageEject(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("BulletChambered"))))));
                nbt.func_74778_a("BulletChambered", "");
            }
            if (nbt.func_150295_c("bullets", 8).size() == 0) {
                if (!nbt.func_74767_n("AutoSlideLock") && !nbt.func_74779_i("mag").isEmpty() && nbt.func_74775_l("prev").func_74762_e("slide") < 4) {
                    CompoundNBT magNBT = new CompoundNBT();
                    magNBT.func_218657_a("bullets", (INBT)nbt.func_150295_c("bullets", 8));
                    magNBT.func_74778_a("UUID", nbt.func_74779_i("mag"));
                    nbt.func_74768_a("bullets", 0);
                    nbt.func_74778_a("mag", "");
                    ItemStack mag = new ItemStack((IItemProvider)gun.mag.get());
                    mag.func_196082_o().func_74778_a("UUID", magNBT.func_74779_i("UUID"));
                    baseTag.func_218657_a(magNBT.func_74779_i("UUID"), (INBT)magNBT);
                    NetworkHandler.sendToServer(new MessageEject(mag));
                    NetworkHandler.sendToServer(new MessagePlaySound(SoundsHandler.ITEM_M1GARAND_CLIPEJECT));
                }
                nbt.func_74757_a("AutoSlideLock", true);
            }
            if (flag && KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.AddBullet) && !nbt.func_74779_i("mag").isEmpty() && !nbt.func_74775_l("prev").func_74779_i("mag").isEmpty() && nbt.func_150295_c("bullets", 8).size() < 8 && !(ammo = gun.mag.get().findAmmo(player)).func_190926_b()) {
                nbt.func_150295_c("bullets", 8).add((Object)new StringNBT(ammo.func_77973_b().getRegistryName().toString()));
                NetworkHandler.sendToServer(new MessageAddToInventory(ammo, -1));
                if (nbt.func_150295_c("bullets", 8).size() < 8) {
                    nbt.func_74757_a("AutoSlideLock", false);
                } else {
                    nbt.func_74757_a("AutoSlideLock", true);
                }
            }
        }
        if (!KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.RemoveBullet)) {
            if (flag && KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.SlideLock)) {
                nbt.func_74757_a("AutoSlideLock", false);
            }
            if (nbt.func_74762_e("slide") == 4 && nbt.func_74767_n("AutoSlideLock")) {
                nbt.func_74768_a("slide", 4);
                if (flag && KeyInputHandler.isKeyUnpressed(KeyInputHandler.KeyPresses.RemoveBullet)) {
                    NetworkHandler.sendToServer(new MessagePlaySound(SoundsHandler.ITEM_M1GARAND_ACTIONCATCH));
                }
            }
            if (nbt.func_74762_e("slide") > 0 && !nbt.func_74767_n("AutoSlideLock")) {
                if (nbt.func_150295_c("bullets", 8).size() > 0 && nbt.func_74779_i("BulletChambered").isEmpty()) {
                    nbt.func_74778_a("BulletChambered", nbt.func_150295_c("bullets", 8).func_150307_f(nbt.func_150295_c("bullets", 8).size() - 1));
                    nbt.func_150295_c("bullets", 8).remove(nbt.func_150295_c("bullets", 8).size() - 1);
                    System.out.println("pickup");
                }
                nbt.func_74768_a("slide", 0);
                if (!nbt.func_74767_n("fired")) {
                    NetworkHandler.sendToServer(new MessagePlaySound(SoundsHandler.ITEM_M1GARAND_ACTIONFORWARD));
                }
            }
        }
        if (nbt.func_74762_e("slide") == 0) {
            nbt.func_74757_a("AutoSlideLock", false);
        }
    }
}

