/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.animations;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import piman.recievermod.items.ItemPropertyWrapper;
import piman.recievermod.items.animations.AnimationControllerShoot;
import piman.recievermod.items.animations.IAnimationController;
import piman.recievermod.items.guns.ItemGun;
import piman.recievermod.keybinding.KeyInputHandler;

public class AnimationControllerHammer
implements IAnimationController {
    private final boolean doubleAction;
    private final ItemGun itemGun;

    public AnimationControllerHammer(ItemGun itemGun, boolean doubleAction) {
        this.doubleAction = doubleAction;
        this.itemGun = itemGun;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private boolean onHammerHit(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        HammerHitEvent event = new HammerHitEvent(stack, worldIn, player, itemSlot, isSelected, nbt, gun);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    private boolean onHammerDown(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        HammerDownEvent event = new HammerDownEvent(stack, worldIn, player, itemSlot, isSelected, nbt, gun);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @SubscribeEvent
    public void onShootEvent(AnimationControllerShoot.ShootEvent.Post event) {
        if (event.getGun() == this.itemGun) {
            event.getNbt().func_74757_a("held", true);
        }
    }

    @Override
    public List<ItemPropertyWrapper> getProperties() {
        ArrayList<ItemPropertyWrapper> list = new ArrayList<ItemPropertyWrapper>();
        list.add(IAnimationController.booleanProperty("hammer", true));
        return list;
    }

    @Override
    public void update(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        boolean flag = player.func_184614_ca().equals(stack);
        if (flag) {
            if (KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.Hammer)) {
                nbt.func_74757_a("hammer", true);
            }
            if (KeyInputHandler.isKeyUnpressed(KeyInputHandler.KeyPresses.Hammer) && KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.LeftClick) && this.onHammerDown(stack, worldIn, player, itemSlot, isSelected, nbt, gun)) {
                nbt.func_74757_a("hammer", false);
            }
            if (nbt.func_74767_n("hammer") && KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.LeftClick) && !KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.Hammer) && this.onHammerDown(stack, worldIn, player, itemSlot, isSelected, nbt, gun) && this.onHammerHit(stack, worldIn, player, itemSlot, isSelected, nbt, gun)) {
                nbt.func_74757_a("hammer", false);
            } else if (this.doubleAction && !nbt.func_74767_n("hammer") && KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.LeftClick)) {
                nbt.func_74757_a("hammer", true);
            }
            if (KeyInputHandler.isKeyUnpressed(KeyInputHandler.KeyPresses.LeftClick)) {
                nbt.func_74757_a("held", false);
            }
        }
    }

    public static class HammerDownEvent
    extends IAnimationController.AnimationEvent {
        public HammerDownEvent(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
            super(stack, world, player, itemSlot, isSelected, nbt, gun);
        }
    }

    public static class HammerHitEvent
    extends IAnimationController.AnimationEvent {
        public HammerHitEvent(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
            super(stack, world, player, itemSlot, isSelected, nbt, gun);
        }
    }
}

