/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.animations;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import piman.recievermod.capabilities.itemdata.IItemData;
import piman.recievermod.capabilities.itemdata.ItemDataProvider;
import piman.recievermod.items.ItemPropertyWrapper;
import piman.recievermod.items.animations.IAnimationController;
import piman.recievermod.items.guns.ItemGun;
import piman.recievermod.keybinding.KeyInputHandler;
import piman.recievermod.network.NetworkHandler;
import piman.recievermod.network.messages.MessageAddToInventory;
import piman.recievermod.network.messages.MessagePlaySound;
import piman.recievermod.util.SoundsHandler;

public class AnimationControllerMag
implements IAnimationController {
    private boolean onMagAdd(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        MagAddEvent event = new MagAddEvent(stack, world, player, itemSlot, isSelected, nbt, gun);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    private boolean onMagRemoved(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        MagRemoveEvent event = new MagRemoveEvent(stack, world, player, itemSlot, isSelected, nbt, gun);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public List<ItemPropertyWrapper> getProperties() {
        ArrayList<ItemPropertyWrapper> list = new ArrayList<ItemPropertyWrapper>();
        list.add(IAnimationController.stringProperty("mag", true));
        list.add(IAnimationController.listCountProperty("bullets", 8, true));
        return list;
    }

    @Override
    public void update(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        ItemStack mag;
        boolean flag = player.func_184614_ca().equals(stack);
        CompoundNBT baseTag = (CompoundNBT)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).map(IItemData::getItemData).orElse((Object)new CompoundNBT());
        if (flag && KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.AddBullet) && nbt.func_74779_i("mag").isEmpty()) {
            System.out.println("Add Mag Pressed");
            int magslot = gun.findFullestMag(player, baseTag);
            if (magslot != -1 && this.onMagAdd(stack, worldIn, player, itemSlot, isSelected, nbt, gun)) {
                mag = player.field_71071_by.func_70301_a(magslot);
                NetworkHandler.sendToServer(new MessageAddToInventory(mag, -1, magslot));
                CompoundNBT magTag = baseTag.func_74775_l(mag.func_196082_o().func_74779_i("UUID"));
                nbt.func_218657_a("bullets", (INBT)magTag.func_150295_c("bullets", 8));
                nbt.func_74778_a("mag", magTag.func_74779_i("UUID"));
                NetworkHandler.sendToServer(new MessagePlaySound(SoundsHandler.ITEM_GLOCK_MAGIN));
            }
        }
        if (flag && KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.RemoveMag)) {
            if (!nbt.func_74779_i("mag").isEmpty()) {
                if (this.onMagRemoved(stack, worldIn, player, itemSlot, isSelected, nbt, gun)) {
                    CompoundNBT magNBT = new CompoundNBT();
                    magNBT.func_218657_a("bullets", (INBT)nbt.func_150295_c("bullets", 8));
                    magNBT.func_74778_a("UUID", nbt.func_74779_i("mag"));
                    nbt.func_74768_a("bullets", 0);
                    nbt.func_74778_a("mag", "");
                    mag = new ItemStack((IItemProvider)gun.mag.get());
                    mag.func_196082_o().func_74778_a("UUID", magNBT.func_74779_i("UUID"));
                    baseTag.func_218657_a(magNBT.func_74779_i("UUID"), (INBT)magNBT);
                    NetworkHandler.sendToServer(new MessageAddToInventory(mag, 1, player.field_71071_by.func_70302_i_() - 1));
                    NetworkHandler.sendToServer(new MessagePlaySound(SoundsHandler.ITEM_GLOCK_MAGOUT));
                }
            } else if (gun.isMag(player.func_184592_cb())) {
                TreeMap<Integer, Pair> mags = new TreeMap<Integer, Pair>();
                for (int i = 0; i < player.field_71071_by.func_70302_i_() - 1; ++i) {
                    ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                    if (!gun.isMag(itemstack)) continue;
                    mags.put(baseTag.func_74775_l(itemstack.func_196082_o().func_74779_i("UUID")).func_150295_c("bullets", 8).size(), Pair.of((Object)itemstack, (Object)i));
                }
                if (!mags.isEmpty()) {
                    int slot = (Integer)((Pair)mags.lastEntry().getValue()).getRight();
                    ItemStack oldstack = player.func_184592_cb();
                    ItemStack newstack = (ItemStack)((Pair)mags.lastEntry().getValue()).getLeft();
                    NetworkHandler.sendToServer(new MessageAddToInventory(newstack, -1, slot));
                    NetworkHandler.sendToServer(new MessageAddToInventory(oldstack, -1, player.field_71071_by.func_70302_i_() - 1));
                    NetworkHandler.sendToServer(new MessageAddToInventory(oldstack, 1, slot));
                    NetworkHandler.sendToServer(new MessageAddToInventory(newstack, 1, player.field_71071_by.func_70302_i_() - 1));
                }
            }
        }
    }

    public static class MagRemoveEvent
    extends IAnimationController.AnimationEvent {
        public MagRemoveEvent(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
            super(stack, world, player, itemSlot, isSelected, nbt, gun);
        }
    }

    public static class MagAddEvent
    extends IAnimationController.AnimationEvent {
        public MagAddEvent(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
            super(stack, world, player, itemSlot, isSelected, nbt, gun);
        }
    }
}

