/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.animations;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import piman.recievermod.items.ItemPropertyWrapper;
import piman.recievermod.items.animations.AnimationControllerFireSelect;
import piman.recievermod.items.animations.AnimationControllerHammer;
import piman.recievermod.items.animations.IAnimationController;
import piman.recievermod.items.guns.ItemGun;
import piman.recievermod.keybinding.KeyInputHandler;
import piman.recievermod.network.NetworkHandler;
import piman.recievermod.network.messages.MessagePlaySound;
import piman.recievermod.util.FlashHandler;
import piman.recievermod.util.SoundsHandler;

public class AnimationControllerShoot
implements IAnimationController {
    public final Condition condition;
    public final ItemGun itemGun;

    public AnimationControllerShoot(ItemGun itemGun, Condition condition) {
        this.condition = condition;
        this.itemGun = itemGun;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHammerDown(AnimationControllerHammer.HammerDownEvent event) {
        if (event.getGun() == this.itemGun && !this.condition.apply(event.getNbt())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHammerHit(AnimationControllerHammer.HammerHitEvent event) {
        if (event.getGun() == this.itemGun) {
            if (this.condition.apply(event.getNbt())) {
                if (this.onShootEventPre(event.getStack(), event.getWorld(), event.getPlayer(), event.getItemSlot(), event.isSelected(), event.getNbt(), event.getGun())) {
                    boolean flag = this.itemGun.Shoot(event.getNbt(), (LivingEntity)event.getPlayer(), 10.0, this.getEntityAccuracy(event), event.getGun().getAccuracy(), 1);
                    if (flag) {
                        this.onShootEventPost(event.getStack(), event.getWorld(), event.getPlayer(), event.getItemSlot(), event.isSelected(), event.getNbt(), event.getGun());
                        if (event.getNbt().func_74762_e("mode") == AnimationControllerFireSelect.Modes.AUTO.ordinal() && !KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.LeftClick)) {
                            FlashHandler.CreateFlash(new BlockPos(event.getPlayer().field_70165_t, event.getPlayer().field_70163_u + 1.0, event.getPlayer().field_70161_v), event.getPlayer().field_71093_bK.func_186068_a(), 1);
                        } else {
                            FlashHandler.CreateFlash(new BlockPos(event.getPlayer().field_70165_t, event.getPlayer().field_70163_u + 1.0, event.getPlayer().field_70161_v), event.getPlayer().field_71093_bK.func_186068_a(), 2);
                        }
                        event.getNbt().func_74757_a("fired", true);
                    } else {
                        NetworkHandler.sendToServer(new MessagePlaySound(SoundsHandler.ITEM_GLOCK_DRY));
                    }
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public List<ItemPropertyWrapper> getProperties() {
        ArrayList<ItemPropertyWrapper> list = new ArrayList<ItemPropertyWrapper>();
        list.add(IAnimationController.booleanProperty("fired", false));
        return list;
    }

    @Override
    public void update(ItemStack stack, World worldIn, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        if (nbt.func_74775_l("prev").func_74767_n("fired")) {
            nbt.func_74757_a("fired", false);
        }
    }

    public float getEntityAccuracy(IAnimationController.AnimationEvent event) {
        Vec3d motion = event.getPlayer().func_213322_ci();
        motion.func_186678_a(20.0);
        motion.func_72441_c(0.0, 1.568, 0.0);
        return (float)((double)(event.getNbt().func_74767_n("ads") ? 1.0f : 10.0f) * motion.func_72433_c());
    }

    private boolean onShootEventPre(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        ShootEvent.Pre event = new ShootEvent.Pre(stack, world, player, itemSlot, isSelected, nbt, gun);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    private void onShootEventPost(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
        ShootEvent.Post event = new ShootEvent.Post(stack, world, player, itemSlot, isSelected, nbt, gun);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static class ShootEvent
    extends IAnimationController.AnimationEvent {
        protected Type type;

        public ShootEvent(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
            super(stack, world, player, itemSlot, isSelected, nbt, gun);
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            Pre,
            Post;

        }

        public static class Post
        extends ShootEvent {
            public Post(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
                super(stack, world, player, itemSlot, isSelected, nbt, gun);
                this.type = Type.Post;
            }

            @Override
            public boolean isCancelable() {
                return false;
            }
        }

        public static class Pre
        extends ShootEvent {
            public Pre(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
                super(stack, world, player, itemSlot, isSelected, nbt, gun);
                this.type = Type.Pre;
            }
        }
    }

    public static interface Condition {
        public boolean apply(CompoundNBT var1);
    }
}

